/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.computer;

import com.mrcrayfish.furniture.refurbished.blockentity.IComputer;
import com.mrcrayfish.furniture.refurbished.computer.IService;
import com.mrcrayfish.furniture.refurbished.computer.Program;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.class_2960;

public class Computer {
    private static Computer instance;
    private final Map<class_2960, BiFunction<class_2960, IComputer, Program>> programs = new LinkedHashMap<class_2960, BiFunction<class_2960, IComputer, Program>>();
    private final List<IService> services = new ArrayList<IService>();

    public static Computer get() {
        if (instance == null) {
            instance = new Computer();
        }
        return instance;
    }

    public void installProgram(class_2960 id, BiFunction<class_2960, IComputer, Program> program) {
        this.programs.putIfAbsent(id, program);
    }

    public void installService(IService service) {
        this.services.add(service);
    }

    public Optional<Program> createProgramInstance(class_2960 id, IComputer computer) {
        return Optional.ofNullable(this.programs.get(id)).map(function -> (Program)function.apply(id, computer));
    }

    public Set<class_2960> getPrograms() {
        return this.programs.keySet();
    }

    public List<IService> getServices() {
        return this.services;
    }
}

