/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.overlay;

import com.mrcrayfish.furniture.refurbished.Components;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.client.LinkHandler;
import com.mrcrayfish.furniture.refurbished.client.gui.overlay.IHudOverlay;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.IconButton;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9779;

public class NodeIndicatorOverlay
implements IHudOverlay {
    @Override
    public void draw(class_332 graphics, class_9779 deltaTracker) {
        IElectricityNode node1;
        class_3965 result;
        class_2586 entity;
        Connection connection;
        IElectricityNode linking;
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1765 == null) {
            return;
        }
        if (mc.field_1724 == null) {
            return;
        }
        LinkHandler handler = LinkHandler.get();
        IElectricityNode target = handler.getTargetNode();
        if (handler.isLinking()) {
            double linkLength = handler.getLinkLength();
            if (linkLength > 512.0) {
                this.drawLabel(mc, graphics, Components.GUI_LINK_TOO_LONG, 40, 0);
                return;
            }
            linking = handler.getLinkingNode((class_1937)mc.field_1687);
            if (target != null && linking != null && target != linking) {
                if (target.isSourceNode() && linking.isSourceNode()) {
                    this.drawLabel(mc, graphics, Components.GUI_LINK_INVALID_NODE, 40, 0);
                    return;
                }
                int nodeLinkLength = (int)(linking.getNodePosition().method_46558().method_1022(target.getNodePosition().method_46558()) + 0.5);
                if ((double)nodeLinkLength > 512.0) {
                    this.drawLabel(mc, graphics, Components.GUI_LINK_TOO_LONG, 40, 0);
                    return;
                }
                if (target.isNodeConnectionLimitReached()) {
                    this.drawLabel(mc, graphics, Components.GUI_LINK_TOO_MANY, 40, 0);
                    return;
                }
                if (handler.canLinkToNode((class_1937)mc.field_1687, target)) {
                    if (!handler.isLinkInsidePowerableArea()) {
                        this.drawLabel(mc, graphics, Components.GUI_LINK_UNPOWERABLE, 30, 0);
                        return;
                    }
                    class_5250 label = Utils.translation("gui", "progress", target.getNodeConnections().size(), Components.GUI_SLASH, target.getNodeMaximumConnections());
                    this.drawLabel(mc, graphics, (class_2561)label, 0, 10);
                    return;
                }
            }
            if (!handler.isLinkInsidePowerableArea()) {
                this.drawLabel(mc, graphics, Components.GUI_LINK_OUTSIDE_AREA, 40, 0);
                return;
            }
        } else if (target != null) {
            class_5250 label = Utils.translation("gui", "progress", target.getNodeConnections().size(), Components.GUI_SLASH, target.getNodeMaximumConnections());
            this.drawLabel(mc, graphics, (class_2561)label, 0, 10);
            return;
        }
        if ((connection = handler.getTargetConnection()) != null && connection.isCrossingPowerableZone((class_1937)mc.field_1687)) {
            this.drawLabel(mc, graphics, Components.GUI_LINK_OUTSIDE_AREA, 40, 0);
            return;
        }
        if (!LinkHandler.isHoldingWrench() && (linking = mc.field_1765) instanceof class_3965 && (entity = mc.field_1687.method_8321((result = (class_3965)linking).method_17777())) instanceof IElectricityNode && !(node1 = (IElectricityNode)entity).isNodeInPowerableNetwork() && !((Boolean)Config.SERVER.electricity.cheats.everythingIsPowered.get()).booleanValue()) {
            this.drawLabel(mc, graphics, Components.GUI_NO_POWER, 20, 20);
        }
    }

    private void drawLabel(class_310 mc, class_332 graphics, class_2561 label, int iconU, int iconV) {
        int padding = 3;
        int iconSize = 10;
        int messageWidth = mc.field_1772.method_27525((class_5348)label);
        int contentWidth = padding + iconSize + padding + messageWidth + padding;
        Objects.requireNonNull(mc.field_1772);
        int contentHeight = padding + 9 + padding;
        int contentStart = (graphics.method_51421() - contentWidth) / 2;
        int contentTop = (graphics.method_51443() - contentHeight) / 2 + 50;
        graphics.method_25294(contentStart, contentTop + 1, contentStart + 1, contentTop + contentHeight - 1, 0x77000000);
        graphics.method_25294(contentStart + 1, contentTop, contentStart + contentWidth - 1, contentTop + contentHeight, 0x77000000);
        graphics.method_25294(contentStart + contentWidth - 1, contentTop + 1, contentStart + contentWidth, contentTop + contentHeight - 1, 0x77000000);
        graphics.method_25290(class_10799.field_56883, IconButton.ICON_TEXTURES, contentStart + padding, contentTop + padding, (float)iconU, (float)iconV, iconSize, iconSize, 64, 64);
        graphics.method_27535(mc.field_1772, label, contentStart + padding + iconSize + padding, contentTop + padding + 1, -1);
    }
}

