/*
 * Decompiled with CFR 0.152.
 */
package dev.rvbsm.fsit.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import dev.rvbsm.fsit.api.event.PassedUseBlockCallback;
import dev.rvbsm.fsit.api.event.PassedUseEntityCallback;
import dev.rvbsm.fsit.api.network.RidingRequestHandler;
import dev.rvbsm.fsit.api.player.PlayerConfig;
import dev.rvbsm.fsit.api.player.PlayerLastSneakTime;
import dev.rvbsm.fsit.api.player.PlayerPose;
import dev.rvbsm.fsit.config.OnSneak;
import dev.rvbsm.fsit.entity.ModPose;
import dev.rvbsm.fsit.networking.payload.RidingResponseC2SPayload;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3965;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3244.class})
public abstract class ServerPlayNetworkHandlerMixin
implements RidingRequestHandler {
    @Unique
    private final Map<UUID, CompletableFuture<Boolean>> pendingRidingRequests = new WeakHashMap<UUID, CompletableFuture<Boolean>>();
    @Shadow
    public class_3222 field_14140;

    /*
     * WARNING - void declaration
     */
    @ModifyArg(method={"onPlayerInput"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;setSneaking(Z)V"))
    public boolean onPlayerInput(boolean sneaking) {
        void var1_1;
        if (sneaking && this.updateSneaking()) {
            return false;
        }
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Unique
    private boolean updateSneaking() {
        void var1_1;
        PlayerLastSneakTime playerSneak = (PlayerLastSneakTime)this.field_14140;
        OnSneak sneakConfig = ((PlayerConfig)this.field_14140).fsit$getConfig().getOnSneak();
        if (!sneakConfig.getSitting() && !sneakConfig.getCrawling()) {
            return false;
        }
        if ((double)this.field_14140.method_36455() < sneakConfig.getMinPitch()) {
            return false;
        }
        if (this.field_14140.method_5765() || !this.field_14140.method_24828()) {
            return false;
        }
        if (class_156.method_658() - playerSneak.fsit$getLastSneakTime() <= sneakConfig.getDelay()) {
            void var2_2;
            ModPose modPose;
            if (sneakConfig.getCrawling() && this.isPlayerNearGap()) {
                modPose = ModPose.Crawling;
            } else if (((OnSneak)((Object)modPose)).getSitting()) {
                modPose = ModPose.Sitting;
            } else {
                return false;
            }
            playerSneak.fsit$resetLastSneakTime();
            ((PlayerPose)this.field_14140).fsit$setPose((ModPose)var2_2, this.field_14140.method_19538());
            return true;
        }
        var1_1.fsit$updateLastSneakTime();
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Unique
    private boolean isPlayerNearGap() {
        void var2_2;
        void var1_1;
        void var3_4;
        class_4048 crawlingDimensions = this.field_14140.method_18377(class_4050.field_18079);
        class_4048 crouchingDimensions = this.field_14140.method_18377(class_4050.field_18081);
        double yawRadians = (double)(this.field_14140.method_36454() / 180.0f) * Math.PI;
        double offsetX = -Math.sin(yawRadians) * 0.1;
        double offsetZ = Math.cos(yawRadians) * 0.1;
        class_243 playerPos = this.field_14140.method_19538();
        class_243 expectEmptyAt = playerPos.method_1031(offsetX, 0.0, offsetZ);
        class_243 expectFullAt = playerPos.method_1031(offsetX, (double)crouchingDimensions.comp_2186(), offsetZ);
        class_3218 world = this.field_14140.method_51469();
        return world.method_8587((class_1297)this.field_14140, crawlingDimensions.method_30757(expectEmptyAt).method_1011(1.0E-6)) && !var3_4.method_8587((class_1297)this.field_14140, var1_1.method_30757((class_243)var2_2).method_1011(1.0E-6));
    }

    /*
     * WARNING - void declaration
     */
    @ModifyVariable(method={"onPlayerInteractBlock"}, at=@At(value="STORE"))
    private class_1269 interactBlock(class_1269 interactionActionResult, @Local class_3218 world, @Local LocalRef<class_1268> handRef, @Local class_3965 blockHitResult) {
        void var1_1;
        if (interactionActionResult == class_1269.field_5811 && handRef.get() == class_1268.field_5810 && this.field_14140.method_5998((class_1268)handRef.get()).method_7976().ordinal() == 0) {
            void var2_2;
            void var3_3;
            var3_3.set((Object)class_1268.field_5808);
            return ((PassedUseBlockCallback)PassedUseBlockCallback.EVENT.invoker()).interact(this.field_14140, (class_1937)var2_2, blockHitResult);
        }
        return var1_1;
    }

    @Inject(method={"onDisconnected"}, at={@At(value="TAIL")})
    public void purgePendingRequests(CallbackInfo ci) {
        this.pendingRidingRequests.forEach((uuid, future) -> future.complete(Boolean.FALSE));
        this.pendingRidingRequests.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompletableFuture<Boolean> fsit$newRidingRequest(@NotNull UUID playerUUID, @NotNull Duration timeout) {
        void var2_2;
        void var1_1;
        void var3_3;
        CompletableFuture<Boolean> pendingFuture = this.pendingRidingRequests.get(playerUUID);
        if (pendingFuture != null && !var3_3.isDone()) {
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
        CompletableFuture<Boolean> ridingResponse = new CompletableFuture<Boolean>().completeOnTimeout(Boolean.FALSE, timeout.toMillis(), TimeUnit.MILLISECONDS);
        this.pendingRidingRequests.put((UUID)var1_1, ridingResponse);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fsit$completeRidingRequest(@NotNull RidingResponseC2SPayload response2) {
        CompletableFuture<Boolean> future = this.pendingRidingRequests.remove(response2.getUuid());
        if (future != null && !future.isDone()) {
            void var1_1;
            void var2_2;
            var2_2.complete(var1_1.getResponse().isAccepted());
        }
    }

    @Mixin(targets={"net.minecraft.server.network.ServerPlayNetworkHandler$1"})
    public static abstract class PlayerInteractEntityC2SPacketHandler {
        @Shadow
        @Final
        class_3244 field_28963;
        @Shadow
        @Final
        class_1297 field_28962;
        @Shadow
        @Final
        class_3218 field_39991;

        /*
         * WARNING - void declaration
         */
        @ModifyVariable(method={"processInteract"}, at=@At(value="STORE"))
        private class_1269 interactPlayer(class_1269 interactionActionResult, @Local(argsOnly=true) LocalRef<class_1268> handRef) {
            void var1_1;
            if (interactionActionResult == class_1269.field_5811 && handRef.get() == class_1268.field_5810 && this.field_28963.field_14140.method_5998((class_1268)handRef.get()).method_7976().ordinal() == 0) {
                void var2_2;
                var2_2.set((Object)class_1268.field_5808);
                return ((PassedUseEntityCallback)PassedUseEntityCallback.EVENT.invoker()).interact(this.field_28963.field_14140, this.field_39991, this.field_28962);
            }
            return var1_1;
        }
    }
}

