/*
 * Decompiled with CFR 0.152.
 */
package dev.rvbsm.fsit.lib.kaml;

import dev.rvbsm.fsit.lib.kaml.Location;
import dev.rvbsm.fsit.lib.kaml.YamlPathSegment;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\r\b\u0086\b\u0018\u0000 02\u00020\u0001:\u00010B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0016\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0007\"\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0015\u0010\fJ\u001d\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0017\u0010\u0014J\u001d\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0018\u0010\u0014J\u0015\u0010\u0019\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0019\u0010\fJ\u0017\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001d\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001f\u0010 J \u0010!\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0001\u00a2\u0006\u0004\b!\u0010\"J\u001a\u0010%\u001a\u00020$2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b%\u0010&J\u0010\u0010'\u001a\u00020\rH\u00d6\u0001\u00a2\u0006\u0004\b'\u0010(J\u0010\u0010)\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b)\u0010\u001eR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010*\u001a\u0004\b+\u0010 R\u0017\u0010,\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\u00a8\u00061"}, d2={"Ldev/rvbsm/fsit/lib/kaml/YamlPath;", "", "", "Ldev/rvbsm/fsit/lib/kaml/YamlPathSegment;", "segments", "<init>", "(Ljava/util/List;)V", "", "([Lcom/charleskorn/kaml/YamlPathSegment;)V", "Ldev/rvbsm/fsit/lib/kaml/Location;", "location", "withError", "(Ldev/rvbsm/fsit/lib/kaml/Location;)Ldev/rvbsm/fsit/lib/kaml/YamlPath;", "", "index", "withListEntry", "(ILdev/rvbsm/fsit/lib/kaml/Location;)Ldev/rvbsm/fsit/lib/kaml/YamlPath;", "", "key", "withMapElementKey", "(Ljava/lang/String;Ldev/rvbsm/fsit/lib/kaml/Location;)Ldev/rvbsm/fsit/lib/kaml/YamlPath;", "withMapElementValue", "name", "withAliasReference", "withAliasDefinition", "withMerge", "segment", "withSegment", "(Ldev/rvbsm/fsit/lib/kaml/YamlPathSegment;)Ldev/rvbsm/fsit/lib/kaml/YamlPath;", "toHumanReadableString", "()Ljava/lang/String;", "component1", "()Ljava/util/List;", "copy", "(Ljava/util/List;)Ldev/rvbsm/fsit/lib/kaml/YamlPath;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "toString", "Ljava/util/List;", "getSegments", "endLocation", "Ldev/rvbsm/fsit/lib/kaml/Location;", "getEndLocation", "()Lcom/charleskorn/kaml/Location;", "Companion", "kaml"})
public final class YamlPath {
    @NotNull
    public static final Companion Companion = new Companion(0);
    @NotNull
    private final List<YamlPathSegment> segments;
    @NotNull
    private final Location endLocation;
    @NotNull
    private static final YamlPath root;

    /*
     * WARNING - void declaration
     */
    public YamlPath(@NotNull List<? extends YamlPathSegment> segments) {
        void var1_1;
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        this.segments = var1_1;
        if (this.segments.isEmpty()) {
            throw new IllegalArgumentException("Path must contain at least one segment.");
        }
        if (!(CollectionsKt.first(this.segments) instanceof YamlPathSegment.Root) && !(CollectionsKt.first(this.segments) instanceof YamlPathSegment.AliasDefinition)) {
            throw new IllegalArgumentException("First element of path must be root segment or alias definition.");
        }
        if (CollectionsKt.drop((Iterable)this.segments, (int)1).contains(YamlPathSegment.Root.INSTANCE)) {
            throw new IllegalArgumentException("Root segment can only be first element of path.");
        }
        this.endLocation = ((YamlPathSegment)CollectionsKt.last(this.segments)).getLocation();
    }

    @NotNull
    public final List<YamlPathSegment> getSegments() {
        return this.segments;
    }

    /*
     * WARNING - void declaration
     */
    public YamlPath(YamlPathSegment ... segments) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)segments, (String)"segments");
        this(ArraysKt.toList((Object[])var1_1));
    }

    @NotNull
    public final Location getEndLocation() {
        return this.endLocation;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final YamlPath withError(@NotNull Location location) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.withSegment(new YamlPathSegment.Error((Location)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final YamlPath withListEntry(int index, @NotNull Location location) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.withSegment(new YamlPathSegment.ListEntry((int)var1_1, (Location)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final YamlPath withMapElementKey(@NotNull String key, @NotNull Location location) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.withSegment(new YamlPathSegment.MapElementKey((String)var1_1, (Location)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final YamlPath withMapElementValue(@NotNull Location location) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.withSegment(new YamlPathSegment.MapElementValue((Location)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final YamlPath withAliasReference(@NotNull String name, @NotNull Location location) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.withSegment(new YamlPathSegment.AliasReference((String)var1_1, (Location)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final YamlPath withAliasDefinition(@NotNull String name, @NotNull Location location) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.withSegment(new YamlPathSegment.AliasDefinition((String)var1_1, (Location)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final YamlPath withMerge(@NotNull Location location) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.withSegment(new YamlPathSegment.Merge((Location)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private final YamlPath withSegment(YamlPathSegment segment) {
        void var1_1;
        return new YamlPath(CollectionsKt.plus((Collection)this.segments, (Object)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toHumanReadableString() {
        StringBuilder builder = new StringBuilder();
        int nextSegmentIndex = 1;
        while (nextSegmentIndex <= CollectionsKt.getLastIndex(this.segments)) {
            void var3_3;
            int segmentIndex;
            YamlPathSegment segment;
            if ((segment = this.segments.get(segmentIndex = nextSegmentIndex++)) instanceof YamlPathSegment.ListEntry) {
                builder.append('[');
                builder.append(((YamlPathSegment.ListEntry)segment).getIndex());
                builder.append(']');
                continue;
            }
            if (segment instanceof YamlPathSegment.MapElementKey) {
                if (((CharSequence)builder).length() > 0) {
                    builder.append('.');
                }
                builder.append(((YamlPathSegment.MapElementKey)segment).getKey());
                continue;
            }
            if (segment instanceof YamlPathSegment.AliasReference) {
                builder.append("->&");
                builder.append(((YamlPathSegment.AliasReference)segment).getName());
                continue;
            }
            if (segment instanceof YamlPathSegment.Merge) {
                builder.append(">>(merged");
                if (nextSegmentIndex <= CollectionsKt.getLastIndex(this.segments) && this.segments.get(nextSegmentIndex) instanceof YamlPathSegment.ListEntry) {
                    builder.append(" entry ");
                    YamlPathSegment yamlPathSegment = this.segments.get(nextSegmentIndex);
                    Intrinsics.checkNotNull((Object)yamlPathSegment, (String)"null cannot be cast to non-null type com.charleskorn.kaml.YamlPathSegment.ListEntry");
                    builder.append(((YamlPathSegment.ListEntry)yamlPathSegment).getIndex());
                    ++nextSegmentIndex;
                }
                if (nextSegmentIndex <= CollectionsKt.getLastIndex(this.segments) && this.segments.get(nextSegmentIndex) instanceof YamlPathSegment.AliasReference) {
                    builder.append(" &");
                    YamlPathSegment yamlPathSegment = this.segments.get(nextSegmentIndex);
                    Intrinsics.checkNotNull((Object)yamlPathSegment, (String)"null cannot be cast to non-null type com.charleskorn.kaml.YamlPathSegment.AliasReference");
                    builder.append(((YamlPathSegment.AliasReference)yamlPathSegment).getName());
                    ++nextSegmentIndex;
                }
                builder.append(")");
                continue;
            }
            if (segment instanceof YamlPathSegment.Root || segment instanceof YamlPathSegment.Error || segment instanceof YamlPathSegment.MapElementValue || var3_3 instanceof YamlPathSegment.AliasDefinition) {
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        if (((CharSequence)builder).length() > 0) {
            void var1_1;
            String string = var1_1.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        return "<root>";
    }

    @NotNull
    public final String toString() {
        return "YamlPath(segments=" + this.segments + ")";
    }

    public final int hashCode() {
        return ((Object)this.segments).hashCode();
    }

    public final boolean equals(@Nullable Object other) {
        YamlPath yamlPath;
        if (this == other) {
            return true;
        }
        if (!(other instanceof YamlPath)) {
            return false;
        }
        yamlPath = yamlPath;
        return Intrinsics.areEqual(this.segments, yamlPath.segments);
    }

    public static final /* synthetic */ YamlPath access$getRoot$cp() {
        return root;
    }

    static {
        YamlPathSegment[] yamlPathSegmentArray = new YamlPathSegment[1];
        YamlPathSegment[] yamlPathSegmentArray2 = yamlPathSegmentArray;
        yamlPathSegmentArray[0] = YamlPathSegment.Root.INSTANCE;
        root = new YamlPath(yamlPathSegmentArray2);
    }

    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static YamlPath forAliasDefinition(@NotNull String name, @NotNull Location location) {
            void var1_1;
            String string;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            YamlPathSegment[] yamlPathSegmentArray = new YamlPathSegment[1];
            YamlPathSegment[] yamlPathSegmentArray2 = yamlPathSegmentArray;
            yamlPathSegmentArray[0] = new YamlPathSegment.AliasDefinition(string, (Location)var1_1);
            return new YamlPath(yamlPathSegmentArray2);
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

