/*
 * Decompiled with CFR 0.152.
 */
package dev.rvbsm.fsit.lib.kaml;

import dev.rvbsm.fsit.lib.kaml.ForbiddenAnchorOrAliasException;
import dev.rvbsm.fsit.lib.kaml.Location;
import dev.rvbsm.fsit.lib.kaml.MalformedYamlException;
import dev.rvbsm.fsit.lib.kaml.NoAnchorForExtensionException;
import dev.rvbsm.fsit.lib.kaml.UnknownAnchorException;
import dev.rvbsm.fsit.lib.kaml.WeightedNode;
import dev.rvbsm.fsit.lib.kaml.YamlList;
import dev.rvbsm.fsit.lib.kaml.YamlMap;
import dev.rvbsm.fsit.lib.kaml.YamlNode;
import dev.rvbsm.fsit.lib.kaml.YamlNull;
import dev.rvbsm.fsit.lib.kaml.YamlParser;
import dev.rvbsm.fsit.lib.kaml.YamlPath;
import dev.rvbsm.fsit.lib.kaml.YamlScalar;
import dev.rvbsm.fsit.lib.kaml.YamlTaggedNode;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.common.Anchor;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.events.AliasEvent;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.events.Event;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.events.MappingStartEvent;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.events.NodeEvent;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.events.ScalarEvent;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.events.SequenceStartEvent;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.exceptions.Mark;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UInt;
import kotlin.UnsignedKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nYamlNodeReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YamlNodeReader.kt\ncom/charleskorn/kaml/YamlNodeReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,243:1\n1#2:244\n774#3:245\n865#3,2:246\n1869#3:257\n669#3,11:259\n1870#3:271\n563#4:248\n548#4,6:249\n216#5,2:255\n216#5:258\n217#5:270\n*S KotlinDebug\n*F\n+ 1 YamlNodeReader.kt\ncom/charleskorn/kaml/YamlNodeReader\n*L\n161#1:245\n161#1:246,2\n183#1:257\n191#1:259,11\n183#1:271\n179#1:248\n179#1:249,6\n180#1:255,2\n190#1:258\n190#1:270\n*E\n"})
public final class YamlNodeReader {
    @NotNull
    private final YamlParser parser;
    @Nullable
    private final String extensionDefinitionPrefix;
    @Nullable
    private final UInt maxAliasCount;
    @NotNull
    private final Map<Anchor, WeightedNode> aliases;
    private int aliasCount;

    /*
     * WARNING - void declaration
     */
    private YamlNodeReader(YamlParser parser, String extensionDefinitionPrefix, UInt maxAliasCount) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        this.parser = var1_1;
        this.extensionDefinitionPrefix = var2_2;
        this.maxAliasCount = var3_3;
        this.aliases = new LinkedHashMap();
    }

    @NotNull
    public final YamlNode read() {
        return this.readNode(YamlPath.access$getRoot$cp()).getNode();
    }

    /*
     * WARNING - void declaration
     */
    private final WeightedNode readNode(YamlPath path) {
        void var1_1;
        return (WeightedNode)this.readNodeAndAnchor((YamlPath)var1_1).getFirst();
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<WeightedNode, Anchor> readNodeAndAnchor(YamlPath path) {
        Event event = this.parser.consumeEvent(path);
        WeightedNode weightedNode = this.readFromEvent(event, path);
        YamlNode node = weightedNode.component1();
        int weight = weightedNode.component2-pVg5ArA();
        if (event instanceof NodeEvent) {
            void var2_2;
            void var3_4;
            if (!(event instanceof AliasEvent)) {
                Anchor anchor = ((NodeEvent)event).getAnchor();
                if (anchor != null) {
                    void var1_1;
                    Anchor it = anchor;
                    UInt uInt = this.maxAliasCount;
                    if (uInt != null && uInt.unbox-impl() == 0) {
                        throw new ForbiddenAnchorOrAliasException("Parsing anchors and aliases is disabled.", path);
                    }
                    YamlNode anchor2 = node.withPath(YamlPath.Companion.forAliasDefinition(it.getValue(), YamlNodeReader.getLocation(event)));
                    this.aliases.put(it, new WeightedNode((YamlNode)var1_1, weight, 0));
                }
            }
            return TuplesKt.to((Object)new WeightedNode(node, (int)var3_4, 0), (Object)((NodeEvent)var2_2).getAnchor());
        }
        return TuplesKt.to((Object)new WeightedNode(node, 0, 0), null);
    }

    /*
     * WARNING - void declaration
     */
    private final WeightedNode readFromEvent(Event event, YamlPath path) {
        void var1_1;
        void var2_2;
        WeightedNode it;
        Event event2 = event;
        if (event2 instanceof ScalarEvent) {
            return new WeightedNode(YamlNodeReader.maybeToTaggedNode(YamlNodeReader.readScalarOrNull((ScalarEvent)event, path), ((ScalarEvent)event).getTag()), 0, 0);
        }
        if (event2 instanceof SequenceStartEvent) {
            it = this.readSequence(path);
            return WeightedNode.copy-Qn1smSk$default$a7daa77(it, YamlNodeReader.maybeToTaggedNode(it.getNode(), ((SequenceStartEvent)event).getTag()), 0, 2);
        }
        if (event2 instanceof MappingStartEvent) {
            it = this.readMapping((YamlPath)((Object)it));
            return WeightedNode.copy-Qn1smSk$default$a7daa77(it, YamlNodeReader.maybeToTaggedNode(var2_2.getNode(), ((MappingStartEvent)event).getTag()), 0, 2);
        }
        if (event2 instanceof AliasEvent) {
            return this.readAlias((AliasEvent)event, (YamlPath)var2_2);
        }
        throw new MalformedYamlException("Unexpected " + event.getEventId(), var2_2.withError(YamlNodeReader.getLocation((Event)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    private static YamlNode readScalarOrNull(ScalarEvent event, YamlPath path) {
        void var1_1;
        ScalarEvent scalarEvent;
        if ((Intrinsics.areEqual((Object)event.getValue(), (Object)"null") || Intrinsics.areEqual((Object)event.getValue(), (Object)"") || Intrinsics.areEqual((Object)event.getValue(), (Object)"~")) && event.getPlain()) {
            return new YamlNull(path);
        }
        return new YamlScalar(scalarEvent.getValue(), (YamlPath)var1_1);
    }

    private final WeightedNode readSequence(YamlPath path) {
        List items = new ArrayList();
        int sequenceWeight = 0;
        while (true) {
            Object event;
            if (WhenMappings.$EnumSwitchMapping$0[((Event)(event = this.parser.peekEvent(path))).getEventId().ordinal()] == 1) {
                this.parser.consumeEventOfType(Event.ID.SequenceEnd, path);
                return new WeightedNode(new YamlList(items, path), sequenceWeight, 0);
            }
            event = this.readNode(path.withListEntry(items.size(), YamlNodeReader.getLocation((Event)event)));
            YamlNode node = ((WeightedNode)event).component1();
            int weight = ((WeightedNode)event).component2-pVg5ArA();
            sequenceWeight = UInt.constructor-impl((int)(sequenceWeight + weight));
            ((Collection)items).add(node);
        }
    }

    private final WeightedNode readMapping(YamlPath path) {
        Map items = new LinkedHashMap();
        int mapWeight = 0;
        while (true) {
            Event event;
            if (WhenMappings.$EnumSwitchMapping$0[(event = this.parser.peekEvent(path)).getEventId().ordinal()] == 2) {
                this.parser.consumeEventOfType(Event.ID.MappingEnd, path);
                return new WeightedNode(new YamlMap(this.doMerges(items), path), mapWeight, 0);
            }
            Location keyLocation = YamlNodeReader.getLocation(this.parser.peekEvent(path));
            String key = this.readMapKey(path);
            YamlScalar keyNode = new YamlScalar(key, path.withMapElementKey(key, keyLocation));
            Location valueLocation = YamlNodeReader.getLocation(this.parser.peekEvent(((YamlNode)keyNode).getPath()));
            Pair<WeightedNode, Anchor> valuePath = YamlNodeReader.isMerge(keyNode) ? path.withMerge(valueLocation) : ((YamlNode)keyNode).getPath().withMapElementValue(valueLocation);
            valuePath = this.readNodeAndAnchor((YamlPath)valuePath);
            WeightedNode weightedNode = (WeightedNode)valuePath.component1();
            Anchor anchor = (Anchor)valuePath.component2();
            mapWeight = UInt.constructor-impl((int)(mapWeight + weightedNode.getWeight-pVg5ArA()));
            if (Intrinsics.areEqual((Object)path, (Object)YamlPath.access$getRoot$cp()) && this.extensionDefinitionPrefix != null && StringsKt.startsWith$default((String)key, (String)this.extensionDefinitionPrefix, (boolean)false, (int)2, null)) {
                if (anchor != null) continue;
                throw new NoAnchorForExtensionException(key, this.extensionDefinitionPrefix, path.withError(YamlNodeReader.getLocation(event)));
            }
            Map map = items;
            Pair pair = TuplesKt.to((Object)keyNode, (Object)weightedNode.getNode());
            map.put(pair.getFirst(), pair.getSecond());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String readMapKey(YamlPath path) {
        void var2_2;
        void var1_1;
        Event event = this.parser.peekEvent(path);
        if (WhenMappings.$EnumSwitchMapping$0[event.getEventId().ordinal()] == 3) {
            void var3_3;
            boolean isNullKey;
            this.parser.consumeEventOfType(Event.ID.Scalar, path);
            Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type it.krzeminski.snakeyaml.engine.kmp.events.ScalarEvent");
            ScalarEvent scalarEvent = (ScalarEvent)event;
            boolean bl = isNullKey = (Intrinsics.areEqual((Object)scalarEvent.getValue(), (Object)"null") || Intrinsics.areEqual((Object)scalarEvent.getValue(), (Object)"~")) && scalarEvent.getPlain();
            if (scalarEvent.getTag() != null || isNullKey) {
                throw this.nonScalarMapKeyException(path, event);
            }
            return var3_3.getValue();
        }
        throw this.nonScalarMapKeyException((YamlPath)var1_1, (Event)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final MalformedYamlException nonScalarMapKeyException(YamlPath path, Event event) {
        void var2_2;
        void var1_1;
        return new MalformedYamlException("Property name must not be a list, map, null or tagged value. (To use 'null' as a property name, enclose it in quotes.)", var1_1.withError(YamlNodeReader.getLocation((Event)var2_2)));
    }

    /*
     * WARNING - void declaration
     */
    private static YamlNode maybeToTaggedNode(YamlNode $this$maybeToTaggedNode, String tag) {
        YamlNode yamlNode;
        String string = tag;
        if (string != null) {
            void var1_1;
            String it = string;
            return new YamlTaggedNode((String)var1_1, $this$maybeToTaggedNode);
        }
        return yamlNode;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<YamlScalar, YamlNode> doMerges(Map<YamlScalar, ? extends YamlNode> items) {
        Iterable iterable;
        void var3_3;
        Iterator $this$filterTo$iv$iv;
        Iterable iterable2 = items.entrySet();
        Collection destination$iv$iv = new ArrayList();
        $this$filterTo$iv$iv = $this$filterTo$iv$iv.iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            Object element$iv$iv = $this$filterTo$iv$iv.next();
            Object object = (Map.Entry)element$iv$iv;
            if (!YamlNodeReader.isMerge((YamlNode)(object = (YamlScalar)object.getKey()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List mergeEntries = (List)var3_3;
        switch (((Collection)mergeEntries).size()) {
            case 0: {
                return items;
            }
            case 1: {
                YamlNode mappingsToMerge = (YamlNode)((Map.Entry)CollectionsKt.single((List)mergeEntries)).getValue();
                if (mappingsToMerge instanceof YamlList) {
                    return this.doMerges(items, ((YamlList)mappingsToMerge).getItems());
                }
                return this.doMerges((Map<YamlScalar, ? extends YamlNode>)((Object)iterable), CollectionsKt.listOf((Object)iterable2));
            }
        }
        iterable = iterable2;
        throw new MalformedYamlException("Cannot perform multiple '<<' merges into a map. Instead, combine all merges into a single '<<' entry.", ((YamlNode)((YamlScalar)((Map.Entry)CollectionsKt.first((List)CollectionsKt.drop((Iterable)iterable, (int)1))).getKey())).getPath());
    }

    private static boolean isMerge(YamlNode key) {
        YamlNode yamlNode;
        return key instanceof YamlScalar && Intrinsics.areEqual((Object)((YamlScalar)yamlNode).getContent(), (Object)"<<");
    }

    /*
     * WARNING - void declaration
     */
    private final Map<YamlScalar, YamlNode> doMerges(Map<YamlScalar, ? extends YamlNode> original, List<? extends YamlNode> others) {
        void var3_3;
        YamlNode key;
        Object object;
        Iterator iterator;
        Map merged = new LinkedHashMap();
        Map.Entry destination$iv$iv = new LinkedHashMap();
        for (Map.Entry element$iv$iv : iterator.entrySet()) {
            object = element$iv$iv;
            object = (YamlScalar)element$iv$iv.getKey();
            if (YamlNodeReader.isMerge((YamlNode)object)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        iterator = destination$iv$iv;
        for (Map.Entry entry : iterator.entrySet()) {
            destination$iv$iv = entry;
            destination$iv$iv = entry;
            key = (YamlScalar)entry.getKey();
            YamlNode value = (YamlNode)destination$iv$iv.getValue();
            merged.put(key, value);
        }
        iterator = (Iterable)others;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            destination$iv$iv = iterator.next();
            YamlNode other = (YamlNode)((Object)destination$iv$iv);
            key = other;
            if (other instanceof YamlNull) {
                throw new MalformedYamlException("Cannot merge a null value into a map.", ((YamlNode)((YamlNull)other)).getPath());
            }
            if (key instanceof YamlScalar) {
                throw new MalformedYamlException("Cannot merge a scalar value into a map.", ((YamlNode)((YamlScalar)other)).getPath());
            }
            if (key instanceof YamlList) {
                throw new MalformedYamlException("Cannot merge a list value into a map.", ((YamlNode)((YamlList)other)).getPath());
            }
            if (key instanceof YamlTaggedNode) {
                throw new MalformedYamlException("Cannot merge a tagged value into a map.", other.getPath());
            }
            if (key instanceof YamlMap) {
                object = ((YamlMap)other).getEntries();
                for (Map.Entry entry : object.entrySet()) {
                    void var2_2;
                    Object v2;
                    Object object2;
                    YamlScalar key2;
                    block11: {
                        others = entry;
                        others = entry;
                        key2 = (YamlScalar)entry.getKey();
                        YamlNode value = (YamlNode)others.getValue();
                        Iterable $this$singleOrNull$iv = merged.entrySet();
                        Object single$iv = null;
                        boolean found$iv = false;
                        object2 = $this$singleOrNull$iv.iterator();
                        while (object2.hasNext()) {
                            Object element$iv = object2.next();
                            Map.Entry entry2 = (Map.Entry)element$iv;
                            if (!((YamlScalar)entry2.getKey()).equivalentContentTo(key2)) continue;
                            if (found$iv) {
                                v2 = null;
                                break block11;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        v2 = !found$iv ? null : single$iv;
                    }
                    if ((object2 = (Map.Entry)v2) != null) continue;
                    merged.put(key2, var2_2);
                }
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final WeightedNode readAlias(AliasEvent event, YamlPath path) {
        void var3_3;
        YamlNode yamlNode;
        void var2_2;
        UInt uInt = this.maxAliasCount;
        if (uInt != null && uInt.unbox-impl() == 0) {
            throw new ForbiddenAnchorOrAliasException("Parsing anchors and aliases is disabled.", path);
        }
        Anchor anchor = event.getAlias();
        WeightedNode weightedNode = this.aliases.get(anchor);
        if (weightedNode == null) {
            throw new UnknownAnchorException(anchor.getValue(), path.withError(YamlNodeReader.getLocation(event)));
        }
        WeightedNode weightedNode2 = weightedNode;
        YamlNode resolvedNode = weightedNode.component1();
        int n = weightedNode2.component2-pVg5ArA();
        int resultWeight = UInt.constructor-impl((int)(n + 1));
        this.aliasCount = UInt.constructor-impl((int)(this.aliasCount + resultWeight));
        if (this.maxAliasCount != null && UnsignedKt.uintCompare((int)this.aliasCount, (int)this.maxAliasCount.unbox-impl()) > 0) {
            throw new ForbiddenAnchorOrAliasException("Maximum number of aliases has been reached.", path);
        }
        YamlPath yamlPath = var2_2.withAliasReference(anchor.getValue(), YamlNodeReader.getLocation((Event)((Object)yamlNode)));
        yamlNode = resolvedNode;
        return new WeightedNode(resolvedNode.withPath(yamlPath.withAliasDefinition(var3_3.getValue(), yamlNode.getPath().getEndLocation())), resultWeight, 0);
    }

    private static Location getLocation(Event $this$location) {
        Event event;
        Mark mark = $this$location.getStartMark();
        Intrinsics.checkNotNull((Object)mark);
        int n = mark.getLine() + 1;
        Mark mark2 = event.getStartMark();
        Intrinsics.checkNotNull((Object)mark2);
        return new Location(n, mark2.getColumn() + 1);
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ YamlNodeReader(YamlParser parser, String extensionDefinitionPrefix, UInt maxAliasCount, byte by) {
        this((YamlParser)var1_1, (String)var2_2, (UInt)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Event.ID.values().length];
            try {
                nArray[Event.ID.SequenceEnd.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Event.ID.MappingEnd.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Event.ID.Scalar.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

