/*
 * Decompiled with CFR 0.152.
 */
package net.jsa2025.calcmod.utils;

import java.util.Objects;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class CalcMessageBuilder {
    MessageType messageType;
    String helpMessage;
    class_5250 messageText = class_2561.method_43470((String)"");

    public CalcMessageBuilder() {
        this.messageType = MessageType.NONE;
    }

    public CalcMessageBuilder(MessageType type, String[] inputs, String[] results) {
        try {
            if (type.inputsLength != inputs.length || type.resultsLength != results.length) {
                throw new Exception("Hello");
            }
            this.messageType = type;
            this.addFromArray(type.equation, inputs, results);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CalcMessageBuilder(String helpMessage) {
        this.messageType = MessageType.HELP;
        this.helpMessage = helpMessage;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public CalcMessageBuilder addString(String text) {
        this.messageText.method_27693(text);
        return this;
    }

    public CalcMessageBuilder addInput(String text) {
        this.messageText.method_27693("\u00a7b" + text + "\u00a7f");
        return this;
    }

    public CalcMessageBuilder addResult(String text) {
        this.messageText.method_10852((class_2561)class_2561.method_43470((String)("\u00a7a" + text + "\u00a7f")).method_10862(class_2583.field_24360.method_10958((class_2558)new class_2558.class_10606(text))));
        return this;
    }

    public CalcMessageBuilder addFromArray(String[] template, String[] inputs, String[] results) {
        int resultsAdded = 0;
        int inputsAdded = 0;
        for (String eqnPart : template) {
            if (Objects.equals(eqnPart, "input")) {
                this.addInput(inputs[inputsAdded]);
                ++inputsAdded;
                continue;
            }
            if (Objects.equals(eqnPart, "result")) {
                this.addResult(results[resultsAdded]);
                ++resultsAdded;
                continue;
            }
            this.addString(eqnPart);
        }
        return this;
    }

    public CalcMessageBuilder addRunCommand(String text, String command) {
        this.messageText.method_10852((class_2561)class_2561.method_43470((String)text).method_10862(class_2583.field_24360.method_10958((class_2558)new class_2558.class_10609(command))));
        return this;
    }

    public class_2561 generateStyledText() {
        if (Objects.requireNonNull(this.messageType) == MessageType.HELP && this.helpMessage != null) {
            return class_2561.method_43470((String)this.helpMessage);
        }
        if (Objects.requireNonNull(this.messageType) != MessageType.HELP) {
            this.messageText.method_27693(" ");
            this.messageText.method_10852((class_2561)class_2561.method_43470((String)"\u00a73[Click to Copy]\u00a7f").method_10862(class_2583.field_24360.method_10958((class_2558)new class_2558.class_10606(this.messageText.getString().replaceAll("\u00a7.", "").replaceAll("\u00a7b", "").replaceAll("\u00a77", "").replaceAll("\u00a7f", "")))));
        }
        return this.messageText;
    }

    public static enum MessageType {
        NONE(new String[0], 0, 0),
        BASIC(new String[]{"input", " = ", "result"}, 1, 1),
        HELP(new String[0], 0, 0);

        final String[] equation;
        final int inputsLength;
        final int resultsLength;

        private MessageType(String[] equation, int inputsLength, int resultsLength) {
            this.equation = equation;
            this.inputsLength = inputsLength;
            this.resultsLength = resultsLength;
        }
    }
}

