/*
 * Decompiled with CFR 0.152.
 */
package net.jsa2025.calcmod.commands.subcommands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.text.NumberFormat;
import java.util.Locale;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.jsa2025.calcmod.commands.CalcCommand;
import net.jsa2025.calcmod.commands.arguments.BarterSuggestionProvider;
import net.jsa2025.calcmod.commands.arguments.CBarterSuggestionProvider;
import net.jsa2025.calcmod.commands.subcommands.Help;
import net.jsa2025.calcmod.utils.CalcMessageBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class Piglin {
    static NumberFormat nf = NumberFormat.getInstance(new Locale("en", "US"));
    public static String helpMessage = "\u00a7b\u00a7LBarter:\u00a7r\u00a7f\n    Calculates the average amount of gold ingots to barter to get a number of a desired item \u00a77\u00a7o(togold)\u00a7r\u00a7f, or the average amount of an item that will be recieved when bartering a number of gold ingots \u00a77\u00a7o(toitem)\u00a7r\u00a7f.\n    \u00a7eUsage: /calc barter togold <numberofitems> <item>\u00a7f\n    \u00a7eUsage: /calc barter toitem <amountofgold> <item>\u00a7f\n";

    public static LiteralArgumentBuilder<FabricClientCommandSource> register(LiteralArgumentBuilder<FabricClientCommandSource> command) {
        command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"barter").then(ClientCommandManager.literal((String)"toitem").then(ClientCommandManager.argument((String)"gold", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"item", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new CBarterSuggestionProvider()).executes(ctx -> {
            String gold = StringArgumentType.getString((CommandContext)ctx, (String)"gold");
            String item = StringArgumentType.getString((CommandContext)ctx, (String)"item");
            CalcMessageBuilder message = Piglin.executeToItems(((FabricClientCommandSource)ctx.getSource()).getEntity(), gold, item);
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        }))))).then(ClientCommandManager.literal((String)"togold").then(ClientCommandManager.argument((String)"numberofitems", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"item", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new CBarterSuggestionProvider()).executes(ctx -> {
            String gold = StringArgumentType.getString((CommandContext)ctx, (String)"numberofitems");
            String item = StringArgumentType.getString((CommandContext)ctx, (String)"item");
            CalcMessageBuilder message = Piglin.executeToGold(((FabricClientCommandSource)ctx.getSource()).getEntity(), gold, item);
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        }))))).then(ClientCommandManager.literal((String)"help").executes(ctx -> {
            CalcMessageBuilder message = Help.execute("barter");
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        })));
        return command;
    }

    public static LiteralArgumentBuilder<class_2168> registerServer(LiteralArgumentBuilder<class_2168> command) {
        command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"barter").then(class_2170.method_9247((String)"toitem").then(class_2170.method_9244((String)"gold", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"item", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new BarterSuggestionProvider()).executes(ctx -> {
            String gold = StringArgumentType.getString((CommandContext)ctx, (String)"gold");
            String item = StringArgumentType.getString((CommandContext)ctx, (String)"item");
            CalcMessageBuilder message = Piglin.executeToItems(((class_2168)ctx.getSource()).method_9228(), gold, item);
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        }))))).then(class_2170.method_9247((String)"togold").then(class_2170.method_9244((String)"numberofitems", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"item", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new BarterSuggestionProvider()).executes(ctx -> {
            String gold = StringArgumentType.getString((CommandContext)ctx, (String)"numberofitems");
            String item = StringArgumentType.getString((CommandContext)ctx, (String)"item");
            CalcMessageBuilder message = Piglin.executeToGold(((class_2168)ctx.getSource()).method_9228(), gold, item);
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        }))))).then(class_2170.method_9247((String)"help").executes(ctx -> {
            CalcMessageBuilder message = Help.execute("barter");
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        })));
        return command;
    }

    public static CalcMessageBuilder executeToItems(class_1297 player, String gold, String item) {
        double amount_of_items = CalcCommand.getParsedExpression(player, gold, new Integer[0]) / CBarterSuggestionProvider.barter.get(item);
        CalcMessageBuilder message = new CalcMessageBuilder().addFromArray(new String[]{"Avg amount of ", "input", " that ", "input", " gold ingots will get = ", "result"}, new String[]{item, gold}, new String[]{nf.format(amount_of_items)});
        return message;
    }

    public static CalcMessageBuilder executeToGold(class_1297 player, String numberofitems, String item) {
        double amount_of_items = CalcCommand.getParsedExpression(player, numberofitems, new Integer[0]) * CBarterSuggestionProvider.barter.get(item);
        CalcMessageBuilder message = new CalcMessageBuilder().addFromArray(new String[]{"Avg gold ingots to get ", "input", " ", "input", " = ", "result"}, new String[]{numberofitems, item}, new String[]{nf.format(amount_of_items)});
        return message;
    }
}

