/*
 * Decompiled with CFR 0.152.
 */
package net.jsa2025.calcmod.commands.subcommands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.jsa2025.calcmod.commands.CalcCommand;
import net.jsa2025.calcmod.commands.subcommands.Help;
import net.jsa2025.calcmod.utils.CalcMessageBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class ItemToStack {
    static DecimalFormat df = new DecimalFormat("#.##");
    static NumberFormat nf = NumberFormat.getInstance(new Locale("en", "US"));
    public static String helpMessage = "\u00a7b\u00a7LItem to Stack:\u00a7r\u00a7f\n    Given a number of items \u00a77\u00a7o(can be in expression form)\u00a7r\u00a7f, returns the number of stacks and remainder items.\n    \u00a7eUsage: /calc itemtostack <numberofitems>\u00a7f\n";

    public static LiteralArgumentBuilder<FabricClientCommandSource> register(LiteralArgumentBuilder<FabricClientCommandSource> command) {
        command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"itemtostack").then(ClientCommandManager.argument((String)"numberofitems", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = ItemToStack.execute(((FabricClientCommandSource)ctx.getSource()).getEntity(), StringArgumentType.getString((CommandContext)ctx, (String)"numberofitems"), 64);
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        }))).then(ClientCommandManager.literal((String)"16s").then(ClientCommandManager.argument((String)"numberofitems", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = ItemToStack.execute(((FabricClientCommandSource)ctx.getSource()).getEntity(), StringArgumentType.getString((CommandContext)ctx, (String)"numberofitems"), 16);
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        })))).then(ClientCommandManager.literal((String)"1s").then(ClientCommandManager.argument((String)"numberofitems", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = ItemToStack.execute(((FabricClientCommandSource)ctx.getSource()).getEntity(), StringArgumentType.getString((CommandContext)ctx, (String)"numberofitems"), 1);
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        })))).then(ClientCommandManager.literal((String)"help").executes(ctx -> {
            CalcMessageBuilder message = Help.execute("itemtostack");
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        })));
        return command;
    }

    public static LiteralArgumentBuilder<class_2168> registerServer(LiteralArgumentBuilder<class_2168> command) {
        command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"itemtostack").then(class_2170.method_9244((String)"numberofitems", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = ItemToStack.execute(((class_2168)ctx.getSource()).method_9228(), StringArgumentType.getString((CommandContext)ctx, (String)"numberofitems"), 64);
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        }))).then(class_2170.method_9247((String)"16s").then(class_2170.method_9244((String)"numberofitems", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = ItemToStack.execute(((class_2168)ctx.getSource()).method_9228(), StringArgumentType.getString((CommandContext)ctx, (String)"numberofitems"), 16);
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        })))).then(class_2170.method_9247((String)"1s").then(class_2170.method_9244((String)"numberofitems", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = ItemToStack.execute(((class_2168)ctx.getSource()).method_9228(), StringArgumentType.getString((CommandContext)ctx, (String)"numberofitems"), 1);
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        })))).then(class_2170.method_9247((String)"help").executes(ctx -> {
            CalcMessageBuilder message = Help.execute("itemtostack");
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        })));
        return command;
    }

    public static CalcMessageBuilder execute(class_1297 player, String numberofitems, int stackSize) {
        double items = CalcCommand.getParsedExpression(player, numberofitems, stackSize);
        double stacks = Math.floor(items / (double)stackSize);
        double leftover = items % (double)stackSize;
        CalcMessageBuilder message = new CalcMessageBuilder().addInput(numberofitems).addString(" ").addInput(nf.format(stackSize)).addString(" Stackable items = ").addResult(nf.format(stacks)).addString(" Stacks + ").addResult(nf.format(leftover)).addString(" Items");
        return message;
    }
}

