/*
 * Decompiled with CFR 0.152.
 */
package net.jsa2025.calcmod.commands.subcommands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.jsa2025.calcmod.CalcMod;
import net.jsa2025.calcmod.commands.CalcCommand;
import net.jsa2025.calcmod.commands.arguments.CCustomFunctionProvider;
import net.jsa2025.calcmod.commands.arguments.CustomFunctionProvider;
import net.jsa2025.calcmod.commands.subcommands.Help;
import net.jsa2025.calcmod.utils.CalcMessageBuilder;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class Custom {
    static DecimalFormat df = new DecimalFormat("#.##");
    static NumberFormat nf = NumberFormat.getInstance(new Locale("en", "US"));
    public static final File commandFile = new File(".", "config/calcmod.json");
    public static String helpMessage = "\u00a7b\u00a7LCustom:\u00a7r\u00a7f\n    Custom functions are reusable commands that perform a specific computation. They can be run in any number field formatted with the function name and the parameters in parenthesis \u00a77\u00a7o(customfunction(param1, paramN))\u00a7r\u00a7f.\n    Custom functions can have any number of parameters, specified in [square] brackets when adding the function.\n    \u00a7eUsage: /calc custom add <name> <function>\u00a7f\n    \u00a7eUsage: /calc custom run <name> <input>\u00a7f\n    \u00a7eUsage: /calc <name>(<parameters>)\u00a7f\n    \u00a7eUsage: /calc custom list\u00a7f\n    \u00a7eUsage: /calc custom remove <name>\u00a7f\n";

    public static LiteralArgumentBuilder<FabricClientCommandSource> register(LiteralArgumentBuilder<FabricClientCommandSource> command) {
        command = (LiteralArgumentBuilder)command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"custom").then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"function", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder messageBuilder;
            String function = StringArgumentType.getString((CommandContext)ctx, (String)"function");
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            if (!Pattern.matches(".*\\d.*", name) && !Custom.parseEquationVariables(function).isEmpty()) {
                Custom.saveNewCommand(name, function);
                messageBuilder = new CalcMessageBuilder("\u00a7eAdded " + name + "\u00a7f");
            } else {
                messageBuilder = Custom.parseEquationVariables(function).isEmpty() ? new CalcMessageBuilder("\u00a7cMust have at least one parameter.\u00a7f") : new CalcMessageBuilder("\u00a7cCannot have numbers in command name.\u00a7f");
            }
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), messageBuilder);
            return 0;
        }))))).then(ClientCommandManager.literal((String)"list").executes(ctx -> {
            JsonObject fs = Custom.getFunctions();
            String m = fs.entrySet().stream().map(entry -> "\u00a7b\u00a7L" + (String)entry.getKey() + ":\u00a7f\u00a7r " + ((JsonElement)entry.getValue()).getAsString()).collect(Collectors.joining("\n"));
            CalcMessageBuilder messageBuilder = new CalcMessageBuilder(m);
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), messageBuilder);
            return 0;
        }))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((SuggestionProvider)new CCustomFunctionProvider()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            Custom.deleteCommand(name);
            CalcMessageBuilder messageBuilder = new CalcMessageBuilder("\u00a7cRemoved " + name + "\u00a7f");
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), messageBuilder);
            return 0;
        })))).then(ClientCommandManager.literal((String)"run").then(ClientCommandManager.argument((String)"function", (ArgumentType)StringArgumentType.greedyString()).suggests((SuggestionProvider)new CCustomFunctionProvider()).executes(ctx -> {
            String eqn = StringArgumentType.getString((CommandContext)ctx, (String)"function");
            double result = CalcCommand.getParsedExpression(((FabricClientCommandSource)ctx.getSource()).getEntity(), eqn, new Integer[0]);
            CalcMessageBuilder messageBuilder = new CalcMessageBuilder(CalcMessageBuilder.MessageType.BASIC, new String[]{eqn}, new String[]{nf.format(result)});
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), messageBuilder);
            return 0;
        })))).then(ClientCommandManager.literal((String)"help").executes(ctx -> {
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), Help.execute("custom"));
            return 0;
        })));
        return command;
    }

    public static LiteralArgumentBuilder<class_2168> registerServer(LiteralArgumentBuilder<class_2168> command) {
        command = (LiteralArgumentBuilder)command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"custom").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"function", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder messageBuilder;
            String function = StringArgumentType.getString((CommandContext)ctx, (String)"function");
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            if (!Pattern.matches(".*\\d.*", name) && !Custom.parseEquationVariables(function).isEmpty()) {
                Custom.saveNewCommand(name, function);
                messageBuilder = new CalcMessageBuilder("\u00a7eAdded " + name + "\u00a7f");
            } else {
                messageBuilder = Custom.parseEquationVariables(function).isEmpty() ? new CalcMessageBuilder("\u00a7cMust have at least one parameter.\u00a7f") : new CalcMessageBuilder("\u00a7cCannot have numbers in command name.\u00a7f");
            }
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), messageBuilder);
            return 0;
        }))))).then(class_2170.method_9247((String)"list").executes(ctx -> {
            JsonObject fs = Custom.getFunctions();
            String m = fs.entrySet().stream().map(entry -> "\u00a7b\u00a7L" + (String)entry.getKey() + ":\u00a7f\u00a7r " + ((JsonElement)entry.getValue()).getAsString()).collect(Collectors.joining("\n"));
            CalcMessageBuilder messageBuilder = new CalcMessageBuilder(m);
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), messageBuilder);
            return 0;
        }))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((SuggestionProvider)new CustomFunctionProvider()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            Custom.deleteCommand(name);
            CalcMessageBuilder messageBuilder = new CalcMessageBuilder("\u00a7cRemoved " + name + "\u00a7f");
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), messageBuilder);
            return 0;
        })))).then(class_2170.method_9247((String)"run").then(class_2170.method_9244((String)"function", (ArgumentType)StringArgumentType.greedyString()).suggests((SuggestionProvider)new CustomFunctionProvider()).executes(ctx -> {
            String eqn = StringArgumentType.getString((CommandContext)ctx, (String)"function");
            double result = CalcCommand.getParsedExpression(((class_2168)ctx.getSource()).method_9228(), eqn, new Integer[0]);
            CalcMessageBuilder messageBuilder = new CalcMessageBuilder(CalcMessageBuilder.MessageType.BASIC, new String[]{eqn}, new String[]{nf.format(result)});
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), messageBuilder);
            return 0;
        })))).then(class_2170.method_9247((String)"help").executes(ctx -> {
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), Help.execute("custom"));
            return 0;
        })));
        return command;
    }

    public static ArrayList<String> parseEquationVariables(String input) {
        String patternString = "\\[([^\\]]+)\\]";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(input);
        StringBuilder commandJson = new StringBuilder("{\n\"variables\": [\n");
        ArrayList<String> variables = new ArrayList<String>();
        while (matcher.find()) {
            String group = matcher.group();
            if (variables.contains(group = group.substring(1, group.length() - 1))) continue;
            variables.add(group);
        }
        commandJson.append("],\n\"equation\": \"").append(input).append("\"\n}");
        return variables;
    }

    public static JsonObject readJson() {
        JsonObject jsonObject;
        BufferedReader reader = new BufferedReader(new FileReader(commandFile));
        try {
            JsonObject json;
            JsonObject tempJson;
            try {
                tempJson = JsonParser.parseString((String)reader.lines().collect(Collectors.joining("\n"))).getAsJsonObject();
            }
            catch (Exception ignored) {
                tempJson = new JsonObject();
            }
            jsonObject = json = tempJson;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ignored) {
                return new JsonObject();
            }
        }
        reader.close();
        return jsonObject;
    }

    public static JsonObject getFunctions() {
        JsonObject json = Custom.readJson();
        if (!json.has("functions")) {
            json = new JsonObject();
            json.add("functions", (JsonElement)new JsonObject());
        }
        return json.getAsJsonObject("functions");
    }

    public static ArrayList<String> getParsedFunctions() {
        ArrayList<String> parsedFuncs = new ArrayList<String>();
        JsonObject funcs = Custom.getFunctions();
        for (String f : funcs.keySet()) {
            String func = funcs.get(f).getAsString();
            ArrayList<String> vars = Custom.parseEquationVariables(func);
            if (!vars.isEmpty()) {
                String combinedVars = String.join((CharSequence)", ", vars);
                parsedFuncs.add(f + "(" + combinedVars + ") = " + func.replace("[", "").replace("]", ""));
            } else {
                parsedFuncs.add(f + "() = " + func);
            }
            CalcMod.LOGGER.info("Parsed Func " + String.valueOf(parsedFuncs));
        }
        return parsedFuncs;
    }

    public static void saveNewCommand(String name, String eqn) {
        JsonObject json = Custom.readJson();
        if (!json.has("functions")) {
            json = new JsonObject();
            json.add("functions", (JsonElement)new JsonObject());
        }
        json.getAsJsonObject("functions").addProperty(name, eqn);
        Custom.saveCommandsFile(json);
    }

    public static void deleteCommand(String name) {
        JsonObject json = Custom.readJson();
        json.getAsJsonObject("functions").remove(name.split("[(]")[0]);
        Custom.saveCommandsFile(json);
    }

    public static void saveCommandsFile(JsonObject json) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File dir = new File(".", "config");
        if ((dir.exists() && dir.isDirectory() || dir.mkdirs()) && !commandFile.exists()) {
            try {
                commandFile.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            FileWriter writer = new FileWriter(commandFile);
            writer.write(gson.toJson((JsonElement)json));
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

