/*
 * Decompiled with CFR 0.152.
 */
package net.jsa2025.calcmod.commands.subcommands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.jsa2025.calcmod.commands.CalcCommand;
import net.jsa2025.calcmod.commands.arguments.CIdentifierArgumentType;
import net.jsa2025.calcmod.commands.arguments.CRecipeSuggestionProvider;
import net.jsa2025.calcmod.commands.arguments.RecipeSuggestionProvider;
import net.jsa2025.calcmod.commands.subcommands.Help;
import net.jsa2025.calcmod.utils.CalcMessageBuilder;
import net.minecraft.class_10295;
import net.minecraft.class_10297;
import net.minecraft.class_10363;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2960;
import net.minecraft.class_299;
import net.minecraft.class_3222;
import net.minecraft.class_516;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7157;
import net.minecraft.class_746;

public class Craft {
    static DecimalFormat df = new DecimalFormat("#.##");
    static NumberFormat nf = NumberFormat.getInstance(new Locale("en", "US"));
    public static String helpMessage = "\u00a7b\u00a7LCraft:\u00a7r\u00a7f\n        Given a desired item and the quantity to be crafted \u00a77\u00a7o(can be in expression form)\u00a7r\u00a7f, returns the amounts of the items needed to craft the amount of the desired item.\n        Depth specifies how many levels of recursive crafting to perform on the recipe. Default depth is 1. \n            \u00a7eUsage: /calc craft <item> <amount>\u00a7f\n            \u00a7eUsage: /calc craft <item> <depth> <amount>\u00a7f\n";

    public static LiteralArgumentBuilder<FabricClientCommandSource> register(LiteralArgumentBuilder<FabricClientCommandSource> command, class_7157 registry) {
        command.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"craft").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"item", (ArgumentType)class_2232.method_9441()).suggests((SuggestionProvider)new CRecipeSuggestionProvider()).then(ClientCommandManager.literal((String)"depth").then(ClientCommandManager.argument((String)"level", (ArgumentType)IntegerArgumentType.integer()).then(ClientCommandManager.argument((String)"amount", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = Craft.execute(((FabricClientCommandSource)ctx.getSource()).getPlayer(), CIdentifierArgumentType.getRecipeArgument((CommandContext<FabricClientCommandSource>)ctx, "item"), StringArgumentType.getString((CommandContext)ctx, (String)"amount"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level"), ((FabricClientCommandSource)ctx.getSource()).method_30497());
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        }))))).then(ClientCommandManager.argument((String)"amount", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = Craft.execute(((FabricClientCommandSource)ctx.getSource()).getPlayer(), CIdentifierArgumentType.getRecipeArgument((CommandContext<FabricClientCommandSource>)ctx, "item"), StringArgumentType.getString((CommandContext)ctx, (String)"amount"), 1, ((FabricClientCommandSource)ctx.getSource()).method_30497());
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        })))).then(ClientCommandManager.literal((String)"help").executes(ctx -> {
            CalcMessageBuilder message = Help.execute("craft");
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        })));
        return command;
    }

    public static LiteralArgumentBuilder<class_2168> registerServer(LiteralArgumentBuilder<class_2168> command, class_7157 registry) {
        command.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"craft").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"item", (ArgumentType)class_2232.method_9441()).suggests((SuggestionProvider)new RecipeSuggestionProvider()).then(class_2170.method_9247((String)"depth").then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"amount", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = Craft.execute(((class_2168)ctx.getSource()).method_44023(), CIdentifierArgumentType.getRecipeArgumentServer((CommandContext<class_2168>)ctx, "item"), StringArgumentType.getString((CommandContext)ctx, (String)"amount"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level"), ((class_2168)ctx.getSource()).method_30497());
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        }))))).then(class_2170.method_9244((String)"amount", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = Craft.execute(((class_2168)ctx.getSource()).method_44023(), CIdentifierArgumentType.getRecipeArgumentServer((CommandContext<class_2168>)ctx, "item"), StringArgumentType.getString((CommandContext)ctx, (String)"amount"), 1, ((class_2168)ctx.getSource()).method_30497());
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        })))).then(class_2170.method_9247((String)"help").executes(ctx -> {
            CalcMessageBuilder message = Help.execute("craft");
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        })));
        return command;
    }

    @Environment(value=EnvType.CLIENT)
    public static CalcMessageBuilder execute(class_746 player, class_10297 item, String amount, int steps, class_5455 registryManager) {
        Optional is = item.comp_3266();
        int outputSize = item.comp_3263().comp_3258().method_64742(class_10363.method_65008((class_1937)player.method_37908())).method_7947();
        double inputAmount = Math.floor(CalcCommand.getParsedExpression((class_1297)player, amount, new Integer[0]));
        int a = (int)Math.ceil(inputAmount / (double)outputSize);
        HashMap<String, Map.Entry<class_1799, Integer>> ingredients = Craft.getIngredients((class_1657)player, player.method_3130(), registryManager, (Optional<List<class_1856>>)is, a, steps);
        CalcMessageBuilder messageBuilder = new CalcMessageBuilder().addFromArray(new String[]{"Ingredients to craft ", "input", " ", "input", ": \n"}, new String[]{nf.format(inputAmount), item.comp_3263().comp_3258().method_64742(class_10363.method_65008((class_1937)player.method_37908())).method_7964().getString()}, new String[0]);
        for (Map.Entry<String, Map.Entry<class_1799, Integer>> entry : ingredients.entrySet()) {
            String key = entry.getKey();
            class_1799 value = entry.getValue().getKey();
            int stackSize = value.method_7914();
            double sb = Math.floor(entry.getValue().getValue() / (stackSize * 27));
            String sbString = nf.format(sb);
            int remainder = entry.getValue().getValue() % (stackSize * 27);
            double stacks = Math.floor(remainder / stackSize);
            String stacksString = nf.format(stacks);
            String items = nf.format(remainder %= stackSize);
            if (sb > 0.0) {
                messageBuilder.addString(key + ": ");
                messageBuilder.addResult("SBs: " + sbString + ", Stacks: " + stacksString + ", Items: " + items + "\n");
                continue;
            }
            if (stacks > 0.0) {
                messageBuilder.addString(key + ": ");
                messageBuilder.addResult("Stacks: " + stacksString + ", Items: " + items + "\n");
                continue;
            }
            messageBuilder.addString(key + ": ");
            messageBuilder.addResult("Items: " + items + "\n");
        }
        return messageBuilder;
    }

    public static CalcMessageBuilder execute(class_3222 player, class_1860 item, String amount, int steps, class_5455 registryManager) {
        List is = item.method_61671().method_64675();
        int outputSize = ((class_10295)item.method_64664().get(0)).comp_3258().method_64742(class_10363.method_65008((class_1937)player.method_51469())).method_7947();
        double inputAmount = Math.floor(CalcCommand.getParsedExpression((class_1297)player, amount, new Integer[0]));
        int a = (int)Math.ceil(inputAmount / (double)outputSize);
        HashMap<String, Map.Entry<class_1799, Integer>> ingredients = Craft.getIngredients((class_1657)player, player.method_5682().method_3772(), registryManager, Optional.ofNullable(is), a, steps);
        CalcMessageBuilder messageBuilder = new CalcMessageBuilder().addFromArray(new String[]{"Ingredients to craft ", "input", " ", "input", ": \n"}, new String[]{nf.format(inputAmount), ((class_10295)item.method_64664().get(0)).comp_3258().method_64742(class_10363.method_65008((class_1937)player.method_51469())).method_7964().getString()}, new String[0]);
        for (Map.Entry<String, Map.Entry<class_1799, Integer>> entry : ingredients.entrySet()) {
            String key = entry.getKey();
            class_1799 value = entry.getValue().getKey();
            int stackSize = value.method_7914();
            double sb = Math.floor(entry.getValue().getValue() / (stackSize * 27));
            String sbString = nf.format(sb);
            int remainder = entry.getValue().getValue() % (stackSize * 27);
            double stacks = Math.floor(remainder / stackSize);
            String stacksString = nf.format(stacks);
            String items = nf.format(remainder %= stackSize);
            if (sb > 0.0) {
                messageBuilder.addString(key + ": ");
                messageBuilder.addResult("SBs: " + sbString + ", Stacks: " + stacksString + ", Items: " + items + "\n");
                continue;
            }
            if (stacks > 0.0) {
                messageBuilder.addString(key + ": ");
                messageBuilder.addResult("Stacks: " + stacksString + ", Items: " + items + "\n");
                continue;
            }
            messageBuilder.addString(key + ": ");
            messageBuilder.addResult("Items: " + items + "\n");
        }
        return messageBuilder;
    }

    static HashMap<String, Map.Entry<class_1799, Integer>> getIngredients(class_1657 player, class_299 book, class_5455 registryManager, Optional<List<class_1856>> is, int amount_needed, int steps) {
        HashMap<String, Map.Entry<class_1799, Integer>> ingredients = new HashMap<String, Map.Entry<class_1799, Integer>>();
        for (class_1856 ingredient : is.get()) {
            if (ingredient.method_64673().method_64742(class_10363.method_65008((class_1937)player.method_37908())).method_7960()) continue;
            if (ingredients.containsKey(ingredient.method_64673().method_64742(class_10363.method_65008((class_1937)player.method_37908())).method_7964().getString())) {
                ingredients.put(ingredient.method_64673().method_64742(class_10363.method_65008((class_1937)player.method_37908())).method_7964().getString(), Map.entry(ingredients.get(ingredient.method_64673().method_64742(class_10363.method_65008((class_1937)player.method_37908())).method_7964().getString()).getKey(), ingredients.get(ingredient.method_64673().method_64742(class_10363.method_65008((class_1937)player.method_37908())).method_7964().getString()).getValue() + amount_needed));
                continue;
            }
            ingredients.put(ingredient.method_64673().method_64742(class_10363.method_65008((class_1937)player.method_37908())).method_7964().getString(), Map.entry(ingredient.method_64673().method_64742(class_10363.method_65008((class_1937)player.method_37908())), amount_needed));
        }
        HashMap<String, Map.Entry<class_1799, Integer>> ex_ingredients = new HashMap<String, Map.Entry<class_1799, Integer>>();
        for (Map.Entry ingredient : ingredients.values()) {
            if (steps == 1) {
                return ingredients;
            }
            Optional<class_2960> ing_id = Optional.ofNullable(((class_5321)((class_1799)ingredient.getKey()).method_41409().method_40230().get()).method_29177());
            Optional<class_516> recipeResultCollection = book.method_1393().stream().filter(x -> x.method_2650().stream().anyMatch(i -> ((class_1799)i.comp_3263().comp_3258().method_64738(class_10363.method_65008((class_1937)player.method_37908())).get(0)).method_41409().method_55840().contains(((class_2960)ing_id.get()).method_12832()))).findFirst();
            if (recipeResultCollection.isPresent()) {
                class_10297 recipeDisplayEntry = recipeResultCollection.get().method_2650().stream().filter(i -> ((class_1799)i.comp_3263().comp_3258().method_64738(class_10363.method_65008((class_1937)player.method_37908())).get(0)).method_41409().method_55840().contains(((class_2960)ing_id.get()).method_12832())).findFirst().get();
                Optional sis = recipeDisplayEntry.comp_3266();
                HashMap<String, Map.Entry<class_1799, Integer>> sub_ingredients = Craft.getIngredients(player, book, registryManager, (Optional<List<class_1856>>)sis, (int)Math.ceil((double)((Integer)ingredient.getValue()).intValue() / (double)((class_1799)recipeDisplayEntry.comp_3263().comp_3258().method_64738(class_10363.method_65008((class_1937)player.method_37908())).get(0)).method_7947()), steps - 1);
                for (String item : sub_ingredients.keySet()) {
                    if (ex_ingredients.containsKey(item)) {
                        ex_ingredients.put(item, Map.entry(ingredients.get(item).getKey(), ingredients.get(item).getValue() + sub_ingredients.get(item).getValue()));
                        continue;
                    }
                    ex_ingredients.put(item, Map.entry(sub_ingredients.get(item).getKey(), sub_ingredients.get(item).getValue()));
                }
                continue;
            }
            ex_ingredients.put(((class_1799)ingredient.getKey()).method_7964().getString(), Map.entry((class_1799)ingredient.getKey(), (Integer)ingredient.getValue()));
        }
        return ex_ingredients;
    }

    static HashMap<String, Map.Entry<class_1799, Integer>> getIngredients(class_1657 player, class_1863 manager, class_5455 registryManager, Optional<List<class_1856>> is, int amount_needed, int steps) {
        HashMap<String, Map.Entry<class_1799, Integer>> ingredients = new HashMap<String, Map.Entry<class_1799, Integer>>();
        for (class_1856 ingredient : is.get()) {
            if (ingredient.method_64673().method_64742(class_10363.method_65008((class_1937)player.method_37908())).method_7960()) continue;
            if (ingredients.containsKey(ingredient.method_64673().method_64742(class_10363.method_65008((class_1937)player.method_37908())).method_7964().getString())) {
                ingredients.put(ingredient.method_64673().method_64742(class_10363.method_65008((class_1937)player.method_37908())).method_7964().getString(), Map.entry(ingredients.get(ingredient.method_64673().method_64742(class_10363.method_65008((class_1937)player.method_37908())).method_7964().getString()).getKey(), ingredients.get(ingredient.method_64673().method_64742(class_10363.method_65008((class_1937)player.method_37908())).method_7964().getString()).getValue() + amount_needed));
                continue;
            }
            ingredients.put(ingredient.method_64673().method_64742(class_10363.method_65008((class_1937)player.method_37908())).method_7964().getString(), Map.entry(ingredient.method_64673().method_64742(class_10363.method_65008((class_1937)player.method_37908())), amount_needed));
        }
        HashMap<String, Map.Entry<class_1799, Integer>> ex_ingredients = new HashMap<String, Map.Entry<class_1799, Integer>>();
        for (Map.Entry ingredient : ingredients.values()) {
            if (steps == 1) {
                return ingredients;
            }
            Optional<class_2960> ing_id = Optional.ofNullable(((class_5321)((class_1799)ingredient.getKey()).method_41409().method_40230().get()).method_29177());
            if (ing_id.get().method_12832().contains("ingot")) {
                Optional<class_2960> finalIng_id = ing_id;
                ing_id = Optional.ofNullable(manager.method_8126().stream().filter(x -> Objects.equals(x.comp_1932().method_29177().method_12832(), ((class_2960)finalIng_id.get()).method_12832() + "_from_" + ((class_2960)finalIng_id.get()).method_12832().split("_")[0] + "_block")).findFirst().get().comp_1932().method_29177());
            }
            Optional<class_2960> finalIng_id1 = ing_id;
            if (manager.method_8126().stream().filter(val -> Objects.equals(finalIng_id1.get(), val.comp_1932().method_29177())).count() > 0L) {
                class_1860 recipe = manager.method_8126().stream().filter(val -> Objects.equals(finalIng_id1.get(), val.comp_1932().method_29177())).findFirst().get().comp_1933();
                List sis = recipe.method_61671().method_64675();
                HashMap<String, Map.Entry<class_1799, Integer>> sub_ingredients = Craft.getIngredients(player, manager, registryManager, Optional.ofNullable(sis), (int)Math.ceil((double)((Integer)ingredient.getValue()).intValue() / (double)((class_10295)recipe.method_64664().get(0)).comp_3258().method_64742(class_10363.method_65008((class_1937)player.method_37908())).method_7947()), steps - 1);
                for (String item : sub_ingredients.keySet()) {
                    if (ex_ingredients.containsKey(item)) {
                        ex_ingredients.put(item, Map.entry(ingredients.get(item).getKey(), ingredients.get(item).getValue() + sub_ingredients.get(item).getValue()));
                        continue;
                    }
                    ex_ingredients.put(item, Map.entry(sub_ingredients.get(item).getKey(), sub_ingredients.get(item).getValue()));
                }
                continue;
            }
            ex_ingredients.put(((class_1799)ingredient.getKey()).method_7964().getString(), Map.entry((class_1799)ingredient.getKey(), (Integer)ingredient.getValue()));
        }
        return ex_ingredients;
    }
}

