/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7654;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceUtils.class);

    public static <T> CompletableFuture<Map<class_2960, T>> load(class_3300 resourceManager, Executor executor, String kind, class_7654 lister, DynamicOps<JsonElement> ops, Codec<T> codec) {
        return CompletableFuture.supplyAsync(() -> lister.method_45113(resourceManager), executor).thenCompose(resources -> {
            ArrayList<@Nullable E> futures = new ArrayList(resources.size());
            resources.forEach((path, resource) -> futures.add(CompletableFuture.supplyAsync(() -> {
                Pair pair;
                block8: {
                    class_2960 id = lister.method_45115(path);
                    BufferedReader reader = resource.method_43039();
                    try {
                        Object result = codec.parse(ops, (Object)JsonParser.parseReader((Reader)reader)).ifError(e -> LOG.error("Couldn't parse {} '{}' from pack '{}': {}", new Object[]{kind, id, resource.method_14480(), e.message()})).result().orElse(null);
                        Pair pair2 = pair = result == null ? null : Pair.of((Object)id, result);
                        if (reader == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception exception) {
                            LOG.error("Failed to open {} {} from pack '{}'", new Object[]{kind, resource, resource.method_14480(), exception});
                            return null;
                        }
                    }
                    reader.close();
                }
                return pair;
            }, executor)));
            return class_156.method_33791(futures).thenApply(result -> result.stream().filter(Objects::nonNull).collect(Collectors.toUnmodifiableMap(Pair::getFirst, Pair::getSecond)));
        });
    }
}

