/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.mojang.serialization.Codec;
import dan200.computercraft.api.ComputerCraftAPI;
import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5699;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9473;
import net.minecraft.server.MinecraftServer;
import org.jspecify.annotations.Nullable;

public abstract class NonNegativeId
implements class_9299 {
    private final int id;

    protected NonNegativeId(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("ID must be >= 0");
        }
        this.id = id;
    }

    public int id() {
        return this.id;
    }

    public static int getId(@Nullable NonNegativeId id) {
        return id == null ? -1 : id.id();
    }

    public static <T extends NonNegativeId> int getOrCreate(MinecraftServer server, class_1799 stack, class_9331<T> component, IntFunction<T> create, String type) {
        NonNegativeId id = (NonNegativeId)stack.method_58694(component);
        if (id != null) {
            return id.id();
        }
        int newId = ComputerCraftAPI.createUniqueNumberedSaveDir(server, type);
        stack.method_57379(component, (Object)((NonNegativeId)create.apply(newId)));
        return newId;
    }

    protected void addToTooltip(String translation, Consumer<class_2561> out) {
        out.accept((class_2561)class_2561.method_43469((String)translation, (Object[])new Object[]{this.id()}).method_27692(class_124.field_1080));
    }

    public String toString() {
        String className = this.getClass().getName();
        return className.substring(className.lastIndexOf(46) + 1) + "(" + this.id + ")";
    }

    public final boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.id == ((NonNegativeId)o).id;
    }

    public final int hashCode() {
        return this.id;
    }

    public static final class Disk
    extends NonNegativeId {
        public static final Codec<Disk> CODEC = class_5699.field_33441.xmap(Disk::new, NonNegativeId::id);
        public static final class_9139<ByteBuf, Disk> STREAM_CODEC = class_9135.field_48550.method_56432(Disk::new, NonNegativeId::id);

        public Disk(int id) {
            super(id);
        }

        public void method_57409(class_1792.class_9635 tooltipContext, Consumer<class_2561> out, class_1836 flags, class_9473 stack) {
            if (flags.method_8035()) {
                this.addToTooltip("gui.computercraft.tooltip.disk_id", out);
            }
        }
    }

    public static final class Computer
    extends NonNegativeId {
        public static final Codec<Computer> CODEC = class_5699.field_33441.xmap(Computer::new, NonNegativeId::id);
        public static final class_9139<ByteBuf, Computer> STREAM_CODEC = class_9135.field_48550.method_56432(Computer::new, NonNegativeId::id);

        public Computer(int id) {
            super(id);
        }

        public void method_57409(class_1792.class_9635 tooltipContext, Consumer<class_2561> out, class_1836 flags, class_9473 stack) {
            if (flags.method_8035() || stack.method_58694(class_9334.field_49631) == null) {
                this.addToTooltip("gui.computercraft.tooltip.computer_id", out);
            }
        }
    }
}

