/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.turtle.TurtleUtil;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.util.DirectionUtil;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TurtlePlayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TurtlePlayer.class);
    private static final GameProfile DEFAULT_PROFILE = new GameProfile(UUID.fromString("0d0c4ca0-4ff1-11e4-916c-0800200c9a66"), "[ComputerCraft]");
    private static final double MAX_REACH = 2.0;
    private final class_3222 player;

    private TurtlePlayer(class_3222 player) {
        this.player = player;
    }

    private static TurtlePlayer create(ITurtleAccess turtle) {
        class_3218 world = (class_3218)turtle.getLevel();
        GameProfile profile = turtle.getOwningPlayer();
        TurtlePlayer player = new TurtlePlayer(PlatformHelper.get().createFakePlayer(world, TurtlePlayer.getProfile(profile)));
        player.setState(turtle);
        return player;
    }

    private static GameProfile getProfile(@Nullable GameProfile profile) {
        return profile != null ? profile : DEFAULT_PROFILE;
    }

    public static TurtlePlayer get(ITurtleAccess access) {
        if (!(access instanceof TurtleBrain)) {
            throw new IllegalStateException("ITurtleAccess is not a brain");
        }
        TurtleBrain brain = (TurtleBrain)access;
        TurtlePlayer player = brain.cachedPlayer;
        if (player == null || player.player.method_7334() != TurtlePlayer.getProfile(access.getOwningPlayer()) || player.player.method_51469() != access.getLevel()) {
            player = brain.cachedPlayer = TurtlePlayer.create(brain);
        } else {
            player.setState(access);
        }
        return player;
    }

    public static TurtlePlayer getWithPosition(ITurtleAccess turtle, class_2338 position, class_2350 direction) {
        TurtlePlayer turtlePlayer = TurtlePlayer.get(turtle);
        turtlePlayer.setPosition(turtle, position, direction);
        return turtlePlayer;
    }

    public class_3222 player() {
        return this.player;
    }

    private void setRotation(float y, float x) {
        this.player.method_36456(y);
        this.player.method_36457(x);
    }

    private void setState(ITurtleAccess turtle) {
        if (this.player.field_7512 != this.player.field_7498) {
            LOGGER.warn("Turtle has open container ({})", (Object)this.player.field_7512);
            this.player.method_14247();
        }
        class_2338 position = turtle.getPosition();
        this.player.method_23327((double)position.method_10263() + 0.5, (double)position.method_10264() + 0.5, (double)position.method_10260() + 0.5);
        this.setRotation(turtle.getDirection().method_10144(), 0.0f);
        this.player.method_31548().method_5448();
        this.trySetAttribute((class_6880<class_1320>)class_5134.field_47758, 2.0);
        this.trySetAttribute((class_6880<class_1320>)class_5134.field_47759, 2.0);
    }

    private void trySetAttribute(class_6880<class_1320> attribute, double value) {
        class_1324 instance = this.player.method_5996(attribute);
        if (instance != null) {
            instance.method_6192(value);
        }
    }

    public void setPosition(ITurtleAccess turtle, class_2338 position, class_2350 direction) {
        double posX = (double)position.method_10263() + 0.5;
        double posY = (double)position.method_10264() + 0.5;
        double posZ = (double)position.method_10260() + 0.5;
        if (turtle.getPosition().equals((Object)position)) {
            posX += 0.48 * (double)direction.method_10148();
            posY += 0.48 * (double)direction.method_10164();
            posZ += 0.48 * (double)direction.method_10165();
        }
        if (direction.method_10166() != class_2350.class_2351.field_11052) {
            this.setRotation(direction.method_10144(), 0.0f);
        } else {
            this.setRotation(turtle.getDirection().method_10144(), DirectionUtil.toPitchAngle(direction));
        }
        this.player.method_23327(posX, posY, posZ);
        this.player.field_6014 = posX;
        this.player.field_6036 = posY;
        this.player.field_5969 = posZ;
        this.player.field_6004 = this.player.method_36455();
        this.player.field_6241 = this.player.field_5982 = this.player.method_36454();
        this.player.field_6259 = this.player.field_5982;
    }

    public void loadInventory(class_1799 stack) {
        this.player.method_31548().method_5448();
        this.player.method_31548().method_61496(0);
        this.player.method_31548().method_5447(0, stack);
    }

    public void loadInventory(ITurtleAccess turtle) {
        class_1661 inventory = this.player.method_31548();
        class_1263 turtleInventory = turtle.getInventory();
        int currentSlot = turtle.getSelectedSlot();
        int slots = turtleInventory.method_5439();
        inventory.method_61496(0);
        for (int i = 0; i < slots; ++i) {
            inventory.method_5447(i, turtleInventory.method_5438((currentSlot + i) % slots));
        }
    }

    public void unloadInventory(ITurtleAccess turtle) {
        if (this.player.method_6115()) {
            this.player.method_6021();
        }
        class_1661 inventory = this.player.method_31548();
        class_1263 turtleInventory = turtle.getInventory();
        int currentSlot = turtle.getSelectedSlot();
        int slots = turtleInventory.method_5439();
        inventory.method_61496(0);
        for (int i = 0; i < slots; ++i) {
            turtleInventory.method_5447((currentSlot + i) % slots, inventory.method_5438(i));
        }
        int totalSize = inventory.method_5439();
        for (int i = slots; i < totalSize; ++i) {
            TurtleUtil.storeItemOrDrop(turtle, inventory.method_5438(i));
        }
        inventory.method_5431();
    }

    public boolean isBlockProtected(class_3218 level, class_2338 pos) {
        return level.method_8503().method_3785(level, pos, (class_1657)this.player);
    }
}

