/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleRefuelHandler;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.turtle.TurtleUtil;
import java.util.OptionalInt;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public final class FurnaceRefuelHandler
implements TurtleRefuelHandler {
    @Override
    public OptionalInt refuel(ITurtleAccess turtle, class_1799 currentStack, int slot, int limit) {
        int fuelPerItem = FurnaceRefuelHandler.getFuelPerItem(((class_3218)turtle.getLevel()).method_8503(), currentStack);
        if (fuelPerItem <= 0) {
            return OptionalInt.empty();
        }
        if (limit == 0) {
            return OptionalInt.of(0);
        }
        int fuelSpaceLeft = turtle.getFuelLimit() - turtle.getFuelLevel();
        int fuelItemLimit = (int)Math.ceil((double)fuelSpaceLeft / (double)fuelPerItem);
        if (limit > fuelItemLimit) {
            limit = fuelItemLimit;
        }
        class_1799 stack = turtle.getInventory().method_5434(slot, limit);
        int fuelToGive = fuelPerItem * stack.method_7947();
        class_1799 replacementStack = PlatformHelper.get().getCraftingRemainingItem(stack);
        if (!replacementStack.method_7960()) {
            TurtleUtil.storeItemOrDrop(turtle, replacementStack);
        }
        turtle.getInventory().method_5431();
        return OptionalInt.of(fuelToGive);
    }

    private static int getFuelPerItem(MinecraftServer server, class_1799 stack) {
        return PlatformHelper.get().getBurnTime(server, stack) * 5 / 100;
    }
}

