/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.items;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.impl.UpgradeManager;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerComputerRegistry;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.core.TerminalSize;
import dan200.computercraft.shared.computer.inventory.AbstractComputerMenu;
import dan200.computercraft.shared.computer.inventory.ComputerMenuWithoutInventory;
import dan200.computercraft.shared.computer.items.ServerComputerReference;
import dan200.computercraft.shared.config.ConfigSpec;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.pocket.core.PocketBrain;
import dan200.computercraft.shared.pocket.core.PocketHolder;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.pocket.core.PocketSide;
import dan200.computercraft.shared.util.DataComponentUtil;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.NonNegativeId;
import dan200.computercraft.shared.util.StorageCapacity;
import java.util.Objects;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import net.minecraft.class_9322;
import net.minecraft.class_9331;
import net.minecraft.server.MinecraftServer;
import org.jspecify.annotations.Nullable;

public class PocketComputerItem
extends class_1792 {
    private final ComputerFamily family;

    public PocketComputerItem(class_1792.class_1793 settings, ComputerFamily family) {
        super(settings);
        this.family = family;
    }

    public void tick(class_1799 stack, PocketHolder holder, boolean passive) {
        PocketBrain brain;
        if (passive) {
            PocketServerComputer computer = PocketComputerItem.getServerComputer(holder.level().method_8503(), stack);
            if (computer == null) {
                return;
            }
            brain = computer.getBrain();
        } else {
            brain = this.getOrCreateBrain(holder.level(), holder, stack);
            brain.computer().keepAlive();
        }
        brain.tick();
        if (this.updateItem(stack, brain)) {
            holder.setChanged();
        }
    }

    private boolean updateItem(class_1799 stack, PocketBrain brain) {
        boolean on;
        boolean changed = false;
        PocketServerComputer computer = brain.computer();
        String label = computer.getLabel();
        if (!Objects.equals(label, this.getLabel(stack))) {
            changed = true;
            DataComponentUtil.setCustomName(stack, label);
        }
        if ((on = computer.isOn()) != PocketComputerItem.isMarkedOn(stack)) {
            changed = true;
            stack.method_57379((class_9331)ModRegistry.DataComponents.ON.get(), (Object)on);
        }
        return changed;
    }

    public void method_7888(class_1799 stack, class_3218 level, class_1297 entity, @Nullable class_1304 slot) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            int invSlot = InventoryUtil.findItemInInventory((class_1263)player.method_31548(), stack);
            if (invSlot != -1) {
                this.tick(stack, new PocketHolder.PlayerHolder(player, invSlot), false);
            }
        } else if (slot != null && entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            this.tick(stack, new PocketHolder.LivingEntityHolder(living, slot), true);
        }
    }

    public boolean onEntityItemUpdate(class_1799 stack, class_1542 entity) {
        class_1937 level = entity.method_37908();
        if (level.field_9236 || level.method_8503() == null) {
            return false;
        }
        this.tick(stack, new PocketHolder.ItemEntityHolder(entity), true);
        return false;
    }

    public class_1269 method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!world.field_9236) {
            PocketHolder.PlayerHolder holder = new PocketHolder.PlayerHolder((class_3222)player, InventoryUtil.getHandSlot(player, hand));
            PocketBrain brain = this.getOrCreateBrain((class_3218)world, holder, stack);
            PocketServerComputer computer = brain.computer();
            computer.turnOn();
            boolean stop = brain.onRightClick((class_3218)world);
            if (!stop) {
                PocketComputerItem.openImpl(player, stack, holder, hand == class_1268.field_5810, computer);
            }
        }
        return class_1269.field_5812;
    }

    public void open(class_1657 player, class_1799 stack, PocketHolder holder, boolean isTypingOnly) {
        PocketBrain brain = this.getOrCreateBrain(holder.level(), holder, stack);
        PocketServerComputer computer = brain.computer();
        computer.turnOn();
        PocketComputerItem.openImpl(player, stack, holder, isTypingOnly, computer);
    }

    private static void openImpl(class_1657 player, class_1799 stack, PocketHolder holder, boolean isTypingOnly, ServerComputer computer) {
        PlatformHelper.get().openMenu(player, stack.method_7964(), (id, inventory, entity) -> new ComputerMenuWithoutInventory((class_3917<? extends AbstractComputerMenu>)(isTypingOnly ? (class_3917)ModRegistry.Menus.POCKET_COMPUTER_NO_TERM.get() : (class_3917)ModRegistry.Menus.COMPUTER.get()), id, inventory, p -> holder.isValid(computer), computer), new ComputerContainerData(computer, stack));
    }

    public class_2561 method_7864(class_1799 stack) {
        return UpgradeManager.getName(this.method_7876(), PocketComputerItem.getUpgrade(stack, PocketSide.BACK), PocketComputerItem.getUpgrade(stack, PocketSide.BOTTOM));
    }

    public @Nullable String getCreatorModId(class_7225.class_7874 registries, class_1799 stack) {
        return PocketUpgrades.instance().getOwner(PocketComputerItem.getUpgradeWithData(stack, PocketSide.BACK), PocketComputerItem.getUpgradeWithData(stack, PocketSide.BOTTOM));
    }

    private PocketBrain getOrCreateBrain(class_3218 level, PocketHolder holder, class_1799 stack) {
        ServerComputerRegistry registry = ServerContext.get(level.method_8503()).registry();
        PocketServerComputer computer = PocketComputerItem.getServerComputer(registry, stack);
        if (computer != null) {
            PocketBrain brain = computer.getBrain();
            brain.updateHolder(holder);
            return brain;
        }
        int computerID = NonNegativeId.getOrCreate(level.method_8503(), stack, (class_9331)ModRegistry.DataComponents.COMPUTER_ID.get(), NonNegativeId.Computer::new, "computer");
        PocketBrain brain = new PocketBrain(holder, ServerComputer.properties(computerID, this.getFamily()).label(this.getLabel(stack)).storageCapacity(StorageCapacity.getOrDefault((StorageCapacity)stack.method_58694((class_9331)ModRegistry.DataComponents.STORAGE_CAPACITY.get()), -1L)).terminalSize((TerminalSize)stack.method_58695((class_9331)ModRegistry.DataComponents.TERMINAL_SIZE.get(), (Object)new TerminalSize((Integer)ConfigSpec.pocketTermWidth.get(), (Integer)ConfigSpec.pocketTermHeight.get()))));
        brain.setUpgrades(PocketComputerItem.getUpgradeWithData(stack, PocketSide.BACK), PocketComputerItem.getUpgradeWithData(stack, PocketSide.BOTTOM));
        PocketServerComputer computer2 = brain.computer();
        stack.method_57379((class_9331)ModRegistry.DataComponents.COMPUTER.get(), (Object)new ServerComputerReference(registry.getSessionID(), computer2.register()));
        if (PocketComputerItem.isMarkedOn(stack)) {
            computer2.turnOn();
        }
        this.updateItem(stack, brain);
        holder.setChanged();
        return brain;
    }

    public static boolean isServerComputer(ServerComputer computer, class_1799 stack) {
        return stack.method_7909() instanceof PocketComputerItem && PocketComputerItem.getServerComputer(computer.getLevel().method_8503(), stack) == computer;
    }

    public static @Nullable PocketServerComputer getServerComputer(ServerComputerRegistry registry, class_1799 stack) {
        return (PocketServerComputer)ServerComputerReference.get((class_9322)stack, registry);
    }

    public static @Nullable PocketServerComputer getServerComputer(MinecraftServer server, class_1799 stack) {
        return PocketComputerItem.getServerComputer(ServerContext.get(server).registry(), stack);
    }

    public void method_7843(class_1799 stack, class_1937 level) {
        MinecraftServer server = level.method_8503();
        if (server == null) {
            return;
        }
        PocketServerComputer computer = PocketComputerItem.getServerComputer(server, stack);
        if (computer == null) {
            return;
        }
        computer.getBrain().setUpgrades(PocketComputerItem.getUpgradeWithData(stack, PocketSide.BACK), PocketComputerItem.getUpgradeWithData(stack, PocketSide.BOTTOM));
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    private @Nullable String getLabel(class_1799 stack) {
        return DataComponentUtil.getCustomName((class_9322)stack);
    }

    private static boolean isMarkedOn(class_1799 stack) {
        return (Boolean)stack.method_58695((class_9331)ModRegistry.DataComponents.ON.get(), (Object)false);
    }

    public static @Nullable IPocketUpgrade getUpgrade(class_1799 stack, PocketSide side) {
        UpgradeData<IPocketUpgrade> upgrade = PocketComputerItem.getUpgradeWithData(stack, side);
        return upgrade == null ? null : upgrade.upgrade();
    }

    public static @Nullable UpgradeData<IPocketUpgrade> getUpgradeWithData(class_1799 stack, PocketSide side) {
        return (UpgradeData)stack.method_58694(switch (side) {
            default -> throw new MatchException(null, null);
            case PocketSide.BACK -> (class_9331)ModRegistry.DataComponents.BACK_POCKET_UPGRADE.get();
            case PocketSide.BOTTOM -> (class_9331)ModRegistry.DataComponents.BOTTOM_POCKET_UPGRADE.get();
        });
    }
}

