/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.apis;

import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.shared.pocket.core.PocketComputerInternal;
import dan200.computercraft.shared.pocket.core.PocketSide;
import java.util.Objects;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_7225;
import org.jspecify.annotations.Nullable;

public class PocketAPI
implements ILuaAPI {
    private final PocketComputerInternal pocket;

    public PocketAPI(PocketComputerInternal pocket) {
        this.pocket = pocket;
    }

    @Override
    public String[] getNames() {
        return new String[]{"pocket"};
    }

    @LuaFunction(mainThread=true)
    public final Object[] equipBack() {
        return this.equip(PocketSide.BACK);
    }

    @LuaFunction(mainThread=true)
    public final Object[] equipBottom() {
        return this.equip(PocketSide.BOTTOM);
    }

    private Object[] equip(PocketSide side) {
        class_1297 entity = this.pocket.getEntity();
        if (!(entity instanceof class_1657)) {
            return new Object[]{false, "Cannot find player"};
        }
        class_1657 player = (class_1657)entity;
        class_1661 inventory = player.method_31548();
        UpgradeData<IPocketUpgrade> previousUpgrade = this.pocket.getUpgrade(side);
        UpgradeData<IPocketUpgrade> newUpgrade = null;
        for (int i = 0; i < 36 && (newUpgrade = this.findUpgrade((class_1263)inventory, (i + inventory.method_67532()) % 36, previousUpgrade)) == null; ++i) {
        }
        if (newUpgrade == null) {
            newUpgrade = this.findUpgrade((class_1263)inventory, 40, previousUpgrade);
        }
        if (newUpgrade == null) {
            return new Object[]{false, "Cannot find a valid upgrade"};
        }
        if (previousUpgrade != null) {
            PocketAPI.storeItem(player, previousUpgrade.getUpgradeItem());
        }
        this.pocket.setUpgrade(side, newUpgrade);
        return new Object[]{true};
    }

    @LuaFunction(mainThread=true)
    public final Object[] unequipBack() {
        return this.unequip(PocketSide.BACK);
    }

    @LuaFunction(mainThread=true)
    public final Object[] unequipBottom() {
        return this.unequip(PocketSide.BOTTOM);
    }

    private Object[] unequip(PocketSide side) {
        class_1297 entity = this.pocket.getEntity();
        if (!(entity instanceof class_1657)) {
            return new Object[]{false, "Cannot find player"};
        }
        class_1657 player = (class_1657)entity;
        UpgradeData<IPocketUpgrade> previousUpgrade = this.pocket.getUpgrade(side);
        if (previousUpgrade == null) {
            return new Object[]{false, "Nothing to unequip"};
        }
        this.pocket.setUpgrade(side, null);
        PocketAPI.storeItem(player, previousUpgrade.getUpgradeItem());
        return new Object[]{true};
    }

    private static void storeItem(class_1657 player, class_1799 stack) {
        class_1542 drop;
        if (!stack.method_7960() && !player.method_31548().method_7394(stack) && (drop = player.method_7328(stack, false)) != null) {
            drop.method_6975();
        }
    }

    private @Nullable UpgradeData<IPocketUpgrade> findUpgrade(class_1263 inv, int slot, @Nullable UpgradeData<IPocketUpgrade> previous) {
        class_1799 invStack = inv.method_5438(slot);
        if (invStack.method_7960()) {
            return null;
        }
        UpgradeData<IPocketUpgrade> newUpgrade = PocketUpgrades.instance().get((class_7225.class_7874)this.pocket.getLevel().method_30349(), invStack);
        if (newUpgrade != null && !Objects.equals(newUpgrade, previous)) {
            invStack = invStack.method_7972();
            invStack.method_7934(1);
            inv.method_5447(slot, invStack.method_7960() ? class_1799.field_8037 : invStack);
            return newUpgrade;
        }
        return null;
    }
}

