/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.platform;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.impl.Services;
import dan200.computercraft.shared.config.ConfigFile;
import dan200.computercraft.shared.network.container.ContainerData;
import dan200.computercraft.shared.platform.ComponentAccess;
import dan200.computercraft.shared.platform.ContainerTransfer;
import dan200.computercraft.shared.platform.RecipeIngredients;
import dan200.computercraft.shared.platform.RegistrationHelper;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1270;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2314;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.jspecify.annotations.Nullable;

public interface PlatformHelper {
    public static PlatformHelper get() {
        PlatformHelper instance = Instance.INSTANCE;
        return instance == null ? Services.raise(PlatformHelper.class, Instance.ERROR) : instance;
    }

    public boolean isModLoaded(String var1);

    public ConfigFile.Builder createConfigBuilder();

    public <T> RegistrationHelper<T> createRegistrationHelper(class_5321<class_2378<T>> var1);

    public <A extends ArgumentType<?>, T extends class_2314.class_7217<A>, I extends class_2314<A, T>> I registerArgumentTypeInfo(Class<A> var1, I var2);

    public <C extends class_1703, T extends ContainerData> class_3917<C> createMenuType(class_9139<class_9129, T> var1, ContainerData.Factory<C, T> var2);

    public void openMenu(class_1657 var1, class_2561 var2, class_1270 var3, ContainerData var4);

    default public void invalidateComponent(class_2586 owner) {
    }

    public ComponentAccess<IPeripheral> createPeripheralAccess(class_2586 var1, Consumer<class_2350> var2);

    public ComponentAccess<WiredElement> createWiredElementAccess(class_2586 var1, Consumer<class_2350> var2);

    public boolean hasWiredElementIn(class_1937 var1, class_2338 var2, class_2350 var3);

    public ContainerTransfer.Slotted wrapContainer(class_1263 var1);

    public @Nullable ContainerTransfer getContainer(class_3218 var1, class_2338 var2, class_2350 var3);

    public RecipeIngredients getRecipeIngredients();

    public List<class_6862<class_1792>> getDyeTags();

    public int getBurnTime(MinecraftServer var1, class_1799 var2);

    public class_1761.class_7913 newCreativeModeTab();

    public class_1799 getCraftingRemainingItem(class_1799 var1);

    public boolean onNotifyNeighbour(class_1937 var1, class_2338 var2, class_2680 var3, class_2350 var4);

    public class_3222 createFakePlayer(class_3218 var1, GameProfile var2);

    default public boolean isFakePlayer(class_3222 player) {
        return player.field_13987 == null || player.getClass() != class_3222.class;
    }

    public boolean hasToolUsage(class_1799 var1);

    public class_1269 canAttackEntity(class_3222 var1, class_1297 var2);

    public boolean interactWithEntity(class_3222 var1, class_1297 var2, class_243 var3);

    public UseOnResult useOn(class_3222 var1, class_1799 var2, class_3965 var3);

    public @Nullable IMedia getMedia(class_1799 var1);

    public class_2558 createOpenFolderAction(Path var1);

    public static final class Instance {
        static final @Nullable PlatformHelper INSTANCE;
        static final @Nullable Throwable ERROR;

        private Instance() {
        }

        static {
            Services.LoadedService<PlatformHelper> helper = Services.tryLoad(PlatformHelper.class);
            INSTANCE = helper.instance();
            ERROR = helper.error();
        }
    }

    public static sealed interface UseOnResult {

        public record Continue(boolean block, boolean item) implements UseOnResult
        {
        }

        public record Handled(class_1269 result) implements UseOnResult
        {
        }
    }
}

