/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.redstone;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.redstone.RedstoneState;
import dan200.computercraft.impl.BundledRedstone;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.peripheral.redstone.RedstoneRelayPeripheral;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.RedstoneUtil;
import dan200.computercraft.shared.util.TickScheduler;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public final class RedstoneRelayBlockEntity
extends class_2586 {
    private final TickScheduler.Token tickToken = new TickScheduler.Token(this);
    private final RedstoneState redstoneState = new RedstoneState(() -> TickScheduler.schedule(this.tickToken));
    private final RedstoneRelayPeripheral peripheral = new RedstoneRelayPeripheral(this.redstoneState);

    public RedstoneRelayBlockEntity(class_2338 pos, class_2680 blockState) {
        super((class_2591)ModRegistry.BlockEntities.REDSTONE_RELAY.get(), pos, blockState);
    }

    public void method_10996() {
        super.method_10996();
        TickScheduler.schedule(this.tickToken);
    }

    void update() {
        int changes = this.redstoneState.updateOutput();
        if (changes != 0) {
            for (class_2350 direction : DirectionUtil.FACINGS) {
                if ((changes & 1 << this.mapSide(direction).ordinal()) == 0) continue;
                this.updateRedstoneTo(direction);
            }
        }
        if (this.redstoneState.pollInputChanged()) {
            this.peripheral.queueRedstoneEvent();
        }
    }

    void neighborChanged() {
        for (class_2350 dir : DirectionUtil.FACINGS) {
            this.updateRedstoneInput(dir, this.method_11016().method_10093(dir), false);
        }
    }

    private void updateRedstoneTo(class_2350 direction) {
        RedstoneUtil.propagateRedstoneOutput(this.method_10997(), this.method_11016(), direction);
        this.updateRedstoneInput(direction, this.method_11016().method_10093(direction), true);
    }

    private void updateRedstoneInput(class_2350 dir, class_2338 targetPos, boolean ticking) {
        boolean changed = this.redstoneState.setInput(this.mapSide(dir), RedstoneUtil.getRedstoneInput(this.method_10997(), targetPos, dir), BundledRedstone.getOutput(this.method_10997(), targetPos, dir.method_10153()));
        if (changed && !ticking) {
            TickScheduler.schedule(this.tickToken);
        }
    }

    private ComputerSide mapSide(class_2350 globalSide) {
        return DirectionUtil.toLocal((class_2350)this.method_11010().method_11654((class_2769)class_2383.field_11177), globalSide);
    }

    int getRedstoneOutput(class_2350 side) {
        return this.redstoneState.getExternalOutput(this.mapSide(side));
    }

    int getBundledRedstoneOutput(class_2350 side) {
        return this.redstoneState.getExternalBundledOutput(this.mapSide(side));
    }

    public IPeripheral peripheral() {
        return this.peripheral;
    }
}

