/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wireless;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.network.PacketNetwork;
import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.peripheral.modem.ModemPeripheral;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import net.minecraft.class_1937;
import net.minecraft.class_243;

public abstract class WirelessModemPeripheral
extends ModemPeripheral {
    public static final String NORMAL_ADJECTIVE = "upgrade.computercraft.wireless_modem_normal.adjective";
    public static final String ADVANCED_ADJECTIVE = "upgrade.computercraft.wireless_modem_advanced.adjective";
    private final boolean advanced;

    public WirelessModemPeripheral(ModemState state, boolean advanced) {
        super(state);
        this.advanced = advanced;
    }

    @Override
    public boolean isInterdimensional() {
        return this.advanced;
    }

    @Override
    public double getRange() {
        if (this.advanced) {
            return 2.147483647E9;
        }
        class_1937 world = this.getLevel();
        if (world != null) {
            class_243 position = this.getPosition();
            double minRange = Config.modemRange;
            double maxRange = Config.modemHighAltitudeRange;
            if (world.method_8419() && world.method_8546()) {
                minRange = Config.modemRangeDuringStorm;
                maxRange = Config.modemHighAltitudeRangeDuringStorm;
            }
            if (position.field_1351 > 96.0 && maxRange > minRange) {
                return minRange + (position.field_1351 - 96.0) * ((maxRange - minRange) / ((double)world.method_31600() - 96.0));
            }
            return minRange;
        }
        return 0.0;
    }

    @Override
    protected PacketNetwork getNetwork() {
        return ComputerCraftAPI.getWirelessNetwork(Nullability.assertNonNull(this.getLevel().method_8503()));
    }
}

