/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.codec;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import java.nio.ByteBuffer;
import java.util.OptionalInt;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_8703;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class MoreStreamCodecs {
    public static final class_9139<ByteBuf, class_243> VEC3 = class_9139.method_56436((class_9139)class_9135.field_48553, class_243::method_10216, (class_9139)class_9135.field_48553, class_243::method_10214, (class_9139)class_9135.field_48553, class_243::method_10215, class_243::new);
    public static final class_9139<ByteBuf, OptionalInt> OPTIONAL_INT = new class_9139<ByteBuf, OptionalInt>(){

        public OptionalInt decode(ByteBuf buf) {
            return buf.readBoolean() ? OptionalInt.of((Integer)class_9135.field_48550.decode((Object)buf)) : OptionalInt.empty();
        }

        public void encode(ByteBuf buf, OptionalInt optional) {
            if (optional.isPresent()) {
                buf.writeBoolean(true);
                class_9135.field_48550.encode((Object)buf, (Object)optional.getAsInt());
            } else {
                buf.writeBoolean(false);
            }
        }
    };
    public static final class_9139<ByteBuf, ByteBuffer> BYTE_BUFFER = MoreStreamCodecs.byteBuffer(Integer.MAX_VALUE);

    public static <B extends class_2540, C extends Enum<C>> class_9139<B, C> ofEnum(final Class<C> klass) {
        return new class_9139<B, C>(){

            public C decode(B buffer) {
                return buffer.method_10818(klass);
            }

            public void encode(B buffer, C value) {
                buffer.method_10817(value);
            }
        };
    }

    public static <B extends class_2540, C> class_9139<B, class_2371<C>> nonNullList(final class_9139<B, C> codec, final C empty) {
        return new class_9139<B, class_2371<C>>(){

            public class_2371<C> decode(B buffer) {
                int count = buffer.method_10816();
                class_2371 result = class_2371.method_10213((int)count, (Object)empty);
                for (int i = 0; i < result.size(); ++i) {
                    result.set(i, codec.decode(buffer));
                }
                return result;
            }

            public void encode(B buffer, class_2371<C> list) {
                buffer.method_10804(list.size());
                for (Object entry : list) {
                    codec.encode(buffer, entry);
                }
            }
        };
    }

    public static class_9139<ByteBuf, ByteBuffer> byteBuffer(final int limit) {
        return new class_9139<ByteBuf, ByteBuffer>(){

            public ByteBuffer decode(ByteBuf buf) {
                int toRead = class_8703.method_53016((ByteBuf)buf);
                if (toRead > buf.readableBytes() || toRead >= limit) {
                    throw new DecoderException("ByteArray with size " + toRead + " is bigger than allowed");
                }
                byte[] bytes = new byte[toRead];
                buf.readBytes(bytes);
                return ByteBuffer.wrap(bytes).asReadOnlyBuffer();
            }

            public void encode(ByteBuf buf, ByteBuffer buffer) {
                class_8703.method_53017((ByteBuf)buf, (int)buffer.remaining());
                buf.writeBytes(buffer.duplicate());
            }
        };
    }
}

