/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.media.items.PrintoutData;
import dan200.computercraft.shared.recipe.AbstractCraftingRecipe;
import dan200.computercraft.shared.recipe.ShapelessRecipeSpec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10295;
import net.minecraft.class_10301;
import net.minecraft.class_10302;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9322;
import net.minecraft.class_9331;
import net.minecraft.class_9694;
import net.minecraft.class_9875;
import net.minecraft.class_9887;
import org.jspecify.annotations.Nullable;

public final class PrintoutRecipe
extends AbstractCraftingRecipe {
    public static final MapCodec<PrintoutRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ShapelessRecipeSpec.CODEC.forGetter(PrintoutRecipe::toSpec), (App)class_1856.field_46095.fieldOf("printout").forGetter(x -> x.printout), (App)class_5699.field_33442.fieldOf("min_printouts").forGetter(x -> x.minPrintouts)).apply((Applicative)instance, PrintoutRecipe::new));
    public static final class_9139<class_9129, PrintoutRecipe> STREAM_CODEC = class_9139.method_56436(ShapelessRecipeSpec.STREAM_CODEC, PrintoutRecipe::toSpec, (class_9139)class_1856.field_48355, x -> x.printout, (class_9139)class_9135.field_48550, x -> x.minPrintouts, PrintoutRecipe::new);
    private final ShapelessRecipeSpec spec;
    private final List<class_1856> ingredients;
    private @Nullable class_9887 ingredientInfo;
    private final List<class_1856> placementIngredients;
    private @Nullable class_9887 placementInfo;
    private final class_1856 printout;
    private final int minPrintouts;

    public PrintoutRecipe(ShapelessRecipeSpec spec, class_1856 printout, int minPrintouts) {
        super(spec.properties());
        this.spec = spec;
        this.ingredients = spec.ingredients();
        this.placementIngredients = PrintoutRecipe.concat(spec.ingredients(), printout, minPrintouts);
        this.printout = printout;
        this.minPrintouts = minPrintouts;
    }

    private static List<class_1856> concat(List<class_1856> first, class_1856 pages, int pagesRequired) {
        ArrayList<class_1856> result = new ArrayList<class_1856>(first.size() + pagesRequired);
        result.addAll(first);
        for (int i = 0; i < pagesRequired; ++i) {
            result.add(pages);
        }
        return result;
    }

    public class_9887 method_61671() {
        if (this.placementInfo == null) {
            this.placementInfo = class_9887.method_61686(this.placementIngredients);
        }
        return this.placementInfo;
    }

    public List<class_10295> method_64664() {
        return List.of(new class_10301(this.placementIngredients.stream().map(class_1856::method_64673).toList(), (class_10302)new class_10302.class_10307(this.spec.result()), (class_10302)new class_10302.class_10306(class_1802.field_8465)));
    }

    public boolean matches(class_9694 inv, class_1937 world) {
        class_9875 stackedContents = new class_9875();
        int inputs = 0;
        int printouts = 0;
        int pages = 0;
        boolean hasPrintout = false;
        for (int j = 0; j < inv.method_59983(); ++j) {
            class_1799 stack = inv.method_59984(j);
            if (stack.method_7960()) continue;
            if (this.printout.method_8093(stack)) {
                ++printouts;
                PrintoutData printout = (PrintoutData)stack.method_58694((class_9331)ModRegistry.DataComponents.PRINTOUT.get());
                if (printout == null) {
                    ++pages;
                    continue;
                }
                hasPrintout = true;
                pages += printout.pages();
                continue;
            }
            ++inputs;
            stackedContents.method_61536(stack, 1);
        }
        return hasPrintout && printouts >= this.minPrintouts && pages <= 16 && inputs == this.ingredients.size() && stackedContents.method_64645(this.getIngredientInfo().method_64675(), null);
    }

    private class_9887 getIngredientInfo() {
        if (this.ingredientInfo == null) {
            this.ingredientInfo = class_9887.method_61686(this.ingredients);
        }
        return this.ingredientInfo;
    }

    public class_1799 assemble(class_9694 inv, class_7225.class_7874 registries) {
        ArrayList<PrintoutData> data = new ArrayList<PrintoutData>();
        for (int j = 0; j < inv.method_59983(); ++j) {
            class_1799 stack = inv.method_59984(j);
            if (stack.method_7960() || !this.printout.method_8093(stack)) continue;
            data.add(PrintoutData.getOrEmpty((class_9322)stack));
        }
        if (data.isEmpty()) {
            throw new IllegalStateException("Printouts must be non-null");
        }
        List<PrintoutData.Line> lines = data.stream().flatMap(x -> x.lines().stream()).toList();
        class_1799 result = this.spec.result().method_7972();
        result.method_57379((class_9331)ModRegistry.DataComponents.PRINTOUT.get(), (Object)new PrintoutData(((PrintoutData)data.getFirst()).title(), lines));
        return result;
    }

    private ShapelessRecipeSpec toSpec() {
        return this.spec;
    }

    public class_1865<PrintoutRecipe> method_8119() {
        return (class_1865)ModRegistry.RecipeSerializers.PRINTOUT.get();
    }
}

