/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.recipe.AbstractCraftingRecipe;
import dan200.computercraft.shared.recipe.RecipeProperties;
import dan200.computercraft.shared.recipe.ShapelessRecipeSpec;
import dan200.computercraft.shared.util.ColourTracker;
import dan200.computercraft.shared.util.ColourUtils;
import dan200.computercraft.shared.util.DataComponentUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_10295;
import net.minecraft.class_10301;
import net.minecraft.class_10302;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9694;
import net.minecraft.class_9875;
import net.minecraft.class_9887;
import org.jspecify.annotations.Nullable;

public class DiskRecipe
extends AbstractCraftingRecipe {
    public static final MapCodec<DiskRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RecipeProperties.CODEC.forGetter(x -> x.properties), (App)ShapelessRecipeSpec.INGREDIENT_CODEC.fieldOf("ingredients").forGetter(x -> x.ingredients)).apply((Applicative)instance, DiskRecipe::new));
    public static final class_9139<class_9129, DiskRecipe> STREAM_CODEC = class_9139.method_56435(RecipeProperties.STREAM_CODEC, x -> x.properties, (class_9139)class_1856.field_48355.method_56433(class_9135.method_56363()), x -> x.ingredients, DiskRecipe::new);
    private final List<class_1856> ingredients;
    private @Nullable class_9887 placementInfo;

    public DiskRecipe(RecipeProperties properties, List<class_1856> ingredients) {
        super(properties);
        this.ingredients = ingredients;
    }

    public class_9887 method_61671() {
        if (this.placementInfo == null) {
            this.placementInfo = class_9887.method_61686(this.ingredients);
        }
        return this.placementInfo;
    }

    public List<class_10295> method_64664() {
        List<class_6862<class_1792>> dyes = ColourUtils.DYES;
        ArrayList<class_10295> out = new ArrayList<class_10295>(dyes.size());
        for (int i = 0; i < dyes.size(); ++i) {
            out.add((class_10295)new class_10301(Stream.concat(this.ingredients.stream(), Stream.of(class_1856.method_8106((class_6885)class_7923.field_41178.method_46735(dyes.get(i))))).map(class_1856::method_64673).toList(), (class_10302)new class_10302.class_10307(DataComponentUtil.createDyedStack((class_1935)ModRegistry.Items.DISK.get(), class_1767.method_7791((int)i).method_7787())), (class_10302)new class_10302.class_10306(class_1802.field_8465)));
        }
        return out;
    }

    public boolean matches(class_9694 inv, class_1937 world) {
        int inputs = 0;
        class_9875 stackedContents = new class_9875();
        for (int i = 0; i < inv.method_59983(); ++i) {
            class_1799 stack = inv.method_59984(i);
            if (stack.method_7960() || ColourUtils.getStackColour(stack) != null) continue;
            ++inputs;
            stackedContents.method_61536(stack, 1);
        }
        return inputs == this.ingredients.size() && stackedContents.method_64645(this.method_61671().method_64675(), null);
    }

    public class_1799 assemble(class_9694 inv, class_7225.class_7874 registryAccess) {
        ColourTracker tracker = new ColourTracker();
        for (int i = 0; i < inv.method_59983(); ++i) {
            class_1767 dye;
            class_1799 stack = inv.method_59984(i);
            if (stack.method_7960() || (dye = ColourUtils.getStackColour(stack)) == null) continue;
            tracker.addColour(dye);
        }
        return DataComponentUtil.createDyedStack((class_1935)ModRegistry.Items.DISK.get(), tracker.getColourOr(Colour.BLUE.getHex()));
    }

    public class_1865<DiskRecipe> method_8119() {
        return (class_1865)ModRegistry.RecipeSerializers.DISK.get();
    }
}

