/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeBase;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.integration.RecipeModHelpers;
import dan200.computercraft.shared.pocket.core.PocketSide;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import dan200.computercraft.shared.util.DataComponentUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_10300;
import net.minecraft.class_10302;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9331;
import org.jspecify.annotations.Nullable;

public class UpgradeRecipeGenerator<T> {
    private static final class_10302 CRAFTING_STATION = new class_10302.class_10306(class_1802.field_8465);
    private final Function<class_10300, T> wrap;
    private final class_7225.class_7874 registries;
    private final Map<class_1792, List<UpgradeInfo>> upgradeItemLookup = new HashMap<class_1792, List<UpgradeInfo>>();
    private final List<UpgradeInfo> pocketUpgrades = new ArrayList<UpgradeInfo>();
    private final List<UpgradeInfo> turtleUpgrades = new ArrayList<UpgradeInfo>();
    private boolean initialised = false;

    public UpgradeRecipeGenerator(Function<class_10300, T> wrap, class_7225.class_7874 registries) {
        this.wrap = wrap;
        this.registries = registries;
    }

    private void setupCache() {
        if (this.initialised) {
            return;
        }
        this.initialised = true;
        RecipeModHelpers.forEachRegistry(this.registries, ITurtleUpgrade.REGISTRY, holder -> {
            ITurtleUpgrade upgrade = (ITurtleUpgrade)holder.comp_349();
            class_1799 stack = upgrade.getCraftingItem();
            if (stack.method_7960()) {
                return;
            }
            UpgradeInfo info = new UpgradeInfo(stack, upgrade, (class_6880.class_6883<ITurtleUpgrade>)holder, null);
            this.upgradeItemLookup.computeIfAbsent(stack.method_7909(), k -> new ArrayList(1)).add(info);
            this.turtleUpgrades.add(info);
        });
        RecipeModHelpers.forEachRegistry(this.registries, IPocketUpgrade.REGISTRY, holder -> {
            IPocketUpgrade upgrade = (IPocketUpgrade)holder.comp_349();
            class_1799 stack = upgrade.getCraftingItem();
            if (stack.method_7960()) {
                return;
            }
            UpgradeInfo info = new UpgradeInfo(stack, upgrade, null, (class_6880.class_6883<IPocketUpgrade>)holder);
            this.upgradeItemLookup.computeIfAbsent(stack.method_7909(), k -> new ArrayList(1)).add(info);
            this.pocketUpgrades.add(info);
        });
    }

    public boolean isUpgrade(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        this.setupCache();
        List<UpgradeInfo> upgrades = this.upgradeItemLookup.get(stack.method_7909());
        if (upgrades == null) {
            return false;
        }
        for (UpgradeInfo upgrade : upgrades) {
            class_1799 craftingStack = upgrade.stack;
            if (craftingStack.method_7960() || craftingStack.method_7909() != stack.method_7909() || !upgrade.upgrade.isItemSuitable(stack)) continue;
            return true;
        }
        return false;
    }

    public List<T> findRecipesWithInput(class_1799 stack) {
        this.setupCache();
        if (stack.method_7909() instanceof TurtleItem) {
            UpgradeData<ITurtleUpgrade> left = TurtleItem.getUpgradeWithData(stack, TurtleSide.LEFT);
            UpgradeData<ITurtleUpgrade> right = TurtleItem.getUpgradeWithData(stack, TurtleSide.RIGHT);
            if (left != null && right != null) {
                return List.of();
            }
            ArrayList<T> recipes = new ArrayList<T>();
            class_10302.class_10307 ingredient = new class_10302.class_10307(stack);
            for (UpgradeInfo upgrade : this.turtleUpgrades) {
                if (upgrade.turtle == null) {
                    throw new NullPointerException();
                }
                if (left == null) {
                    recipes.add(this.turtle((class_10302)ingredient, upgrade.ingredient, UpgradeRecipeGenerator.turtleWith(stack, UpgradeData.ofDefault(upgrade.turtle), right)));
                }
                if (right != null) continue;
                recipes.add(this.turtle(upgrade.ingredient, (class_10302)ingredient, UpgradeRecipeGenerator.turtleWith(stack, left, UpgradeData.ofDefault(upgrade.turtle))));
            }
            return Collections.unmodifiableList(recipes);
        }
        if (stack.method_7909() instanceof PocketComputerItem) {
            UpgradeData<IPocketUpgrade> back = PocketComputerItem.getUpgradeWithData(stack, PocketSide.BACK);
            UpgradeData<IPocketUpgrade> bottom = PocketComputerItem.getUpgradeWithData(stack, PocketSide.BOTTOM);
            if (back != null && bottom != null) {
                return List.of();
            }
            ArrayList<T> recipes = new ArrayList<T>();
            class_10302.class_10307 ingredient = new class_10302.class_10307(stack);
            for (UpgradeInfo upgrade : this.pocketUpgrades) {
                if (upgrade.pocket == null) {
                    throw new NullPointerException();
                }
                if (back == null) {
                    recipes.add(this.pocket(upgrade.ingredient, (class_10302)ingredient, UpgradeRecipeGenerator.pocketWith(stack, UpgradeData.ofDefault(upgrade.pocket), bottom)));
                }
                if (bottom != null) continue;
                recipes.add(this.pocket((class_10302)ingredient, upgrade.ingredient, UpgradeRecipeGenerator.pocketWith(stack, back, UpgradeData.ofDefault(upgrade.pocket))));
            }
            return Collections.unmodifiableList(recipes);
        }
        List<UpgradeInfo> upgrades = this.upgradeItemLookup.get(stack.method_7909());
        if (upgrades == null) {
            return List.of();
        }
        List recipes = null;
        boolean multiple = false;
        for (UpgradeInfo upgrade : upgrades) {
            class_1799 craftingStack = upgrade.stack;
            if (craftingStack.method_7960() || craftingStack.method_7909() != stack.method_7909() || !upgrade.upgrade.isItemSuitable(stack)) continue;
            if (recipes == null) {
                recipes = upgrade.getRecipes();
                continue;
            }
            if (!multiple) {
                multiple = true;
                recipes = new ArrayList(recipes);
            }
            recipes.addAll(upgrade.getRecipes());
        }
        return recipes == null ? List.of() : Collections.unmodifiableList(recipes);
    }

    public List<T> findRecipesWithOutput(class_1799 stack) {
        if (stack.method_7909() instanceof TurtleItem) {
            ArrayList<T> recipes = new ArrayList<T>(0);
            UpgradeData<ITurtleUpgrade> left = TurtleItem.getUpgradeWithData(stack, TurtleSide.LEFT);
            UpgradeData<ITurtleUpgrade> right = TurtleItem.getUpgradeWithData(stack, TurtleSide.RIGHT);
            if (left != null) {
                recipes.add(this.turtle((class_10302)new class_10302.class_10307(UpgradeRecipeGenerator.turtleWith(stack, null, right)), (class_10302)new class_10302.class_10307(left.getUpgradeItem()), stack));
            }
            if (right != null) {
                recipes.add(this.turtle((class_10302)new class_10302.class_10307(right.getUpgradeItem()), (class_10302)new class_10302.class_10307(UpgradeRecipeGenerator.turtleWith(stack, left, null)), stack));
            }
            return Collections.unmodifiableList(recipes);
        }
        if (stack.method_7909() instanceof PocketComputerItem) {
            ArrayList<T> recipes = new ArrayList<T>(0);
            UpgradeData<IPocketUpgrade> back = PocketComputerItem.getUpgradeWithData(stack, PocketSide.BACK);
            UpgradeData<IPocketUpgrade> bottom = PocketComputerItem.getUpgradeWithData(stack, PocketSide.BOTTOM);
            if (back != null) {
                recipes.add(this.pocket((class_10302)new class_10302.class_10307(back.getUpgradeItem()), (class_10302)new class_10302.class_10307(UpgradeRecipeGenerator.pocketWith(stack, null, bottom)), stack));
            }
            if (bottom != null) {
                recipes.add(this.pocket((class_10302)new class_10302.class_10307(UpgradeRecipeGenerator.pocketWith(stack, back, null)), (class_10302)new class_10302.class_10307(bottom.getUpgradeItem()), stack));
            }
            return Collections.unmodifiableList(recipes);
        }
        return List.of();
    }

    private static class_1799 turtleWith(class_1799 stack, @Nullable UpgradeData<ITurtleUpgrade> left, @Nullable UpgradeData<ITurtleUpgrade> right) {
        class_1799 newStack = stack.method_46651(1);
        newStack.method_57379((class_9331)ModRegistry.DataComponents.LEFT_TURTLE_UPGRADE.get(), left);
        newStack.method_57379((class_9331)ModRegistry.DataComponents.RIGHT_TURTLE_UPGRADE.get(), right);
        return newStack;
    }

    private static class_1799 pocketWith(class_1799 stack, @Nullable UpgradeData<IPocketUpgrade> back, @Nullable UpgradeData<IPocketUpgrade> bottom) {
        class_1799 newStack = stack.method_46651(1);
        newStack.method_57379((class_9331)ModRegistry.DataComponents.BACK_POCKET_UPGRADE.get(), back);
        newStack.method_57379((class_9331)ModRegistry.DataComponents.BOTTOM_POCKET_UPGRADE.get(), bottom);
        return newStack;
    }

    private T pocket(class_10302 top, class_10302 bottom, class_1799 result) {
        return this.wrap.apply(new class_10300(1, 2, List.of(top, bottom), (class_10302)new class_10302.class_10307(result), CRAFTING_STATION));
    }

    private T turtle(class_10302 left, class_10302 right, class_1799 result) {
        return this.wrap.apply(new class_10300(2, 1, List.of(left, right), (class_10302)new class_10302.class_10307(result), CRAFTING_STATION));
    }

    private class UpgradeInfo {
        final class_1799 stack;
        final class_10302 ingredient;
        final // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable class_6880.class_6883<ITurtleUpgrade> turtle;
        final // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable class_6880.class_6883<IPocketUpgrade> pocket;
        final UpgradeBase upgrade;
        private @Nullable ArrayList<T> recipes;

        UpgradeInfo(class_1799 stack, @Nullable UpgradeBase upgrade, // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable class_6880.class_6883<ITurtleUpgrade> turtle, class_6880.class_6883<IPocketUpgrade> pocket) {
            this.stack = stack;
            this.ingredient = new class_10302.class_10307(stack);
            this.turtle = turtle;
            this.pocket = pocket;
            this.upgrade = upgrade;
        }

        List<T> getRecipes() {
            ArrayList<Object> recipes = this.recipes;
            if (recipes != null) {
                return recipes;
            }
            this.recipes = new ArrayList(4);
            recipes = this.recipes;
            if (this.turtle != null) {
                for (Supplier<Object> supplier : RecipeModHelpers.TURTLES) {
                    TurtleItem turtleItem = (TurtleItem)((Object)supplier.get());
                    recipes.add(UpgradeRecipeGenerator.this.turtle(this.ingredient, (class_10302)new class_10302.class_10306((class_1792)turtleItem), DataComponentUtil.createStack((class_1935)turtleItem, (class_9331)ModRegistry.DataComponents.RIGHT_TURTLE_UPGRADE.get(), UpgradeData.ofDefault(this.turtle))));
                }
            }
            if (this.pocket != null) {
                for (Supplier<Object> supplier : RecipeModHelpers.POCKET_COMPUTERS) {
                    PocketComputerItem pocketItem = (PocketComputerItem)((Object)supplier.get());
                    recipes.add(UpgradeRecipeGenerator.this.pocket(this.ingredient, (class_10302)new class_10302.class_10306((class_1792)pocketItem), DataComponentUtil.createStack((class_1935)pocketItem, (class_9331)ModRegistry.DataComponents.BACK_POCKET_UPGRADE.get(), UpgradeData.ofDefault(this.pocket))));
                }
            }
            recipes.trimToSize();
            return recipes;
        }
    }
}

