/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.terminal;

import dan200.computercraft.core.terminal.Palette;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import net.minecraft.class_11368;
import net.minecraft.class_11372;

public class NetworkedTerminal
extends Terminal {
    public NetworkedTerminal(int width, int height, boolean colour) {
        super(width, height, colour);
    }

    public NetworkedTerminal(int width, int height, boolean colour, Runnable changedCallback) {
        super(width, height, colour, changedCallback);
    }

    synchronized TerminalState write() {
        byte[] contents = new byte[this.width * this.height * 2 + 48];
        int idx = 0;
        for (int y = 0; y < this.height; ++y) {
            int x;
            TextBuffer text = this.text[y];
            TextBuffer textColour = this.textColour[y];
            TextBuffer backColour = this.backgroundColour[y];
            for (x = 0; x < this.width; ++x) {
                contents[idx++] = (byte)(text.charAt(x) & 0xFF);
            }
            for (x = 0; x < this.width; ++x) {
                contents[idx++] = (byte)(NetworkedTerminal.getColour(backColour.charAt(x), Colour.BLACK) << 4 | NetworkedTerminal.getColour(textColour.charAt(x), Colour.WHITE));
            }
        }
        for (int i = 0; i < 16; ++i) {
            for (double channel : this.palette.getColour(i)) {
                contents[idx++] = (byte)((int)(channel * 255.0) & 0xFF);
            }
        }
        assert (idx == contents.length);
        return new TerminalState(this.colour, this.width, this.height, this.cursorX, this.cursorY, this.cursorBlink, this.cursorColour, this.cursorBackgroundColour, contents);
    }

    synchronized void read(TerminalState state) {
        this.resize(state.width, state.height);
        this.cursorX = state.cursorX;
        this.cursorY = state.cursorY;
        this.cursorBlink = state.cursorBlink;
        this.cursorBackgroundColour = state.cursorBgColour;
        this.cursorColour = state.cursorFgColour;
        byte[] contents = state.contents;
        int idx = 0;
        for (int y = 0; y < this.height; ++y) {
            int x;
            TextBuffer text = this.text[y];
            TextBuffer textColour = this.textColour[y];
            TextBuffer backColour = this.backgroundColour[y];
            for (x = 0; x < this.width; ++x) {
                text.setChar(x, (char)(contents[idx++] & 0xFF));
            }
            for (x = 0; x < this.width; ++x) {
                byte colour = contents[idx++];
                backColour.setChar(x, "0123456789abcdef".charAt(colour >> 4 & 0xF));
                textColour.setChar(x, "0123456789abcdef".charAt(colour & 0xF));
            }
        }
        for (int i = 0; i < 16; ++i) {
            double r = (double)(contents[idx++] & 0xFF) / 255.0;
            double g = (double)(contents[idx++] & 0xFF) / 255.0;
            double b = (double)(contents[idx++] & 0xFF) / 255.0;
            this.palette.setColour(i, r, g, b);
        }
        assert (idx == contents.length);
        this.setChanged();
    }

    public synchronized void writeToNBT(class_11372 nbt) {
        nbt.method_71465("term_cursorX", this.cursorX);
        nbt.method_71465("term_cursorY", this.cursorY);
        nbt.method_71472("term_cursorBlink", this.cursorBlink);
        nbt.method_71465("term_textColour", this.cursorColour);
        nbt.method_71465("term_bgColour", this.cursorBackgroundColour);
        for (int n = 0; n < this.height; ++n) {
            nbt.method_71469("term_text_" + n, this.text[n].toString());
            nbt.method_71469("term_textColour_" + n, this.textColour[n].toString());
            nbt.method_71469("term_textBgColour_" + n, this.backgroundColour[n].toString());
        }
        int[] rgb8 = new int[16];
        for (int i = 0; i < 16; ++i) {
            rgb8[i] = Palette.encodeRGB8(this.palette.getColour(i));
        }
        nbt.method_71473("term_palette", rgb8);
    }

    public synchronized void readFromNBT(class_11368 nbt) {
        this.cursorX = nbt.method_71424("term_cursorX", 0);
        this.cursorY = nbt.method_71424("term_cursorY", 0);
        this.cursorBlink = nbt.method_71433("term_cursorBlink", false);
        this.cursorColour = nbt.method_71424("term_textColour", 0);
        this.cursorBackgroundColour = nbt.method_71424("term_bgColour", 0);
        for (int n = 0; n < this.height; ++n) {
            this.text[n].fill(' ');
            String line = nbt.method_71428("term_text_" + n, "");
            if (!line.isEmpty()) {
                this.text[n].write(line);
            }
            this.textColour[n].fill("0123456789abcdef".charAt(this.cursorColour));
            String fgLine = nbt.method_71428("term_textColour_" + n, "");
            if (!fgLine.isEmpty()) {
                this.textColour[n].write(fgLine);
            }
            this.backgroundColour[n].fill("0123456789abcdef".charAt(this.cursorBackgroundColour));
            String bgLine = nbt.method_71428("term_textBgColour_" + n, "");
            if (bgLine.isEmpty()) continue;
            this.backgroundColour[n].write(bgLine);
        }
        int[] rgb8 = nbt.method_71442("term_palette").orElse(null);
        if (rgb8 != null && rgb8.length == 16) {
            for (int i = 0; i < 16; ++i) {
                double[] colours = Palette.decodeRGB8(rgb8[i]);
                this.palette.setColour(i, colours[0], colours[1], colours[2]);
            }
        }
        this.setChanged();
    }
}

