/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.core;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.component.AdminComputer;
import dan200.computercraft.api.component.ComputerComponent;
import dan200.computercraft.api.component.ComputerComponents;
import dan200.computercraft.api.filesystem.WritableMount;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.ILuaAPIFactory;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.WorkMonitor;
import dan200.computercraft.core.computer.Computer;
import dan200.computercraft.core.computer.ComputerEnvironment;
import dan200.computercraft.core.computer.ComputerEvents;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.metrics.MetricsObserver;
import dan200.computercraft.impl.ApiFactories;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ComputerSystem;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.core.TerminalSize;
import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.config.ConfigSpec;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.network.client.ComputerTerminalClientMessage;
import dan200.computercraft.shared.network.server.ServerNetworking;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jspecify.annotations.Nullable;

public class ServerComputer
implements ComputerEnvironment,
ComputerEvents.Receiver {
    public static final ComputerComponent<MetricsObserver> METRICS = ComputerComponent.create("computercraft", "metrics");
    private final UUID instanceUUID = UUID.randomUUID();
    private class_3218 level;
    private class_2338 position;
    private final ComputerFamily family;
    private final MetricsObserver metrics;
    private final Computer computer;
    private final NetworkedTerminal terminal;
    private final AtomicBoolean terminalChanged = new AtomicBoolean(false);
    private final long storageCapacity;
    private int ticksSincePing;

    public ServerComputer(class_3218 level, class_2338 position, Properties properties) {
        this.level = level;
        this.position = position;
        this.family = properties.family;
        ServerContext context = ServerContext.get(level.method_8503());
        this.terminal = new NetworkedTerminal(properties.terminalWidth, properties.terminalHeight, this.family != ComputerFamily.NORMAL, this::markTerminalChanged);
        this.metrics = context.metrics().createMetricObserver(this);
        this.storageCapacity = properties.storageCapacity;
        properties.addComponent(METRICS, this.metrics);
        if (this.family == ComputerFamily.COMMAND) {
            properties.addComponent(ComputerComponents.ADMIN_COMPUTER, new AdminComputer(this){});
        }
        Map<ComputerComponent<?>, Object> components = Map.copyOf(properties.components);
        this.computer = new Computer(context.computerContext(), this, this.terminal, properties.computerID);
        this.computer.setLabel(properties.label);
        for (ILuaAPIFactory factory : ApiFactories.getAll()) {
            ComputerSystem system;
            ILuaAPI api = factory.create(system = new ComputerSystem(this, this.computer.getAPIEnvironment(), components));
            if (api == null) continue;
            system.activate();
            this.computer.addApi(api, system);
        }
    }

    public final ComputerFamily getFamily() {
        return this.family;
    }

    public final class_3218 getLevel() {
        return this.level;
    }

    public final class_2338 getPosition() {
        return this.position;
    }

    public final void setPosition(class_3218 level, class_2338 pos) {
        this.level = level;
        this.position = pos.method_10062();
    }

    protected final void markTerminalChanged() {
        this.terminalChanged.set(true);
    }

    protected void tickServer() {
        ++this.ticksSincePing;
        this.computer.tick();
        if (this.terminalChanged.getAndSet(false)) {
            this.onTerminalChanged();
        }
    }

    protected void onTerminalChanged() {
        this.sendToAllInteracting(c -> new ComputerTerminalClientMessage((class_1703)c, this.getTerminalState()));
    }

    public final TerminalState getTerminalState() {
        return TerminalState.create(this.terminal);
    }

    public final void keepAlive() {
        this.ticksSincePing = 0;
    }

    boolean hasTimedOut() {
        return this.ticksSincePing > 100;
    }

    public final int pollRedstoneChanges() {
        return this.computer.pollRedstoneChanges();
    }

    public UUID register() {
        ServerContext.get(this.level.method_8503()).registry().add(this);
        return this.instanceUUID;
    }

    void unload() {
        this.computer.unload();
    }

    public final void close() {
        this.unload();
        ServerContext.get(this.level.method_8503()).registry().remove(this);
    }

    public final boolean checkUsable(class_1657 player) {
        return ServerContext.get(this.level.method_8503()).registry().get(this.instanceUUID) == this && this.getFamily().checkUsable(player);
    }

    private void sendToAllInteracting(Function<class_1703, NetworkMessage<ClientNetworkContext>> createPacket) {
        MinecraftServer server = this.level.method_8503();
        for (class_3222 player : server.method_3760().method_14571()) {
            ComputerMenu menu;
            class_1703 class_17032 = player.field_7512;
            if (!(class_17032 instanceof ComputerMenu) || (menu = (ComputerMenu)class_17032).getComputer() != this) continue;
            ServerNetworking.sendToPlayer(createPacket.apply(player.field_7512), player);
        }
    }

    protected void onRemoved() {
    }

    public final UUID getInstanceUUID() {
        return this.instanceUUID;
    }

    public final int getID() {
        return this.computer.getID();
    }

    public final @Nullable String getLabel() {
        return this.computer.getLabel();
    }

    public final boolean isOn() {
        return this.computer.isOn();
    }

    public final ComputerState getState() {
        if (!this.computer.isOn()) {
            return ComputerState.OFF;
        }
        return this.computer.isBlinking() ? ComputerState.BLINKING : ComputerState.ON;
    }

    public final void turnOn() {
        this.computer.turnOn();
    }

    public final void shutdown() {
        this.computer.shutdown();
    }

    public final void reboot() {
        this.computer.reboot();
    }

    @Override
    public final void queueEvent(String event, @Nullable Object @Nullable [] arguments) {
        this.computer.queueEvent(event, arguments);
    }

    public final void queueEvent(String event) {
        this.queueEvent(event, null);
    }

    public final int getRedstoneOutput(ComputerSide side) {
        return this.computer.isOn() ? this.computer.getRedstone().getExternalOutput(side) : 0;
    }

    public final void setRedstoneInput(ComputerSide side, int level, int bundledState) {
        this.computer.getRedstone().setInput(side, level, bundledState);
    }

    public final int getBundledRedstoneOutput(ComputerSide side) {
        return this.computer.isOn() ? this.computer.getRedstone().getExternalBundledOutput(side) : 0;
    }

    public final void setPeripheral(ComputerSide side, @Nullable IPeripheral peripheral) {
        this.computer.getEnvironment().setPeripheral(side, peripheral);
    }

    public final @Nullable IPeripheral getPeripheral(ComputerSide side) {
        return this.computer.getEnvironment().getPeripheral(side);
    }

    public final void setLabel(@Nullable String label) {
        this.computer.setLabel(label);
    }

    @Override
    public final double getTimeOfDay() {
        return (double)((this.level.method_8532() + 6000L) % 24000L) / 1000.0;
    }

    @Override
    public final int getDay() {
        return (int)((this.level.method_8532() + 6000L) / 24000L) + 1;
    }

    @Override
    public final MetricsObserver getMetrics() {
        return this.metrics;
    }

    public final WorkMonitor getMainThreadMonitor() {
        return this.computer.getMainThreadMonitor();
    }

    @Override
    public final WritableMount createRootMount() {
        long capacity = this.storageCapacity <= 0L ? (long)((Integer)ConfigSpec.computerSpaceLimit.get()).intValue() : this.storageCapacity;
        return ComputerCraftAPI.createSaveDirMount(this.level.method_8503(), this.family.getSaveFolder() + "/" + this.computer.getID(), capacity);
    }

    public static Properties properties(int computerID, ComputerFamily family) {
        return new Properties(computerID, family);
    }

    public static final class Properties {
        private final int computerID;
        private @Nullable String label;
        private final ComputerFamily family;
        private int terminalWidth = 51;
        private int terminalHeight = 19;
        private long storageCapacity = -1L;
        private final Map<ComputerComponent<?>, Object> components = new HashMap();

        private Properties(int computerID, ComputerFamily family) {
            this.computerID = computerID;
            this.family = family;
        }

        public Properties label(@Nullable String label) {
            this.label = label;
            return this;
        }

        public Properties terminalSize(TerminalSize size) {
            this.terminalWidth = size.width();
            this.terminalHeight = size.height();
            return this;
        }

        public Properties storageCapacity(long capacity) {
            this.storageCapacity = capacity;
            return this;
        }

        public <T> Properties addComponent(ComputerComponent<T> component, T value) {
            if (this.components.containsKey(component)) {
                throw new IllegalArgumentException(String.valueOf(component) + " is already set");
            }
            this.components.put(component, value);
            return this;
        }
    }
}

