/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import com.google.common.base.Strings;
import com.google.errorprone.annotations.OverridingMethodsMustInvokeSuper;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.impl.BundledRedstone;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.platform.ComponentAccess;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.BlockEntityHelpers;
import dan200.computercraft.shared.util.DataComponentUtil;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.NonNegativeId;
import dan200.computercraft.shared.util.RedstoneUtil;
import dan200.computercraft.shared.util.StorageCapacity;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1270;
import net.minecraft.class_1273;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9473;
import net.minecraft.server.MinecraftServer;
import org.jspecify.annotations.Nullable;

public abstract class AbstractComputerBlockEntity
extends class_2586
implements class_1275,
class_1270 {
    private static final String NBT_ID = "ComputerId";
    protected static final String NBT_LABEL = "Label";
    private static final String NBT_ON = "On";
    private static final String NBT_CAPACITY = "Capacity";
    private @Nullable UUID instanceID = null;
    private int computerID = -1;
    protected @Nullable String label = null;
    protected long storageCapacity = -1L;
    private boolean on = false;
    boolean startOn = false;
    private boolean fresh = false;
    private int invalidSides = 0;
    private final ComponentAccess<IPeripheral> peripherals = PlatformHelper.get().createPeripheralAccess(this, d -> this.invalidSides |= 1 << d.ordinal());
    private class_1273 lockCode = class_1273.field_5817;
    private final ComputerFamily family;

    public AbstractComputerBlockEntity(class_2591<? extends AbstractComputerBlockEntity> type, class_2338 pos, class_2680 state, ComputerFamily family) {
        super(type, pos, state);
        this.family = family;
    }

    protected void unload() {
        if (this.method_10997().field_9236) {
            return;
        }
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            computer.close();
        }
        this.instanceID = null;
    }

    public void method_11012() {
        super.method_11012();
        this.unload();
    }

    protected float getInteractRange() {
        return 4.0f;
    }

    public boolean isUsable(class_1657 player) {
        return this.getFamily().checkUsable(player) && class_2624.method_17487((class_1657)player, (class_1273)this.lockCode, (class_2561)this.method_5476()) && class_1263.method_49106((class_2586)this, (class_1657)player, (float)this.getInteractRange());
    }

    protected void serverTick() {
        String newLabel;
        if (this.method_10997().field_9236) {
            return;
        }
        if (this.computerID < 0 && !this.startOn) {
            return;
        }
        ServerComputer computer = this.createServerComputer();
        if (this.invalidSides != 0) {
            for (class_2350 direction : DirectionUtil.FACINGS) {
                if (!DirectionUtil.isSet(this.invalidSides, direction)) continue;
                this.refreshPeripheral(computer, direction);
            }
        }
        if (this.startOn || this.fresh && this.on) {
            computer.turnOn();
            this.startOn = false;
        }
        computer.keepAlive();
        this.fresh = false;
        this.computerID = computer.getID();
        boolean newOn = computer.isOn();
        if (this.on != newOn) {
            this.on = newOn;
            this.method_5431();
        }
        if (!Objects.equals(this.label, newLabel = computer.getLabel())) {
            this.label = newLabel;
            BlockEntityHelpers.updateBlock(this);
        }
        this.updateBlockState(computer.getState());
        int changes = computer.pollRedstoneChanges();
        if (changes != 0) {
            for (class_2350 direction : DirectionUtil.FACINGS) {
                if ((changes & 1 << this.remapToLocalSide(direction).ordinal()) == 0) continue;
                this.updateRedstoneTo(direction);
            }
        }
    }

    protected abstract void updateBlockState(ComputerState var1);

    public void method_11007(class_11372 nbt) {
        if (this.computerID >= 0) {
            nbt.method_71465(NBT_ID, this.computerID);
        }
        if (this.label != null) {
            nbt.method_71469(NBT_LABEL, this.label);
        }
        if (this.storageCapacity > 0L) {
            nbt.method_71466(NBT_CAPACITY, this.storageCapacity);
        }
        nbt.method_71472(NBT_ON, this.on);
        this.lockCode.method_5474(nbt);
        super.method_11007(nbt);
    }

    public final void method_11014(class_11368 nbt) {
        super.method_11014(nbt);
        if (this.field_11863 != null && this.field_11863.field_9236) {
            this.loadClient(nbt);
        } else {
            this.loadServer(nbt);
        }
    }

    protected void loadServer(class_11368 nbt) {
        this.computerID = nbt.method_71424(NBT_ID, -1);
        this.label = nbt.method_71428(NBT_LABEL, null);
        this.storageCapacity = nbt.method_71425(NBT_CAPACITY, -1L);
        this.on = this.startOn = nbt.method_71433(NBT_ON, false);
        this.lockCode = class_1273.method_5473((class_11368)nbt);
    }

    protected void method_57568(class_9473 component) {
        super.method_57568(component);
        this.label = DataComponentUtil.getCustomName((class_2561)component.method_58694(class_9334.field_49631));
        this.computerID = NonNegativeId.getId((NonNegativeId)component.method_58694((class_9331)ModRegistry.DataComponents.COMPUTER_ID.get()));
        this.storageCapacity = StorageCapacity.getOrDefault((StorageCapacity)component.method_58694((class_9331)ModRegistry.DataComponents.STORAGE_CAPACITY.get()), -1L);
        this.lockCode = (class_1273)component.method_58695(class_9334.field_49625, (Object)class_1273.field_5817);
    }

    protected void method_57567(class_9323.class_9324 builder) {
        super.method_57567(builder);
        this.collectSafeComponents(builder);
        if (this.lockCode != class_1273.field_5817) {
            builder.method_57840(class_9334.field_49625, (Object)this.lockCode);
        }
    }

    @OverridingMethodsMustInvokeSuper
    protected void collectSafeComponents(class_9323.class_9324 builder) {
        builder.method_57840((class_9331)ModRegistry.DataComponents.COMPUTER_ID.get(), (Object)(this.computerID < 0 ? null : new NonNegativeId.Computer(this.computerID)));
        builder.method_57840(class_9334.field_49631, this.label == null ? null : class_2561.method_43470((String)this.label));
        builder.method_57840((class_9331)ModRegistry.DataComponents.STORAGE_CAPACITY.get(), (Object)(this.storageCapacity > 0L ? new StorageCapacity(this.storageCapacity) : null));
    }

    @Deprecated
    public void method_57569(class_11372 tag) {
        super.method_57569(tag);
        tag.method_71478(NBT_ID);
        tag.method_71478(NBT_LABEL);
        tag.method_71478(NBT_CAPACITY);
        tag.method_71478("lock");
    }

    protected boolean isPeripheralBlockedOnSide(ComputerSide localSide) {
        return false;
    }

    protected abstract class_2350 getDirection();

    protected ComputerSide remapToLocalSide(class_2350 globalSide) {
        return this.remapLocalSide(DirectionUtil.toLocal(this.getDirection(), globalSide));
    }

    protected ComputerSide remapLocalSide(ComputerSide localSide) {
        return localSide;
    }

    private void updateRedstoneInput(ServerComputer computer, class_2350 dir, class_2338 targetPos) {
        class_2350 offsetSide = dir.method_10153();
        ComputerSide localDir = this.remapToLocalSide(dir);
        computer.setRedstoneInput(localDir, RedstoneUtil.getRedstoneInput(this.method_10997(), targetPos, dir), BundledRedstone.getOutput(this.method_10997(), targetPos, offsetSide));
    }

    private void refreshPeripheral(ServerComputer computer, class_2350 dir) {
        this.invalidSides &= ~(1 << dir.ordinal());
        ComputerSide localDir = this.remapToLocalSide(dir);
        if (this.isPeripheralBlockedOnSide(localDir)) {
            return;
        }
        IPeripheral peripheral = this.peripherals.get(dir);
        computer.setPeripheral(localDir, peripheral);
    }

    public void updateInputsImmediately() {
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            this.updateInputsImmediately(computer);
        }
    }

    private void updateInputsImmediately(ServerComputer computer) {
        class_2338 pos = this.method_11016();
        for (class_2350 dir : DirectionUtil.FACINGS) {
            this.updateRedstoneInput(computer, dir, pos.method_10093(dir));
            this.refreshPeripheral(computer, dir);
        }
    }

    public void neighborChanged() {
        ServerComputer computer = this.getServerComputer();
        if (computer == null) {
            return;
        }
        for (class_2350 dir : DirectionUtil.FACINGS) {
            this.updateRedstoneInput(computer, dir, this.method_11016().method_10093(dir));
        }
        this.invalidSides = 63;
    }

    public void neighbourShapeChanged(class_2350 direction) {
        this.invalidSides |= 1 << direction.ordinal();
    }

    protected void updateRedstoneTo(class_2350 direction) {
        RedstoneUtil.propagateRedstoneOutput(this.method_10997(), this.method_11016(), direction);
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            this.updateRedstoneInput(computer, direction, this.method_11016().method_10093(direction));
        }
    }

    public void updateRedstone() {
        for (class_2350 dir : DirectionUtil.FACINGS) {
            this.updateRedstoneTo(dir);
        }
    }

    public final int getComputerID() {
        return this.computerID;
    }

    public final @Nullable String getLabel() {
        return this.label;
    }

    public final void setComputerID(int id) {
        if (this.method_10997().field_9236 || this.computerID == id) {
            return;
        }
        this.computerID = id;
        BlockEntityHelpers.updateBlock(this);
    }

    public final void setLabel(@Nullable String label) {
        if (this.method_10997().field_9236 || Objects.equals(this.label, label)) {
            return;
        }
        this.label = label;
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            computer.setLabel(label);
        }
        BlockEntityHelpers.updateBlock(this);
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    public final ServerComputer createServerComputer() {
        MinecraftServer server = this.method_10997().method_8503();
        if (server == null) {
            throw new IllegalStateException("Cannot access server computer on the client.");
        }
        boolean changed = false;
        ServerComputer computer = ServerContext.get(server).registry().get(this.instanceID);
        if (computer == null) {
            if (this.computerID < 0) {
                this.computerID = ComputerCraftAPI.createUniqueNumberedSaveDir(server, "computer");
                BlockEntityHelpers.updateBlock(this);
            }
            computer = this.createComputer(this.computerID);
            this.instanceID = computer.register();
            this.fresh = true;
            changed = true;
        }
        if (changed) {
            this.updateInputsImmediately(computer);
        }
        return computer;
    }

    protected abstract ServerComputer createComputer(int var1);

    public @Nullable ServerComputer getServerComputer() {
        return this.method_10997().field_9236 || this.method_10997().method_8503() == null ? null : ServerContext.get(this.method_10997().method_8503()).registry().get(this.instanceID);
    }

    protected void loadClient(class_11368 tag) {
    }

    protected void transferStateFrom(AbstractComputerBlockEntity copy) {
        if (copy.computerID != this.computerID || !Objects.equals(copy.instanceID, this.instanceID)) {
            this.unload();
            this.instanceID = copy.instanceID;
            this.computerID = copy.computerID;
            this.label = copy.label;
            this.storageCapacity = copy.storageCapacity;
            this.on = copy.on;
            this.startOn = copy.startOn;
            this.lockCode = copy.lockCode;
            BlockEntityHelpers.updateBlock(this);
        }
        copy.instanceID = null;
    }

    public class_2561 method_5477() {
        return this.method_16914() ? class_2561.method_43470((String)this.label) : class_2561.method_43471((String)this.method_11010().method_26204().method_63499());
    }

    public boolean method_16914() {
        return !Strings.isNullOrEmpty((String)this.label);
    }

    public @Nullable class_2561 method_5797() {
        return this.method_16914() ? class_2561.method_43470((String)this.label) : null;
    }

    public class_2561 method_5476() {
        return super.method_5476();
    }
}

