/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import com.mojang.brigadier.CommandDispatcher;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.detail.FabricDetailRegistries;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.media.MediaLookup;
import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.network.wired.WiredElementLookup;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.PeripheralLookup;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.impl.Peripherals;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.impl.TurtleUpgrades;
import dan200.computercraft.shared.CommonHooks;
import dan200.computercraft.shared.FabricCommonHooks;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.command.CommandComputerCraft;
import dan200.computercraft.shared.config.ConfigSpec;
import dan200.computercraft.shared.details.FluidDetails;
import dan200.computercraft.shared.integration.CreateIntegration;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.server.ServerNetworkContext;
import dan200.computercraft.shared.peripheral.generic.methods.InventoryMethods;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlock;
import dan200.computercraft.shared.platform.FabricConfigFile;
import dan200.computercraft.shared.platform.RegistryEntry;
import dan200.computercraft.shared.recipe.function.RecipeFunction;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.PlayerPickItemEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.item.v1.ComponentTooltipAppenderRegistry;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.lookup.v1.item.ItemApiLookup;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3194;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_4538;
import net.minecraft.class_52;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_7923;
import net.minecraft.class_8563;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jspecify.annotations.Nullable;

public class ComputerCraft {
    private static final class_5218 SERVERCONFIG = new class_5218("serverconfig");
    public static final String CLIENT_OPEN_FOLDER = "computercraft-open-folder";

    public static void init() {
        for (class_8710.class_9155<class_9129, ? extends NetworkMessage<ServerNetworkContext>> class_91552 : NetworkMessages.getServerbound()) {
            ComputerCraft.registerPayloadType(PayloadTypeRegistry.playC2S(), class_91552);
        }
        for (class_8710.class_9155 class_91553 : NetworkMessages.getClientbound()) {
            ComputerCraft.registerPayloadType(PayloadTypeRegistry.playS2C(), class_91553);
        }
        for (class_8710.class_9155 class_91554 : NetworkMessages.getServerbound()) {
            ServerPlayNetworking.registerGlobalReceiver((class_8710.class_9154)class_91554.comp_2243(), (packet, player) -> packet.handle(() -> ((ServerPlayNetworking.Context)player).player()));
        }
        FabricRegistryBuilder.createSimple(RecipeFunction.REGISTRY).attribute(RegistryAttribute.SYNCED).buildAndRegister();
        DynamicRegistries.registerSynced(ITurtleUpgrade.REGISTRY, TurtleUpgrades.instance().upgradeCodec(), (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
        DynamicRegistries.registerSynced(IPocketUpgrade.REGISTRY, PocketUpgrades.instance().upgradeCodec(), (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
        ModRegistry.register();
        ModRegistry.registerMainThread();
        ModRegistry.registerPeripherals(new BlockComponentImpl<IPeripheral, class_2350>(PeripheralLookup.get()));
        ModRegistry.registerWiredElements(new BlockComponentImpl<WiredElement, class_2350>(WiredElementLookup.get()));
        ModRegistry.registerMedia(new ItemComponentImpl<IMedia>(MediaLookup.get()));
        CommandRegistrationCallback.EVENT.register((dispatcher, context, environment) -> CommandComputerCraft.register((CommandDispatcher<class_2168>)dispatcher));
        for (RegistryEntry registryEntry : ModRegistry.DataComponents.TOOLTIP_COMPONENTS) {
            ComponentTooltipAppenderRegistry.addAfter((class_9331)class_9334.field_49632, (class_9331)((class_9331)registryEntry.get()));
        }
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            ((FabricConfigFile)ConfigSpec.serverSpec).load(server.method_27050(SERVERCONFIG).resolve("computercraft-server.toml"), FabricLoader.getInstance().getConfigDir().resolve("computercraft-server.toml"));
            CommonHooks.onServerStarting(server);
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(s -> {
            CommonHooks.onServerStopped();
            ((FabricConfigFile)ConfigSpec.serverSpec).unload();
        });
        ServerLifecycleEvents.SERVER_STARTED.register(CommonHooks::onServerStarted);
        ServerTickEvents.START_SERVER_TICK.register(CommonHooks::onServerTickStart);
        ServerTickEvents.START_SERVER_TICK.register(s -> CommonHooks.onServerTickEnd());
        ServerChunkEvents.CHUNK_UNLOAD.register((l, c) -> CommonHooks.onServerChunkUnload(c));
        ServerChunkEvents.CHUNK_LEVEL_TYPE_CHANGE.register((level, chunk, oldStatus, newStatus) -> CommonHooks.onChunkTicketLevelChanged(level, chunk.method_12004().method_8324(), class_8563.method_51828((class_3194)oldStatus), class_8563.method_51828((class_3194)newStatus)));
        PlayerBlockBreakEvents.BEFORE.register(FabricCommonHooks::onBlockDestroy);
        UseBlockCallback.EVENT.register(CommonHooks::onUseBlock);
        PlayerPickItemEvents.BLOCK.register((player, pos, state, includeData) -> {
            class_1799 class_17992;
            class_2248 patt0$temp = state.method_26204();
            if (patt0$temp instanceof CableBlock) {
                CableBlock cable = (CableBlock)patt0$temp;
                class_17992 = cable.getCloneItemStack((class_4538)player.method_51469(), pos, state, includeData, (class_1657)player);
            } else {
                class_17992 = null;
            }
            return class_17992;
        });
        LootTableEvents.MODIFY.register((id, tableBuilder, source, registries) -> {
            class_55.class_56 pool = CommonHooks.getExtraLootPool((class_5321<class_52>)id);
            if (pool != null) {
                tableBuilder.method_336(pool);
            }
        });
        ItemGroupEvents.MODIFY_ENTRIES_ALL.register((tab, entries) -> CommonHooks.onBuildCreativeTab((class_5321<class_1761>)((class_5321)class_7923.field_44687.method_29113((Object)tab).orElseThrow()), entries.getContext(), (class_1761.class_7704)entries));
        CommonHooks.onDatapackReload((name, listener) -> ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new ReloadListener((class_2960)name, (class_3302)listener)));
        FabricDetailRegistries.FLUID_VARIANT.addProvider(FluidDetails::fill);
        ComputerCraftAPI.registerGenericSource(new InventoryMethods());
        Peripherals.addGenericLookup(InventoryMethods::extractContainer);
    }

    private static <B extends class_2540, T extends class_8710> void registerPayloadType(PayloadTypeRegistry<B> registry, class_8710.class_9155<B, T> type) {
        registry.register(type.comp_2243(), type.comp_2244());
        if (FabricLoader.getInstance().isModLoaded("create")) {
            CreateIntegration.setup();
        }
    }

    private record BlockComponentImpl<T, C>(BlockApiLookup<T, C> lookup) implements ModRegistry.BlockComponent<T, C>
    {
        @Override
        public <B extends class_2586> void registerForBlockEntity(class_2591<B> blockEntityType, BiFunction<? super B, C, @Nullable T> provider) {
            this.lookup.registerForBlockEntity(provider, blockEntityType);
        }
    }

    private record ItemComponentImpl<T>(ItemApiLookup<T, @Nullable Void> lookup) implements ModRegistry.ItemComponent<T>
    {
        @Override
        public void registerForItems(BiFunction<class_1799, @Nullable Void, @Nullable T> provider, class_1935 ... items) {
            this.lookup().registerForItems(provider::apply, items);
        }

        @Override
        public void registerFallback(BiFunction<class_1799, @Nullable Void, @Nullable T> provider) {
            this.lookup().registerFallback(provider::apply);
        }
    }

    private record ReloadListener(class_2960 name, class_3302 listener) implements IdentifiableResourceReloadListener
    {
        public class_2960 getFabricId() {
            return this.name;
        }

        public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, Executor backgroundExecutor, Executor gameExecutor) {
            return this.listener.method_25931(preparationBarrier, resourceManager, backgroundExecutor, gameExecutor);
        }
    }
}

