/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.terminal;

import dan200.computercraft.core.util.Colour;

public class Palette {
    public static final int PALETTE_SIZE = 16;
    private final boolean colour;
    private final double[][] colours = new double[16][3];
    private final int[] byteColours = new int[16];
    public static final Palette DEFAULT = new Palette(true);

    public Palette(boolean colour) {
        this.colour = colour;
        this.resetColours();
    }

    public void setColour(int i, double r, double g, double b) {
        if (i < 0 || i >= 16) {
            return;
        }
        this.colours[i][0] = r;
        this.colours[i][1] = g;
        this.colours[i][2] = b;
        if (this.colour) {
            this.byteColours[i] = Palette.packColour((int)(r * 255.0), (int)(g * 255.0), (int)(b * 255.0));
        } else {
            int grey = (int)((r + g + b) / 3.0 * 255.0);
            this.byteColours[i] = Palette.packColour(grey, grey, grey);
        }
    }

    private static int packColour(int r, int g, int b) {
        return 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public void setColour(int i, Colour colour) {
        this.setColour(i, colour.getR(), colour.getG(), colour.getB());
    }

    public double[] getColour(int i) {
        return this.colours[i];
    }

    public int getRenderColours(int i) {
        return this.byteColours[i];
    }

    public void resetColours() {
        for (int i = 0; i < Colour.VALUES.length; ++i) {
            this.setColour(i, Colour.VALUES[i]);
        }
    }

    public static int encodeRGB8(double[] rgb) {
        int r = (int)(rgb[0] * 255.0) & 0xFF;
        int g = (int)(rgb[1] * 255.0) & 0xFF;
        int b = (int)(rgb[2] * 255.0) & 0xFF;
        return r << 16 | g << 8 | b;
    }

    public static double[] decodeRGB8(int rgb) {
        return new double[]{(float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb & 0xFF) / 255.0f};
    }
}

