/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render.text;

import dan200.computercraft.client.FrameInfo;
import dan200.computercraft.core.terminal.Palette;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.core.util.Colour;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_9848;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public final class FixedWidthFontRenderer {
    public static final class_2960 FONT = class_2960.method_60655((String)"computercraft", (String)"textures/gui/term_font.png");
    public static final class_1921 TERMINAL_TEXT = class_1921.method_23028((class_2960)FONT);
    public static final class_1921 TERMINAL_TEXT_OFFSET = class_1921.method_37345((class_2960)FONT);
    public static final int FONT_HEIGHT = 9;
    public static final int FONT_WIDTH = 6;
    static final float WIDTH = 256.0f;
    static final float BACKGROUND_START = 0.9765625f;
    static final float BACKGROUND_END = 0.984375f;
    private static final int BLACK = class_9848.method_61324((int)255, (int)FixedWidthFontRenderer.byteColour(Colour.BLACK.getR()), (int)FixedWidthFontRenderer.byteColour(Colour.BLACK.getR()), (int)FixedWidthFontRenderer.byteColour(Colour.BLACK.getR()));
    private static final float Z_OFFSET = 1.0E-4f;

    private FixedWidthFontRenderer() {
    }

    private static byte byteColour(float c) {
        return (byte)(c * 255.0f);
    }

    public static float toGreyscale(double[] rgb) {
        return (float)((rgb[0] + rgb[1] + rgb[2]) / 3.0);
    }

    public static int getColour(char c, Colour def) {
        return 15 - Terminal.getColour(c, def);
    }

    private static void drawChar(QuadEmitter emitter, float x, float y, int index, int colour, int light) {
        if (index == 0 || index == 32) {
            return;
        }
        int column = index % 16;
        int row = index / 16;
        int xStart = 1 + column * 8;
        int yStart = 1 + row * 11;
        FixedWidthFontRenderer.quad(emitter, x, y, x + 6.0f, y + 9.0f, 0.0f, colour, (float)xStart / 256.0f, (float)yStart / 256.0f, (float)(xStart + 6) / 256.0f, (float)(yStart + 9) / 256.0f, light);
    }

    public static void drawQuad(QuadEmitter emitter, float x, float y, float z, float width, float height, int colour, int light) {
        FixedWidthFontRenderer.quad(emitter, x, y, x + width, y + height, z, colour, 0.9765625f, 0.9765625f, 0.984375f, 0.984375f, light);
    }

    private static void drawQuad(QuadEmitter emitter, float x, float y, float width, float height, Palette palette, char colourIndex, int light) {
        int colour = palette.getRenderColours(FixedWidthFontRenderer.getColour(colourIndex, Colour.BLACK));
        FixedWidthFontRenderer.drawQuad(emitter, x, y, 0.0f, width, height, colour, light);
    }

    private static void drawBackground(QuadEmitter emitter, float x, float y, TextBuffer backgroundColour, Palette palette, float leftMarginSize, float rightMarginSize, float height, int light) {
        if (leftMarginSize > 0.0f) {
            FixedWidthFontRenderer.drawQuad(emitter, x - leftMarginSize, y, leftMarginSize, height, palette, backgroundColour.charAt(0), light);
        }
        if (rightMarginSize > 0.0f) {
            FixedWidthFontRenderer.drawQuad(emitter, x + (float)(backgroundColour.length() * 6), y, rightMarginSize, height, palette, backgroundColour.charAt(backgroundColour.length() - 1), light);
        }
        int blockStart = 0;
        char blockColour = '\u0000';
        for (int i = 0; i < backgroundColour.length(); ++i) {
            char colourIndex = backgroundColour.charAt(i);
            if (colourIndex == blockColour) continue;
            if (blockColour != '\u0000') {
                FixedWidthFontRenderer.drawQuad(emitter, x + (float)(blockStart * 6), y, (float)(6 * (i - blockStart)), height, palette, blockColour, light);
            }
            blockColour = colourIndex;
            blockStart = i;
        }
        if (blockColour != '\u0000') {
            FixedWidthFontRenderer.drawQuad(emitter, x + (float)(blockStart * 6), y, (float)(6 * (backgroundColour.length() - blockStart)), height, palette, blockColour, light);
        }
    }

    public static void drawString(QuadEmitter emitter, float x, float y, TextBuffer text, TextBuffer textColour, Palette palette, int light) {
        for (int i = 0; i < text.length(); ++i) {
            int colour = palette.getRenderColours(FixedWidthFontRenderer.getColour(textColour.charAt(i), Colour.BLACK));
            int index = text.charAt(i);
            if (index > 255) {
                index = 63;
            }
            FixedWidthFontRenderer.drawChar(emitter, x + (float)(i * 6), y, index, colour, light);
        }
    }

    public static void drawTerminalForeground(QuadEmitter emitter, float x, float y, Terminal terminal) {
        Palette palette = terminal.getPalette();
        int height = terminal.getHeight();
        for (int i = 0; i < height; ++i) {
            float rowY = y + (float)(9 * i);
            FixedWidthFontRenderer.drawString(emitter, x, rowY, terminal.getLine(i), terminal.getTextColourLine(i), palette, 0xF000F0);
        }
    }

    public static void drawTerminalBackground(QuadEmitter emitter, float x, float y, Terminal terminal, float topMarginSize, float bottomMarginSize, float leftMarginSize, float rightMarginSize) {
        Palette palette = terminal.getPalette();
        int height = terminal.getHeight();
        FixedWidthFontRenderer.drawBackground(emitter, x, y - topMarginSize, terminal.getBackgroundColourLine(0), palette, leftMarginSize, rightMarginSize, topMarginSize, 0xF000F0);
        FixedWidthFontRenderer.drawBackground(emitter, x, y + (float)(height * 9), terminal.getBackgroundColourLine(height - 1), palette, leftMarginSize, rightMarginSize, bottomMarginSize, 0xF000F0);
        for (int i = 0; i < height; ++i) {
            float rowY = y + (float)(9 * i);
            FixedWidthFontRenderer.drawBackground(emitter, x, rowY, terminal.getBackgroundColourLine(i), palette, leftMarginSize, rightMarginSize, 9.0f, 0xF000F0);
        }
    }

    public static boolean isCursorVisible(Terminal terminal) {
        if (!terminal.getCursorBlink()) {
            return false;
        }
        int cursorX = terminal.getCursorX();
        int cursorY = terminal.getCursorY();
        return cursorX >= 0 && cursorX < terminal.getWidth() && cursorY >= 0 && cursorY < terminal.getHeight();
    }

    public static void drawCursor(QuadEmitter emitter, float x, float y, Terminal terminal) {
        if (FixedWidthFontRenderer.isCursorVisible(terminal) && FrameInfo.getGlobalCursorBlink()) {
            int colour = terminal.getPalette().getRenderColours(15 - terminal.getTextColour());
            FixedWidthFontRenderer.drawChar(emitter, x + (float)(terminal.getCursorX() * 6), y + (float)(terminal.getCursorY() * 9), 95, colour, 0xF000F0);
        }
    }

    public static void drawTerminal(QuadEmitter emitter, float x, float y, Terminal terminal, float topMarginSize, float bottomMarginSize, float leftMarginSize, float rightMarginSize) {
        FixedWidthFontRenderer.drawTerminalBackground(emitter, x, y, terminal, topMarginSize, bottomMarginSize, leftMarginSize, rightMarginSize);
        Matrix4f transformBackup = new Matrix4f((Matrix4fc)emitter.poseMatrix());
        emitter.poseMatrix().translate((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0E-4f));
        FixedWidthFontRenderer.drawTerminalForeground(emitter, x, y, terminal);
        FixedWidthFontRenderer.drawCursor(emitter, x, y, terminal);
        emitter.poseMatrix().set((Matrix4fc)transformBackup);
    }

    public static void drawEmptyTerminal(QuadEmitter emitter, float x, float y, float width, float height) {
        FixedWidthFontRenderer.drawQuad(emitter, x, y, 0.0f, width, height, BLACK, 0xF000F0);
    }

    public static QuadEmitter toVertexConsumer(class_4587 transform, class_4588 consumer) {
        return new QuadEmitter(transform.method_23760().method_23761(), consumer);
    }

    private static void quad(QuadEmitter c, float x1, float y1, float x2, float y2, float z, int colour, float u1, float v1, float u2, float v2, int light) {
        Matrix4f poseMatrix = c.poseMatrix();
        class_4588 consumer = c.consumer();
        consumer.method_22918(poseMatrix, x1, y1, z).method_39415(colour).method_22913(u1, v1).method_60803(light);
        consumer.method_22918(poseMatrix, x1, y2, z).method_39415(colour).method_22913(u1, v2).method_60803(light);
        consumer.method_22918(poseMatrix, x2, y2, z).method_39415(colour).method_22913(u2, v2).method_60803(light);
        consumer.method_22918(poseMatrix, x2, y1, z).method_39415(colour).method_22913(u2, v1).method_60803(light);
    }

    @Environment(value=EnvType.CLIENT)
    public record QuadEmitter(Matrix4f poseMatrix, class_4588 consumer) {
    }
}

