/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render.monitor;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.mojang.blaze3d.buffers.GpuBuffer;
import dan200.computercraft.shared.peripheral.monitor.ClientMonitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import org.jspecify.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class MonitorRenderState
implements ClientMonitor.RenderState {
    @GuardedBy(value="allMonitors")
    private static final Set<MonitorRenderState> allMonitors = new HashSet<MonitorRenderState>();
    long lastRenderFrame = -1L;
    @Nullable class_2338 lastRenderPos = null;
    @Nullable GpuBuffer vertexBuffer;
    int vertexCountAfterBackground;
    int vertexCountAfterForeground;
    int vertexCountAfterCursor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register() {
        if (this.vertexBuffer != null) {
            return;
        }
        Set<MonitorRenderState> set = allMonitors;
        synchronized (set) {
            allMonitors.add(this);
        }
    }

    private void deleteBuffers() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.vertexBuffer != null) {
            Set<MonitorRenderState> set = allMonitors;
            synchronized (set) {
                allMonitors.remove(this);
            }
            this.deleteBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyAll() {
        Set<MonitorRenderState> set = allMonitors;
        synchronized (set) {
            Iterator<MonitorRenderState> iterator = allMonitors.iterator();
            while (iterator.hasNext()) {
                MonitorRenderState monitor = iterator.next();
                monitor.deleteBuffers();
                iterator.remove();
            }
        }
    }
}

