/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.client.ClientRegistry;
import dan200.computercraft.client.turtle.TurtleOverlay;
import dan200.computercraft.client.turtle.TurtleOverlayManager;
import dan200.computercraft.client.turtle.TurtleUpgradeModelManager;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import dan200.computercraft.shared.util.Holiday;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1092;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_824;
import net.minecraft.class_827;
import net.minecraft.class_9848;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.jspecify.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class TurtleBlockEntityRenderer
implements class_827<TurtleBlockEntity> {
    public static final class_2960 NORMAL_TURTLE_MODEL = class_2960.method_60655((String)"computercraft", (String)"block/turtle_normal");
    public static final class_2960 ADVANCED_TURTLE_MODEL = class_2960.method_60655((String)"computercraft", (String)"block/turtle_advanced");
    public static final class_2960 COLOUR_TURTLE_MODEL = class_2960.method_60655((String)"computercraft", (String)"block/turtle_colour");
    private final class_824 renderer;
    private final class_327 font;

    public TurtleBlockEntityRenderer(class_5614.class_5615 context) {
        this.renderer = context.method_32139();
        this.font = context.method_32143();
    }

    public void render(TurtleBlockEntity turtle, float partialTicks, class_4587 transform, class_4597 buffers, int lightmapCoord, int overlayLight, class_243 camera) {
        boolean showChristmas;
        transform.method_22903();
        class_243 offset = turtle.getRenderOffset(partialTicks);
        transform.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
        String label = turtle.getLabel();
        class_239 hit = this.renderer.field_4350;
        if (label != null && hit != null && hit.method_17783() == class_239.class_240.field_1332 && turtle.method_11016().equals((Object)((class_3965)hit).method_17777())) {
            class_310 mc = class_310.method_1551();
            class_327 font = this.font;
            transform.method_22903();
            transform.method_22904(0.5, 1.2, 0.5);
            transform.method_22907((Quaternionfc)mc.method_1561().method_24197());
            transform.method_22905(0.025f, -0.025f, 0.025f);
            Matrix4f matrix = transform.method_23760().method_23761();
            int opacity = (int)(mc.field_1690.method_19343(0.25f) * 255.0f) << 24;
            float width = (float)(-font.method_1727(label)) / 2.0f;
            font.method_27521(label, width, 0.0f, 0x20FFFFFF, false, matrix, buffers, class_327.class_6415.field_33994, opacity, lightmapCoord);
            font.method_27521(label, width, 0.0f, -1, false, matrix, buffers, class_327.class_6415.field_33993, 0, lightmapCoord);
            transform.method_22909();
        }
        transform.method_46416(0.5f, 0.5f, 0.5f);
        float yaw = turtle.getRenderYaw(partialTicks);
        transform.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f - yaw));
        transform.method_46416(-0.5f, -0.5f, -0.5f);
        int colour = turtle.getColour();
        TurtleOverlay overlay = TurtleOverlayManager.get(class_310.method_1551().method_1554(), turtle.getOverlay());
        if (colour == -1) {
            this.renderModel(transform, buffers, lightmapCoord, overlayLight, turtle.getFamily() == ComputerFamily.NORMAL ? NORMAL_TURTLE_MODEL : ADVANCED_TURTLE_MODEL, null);
        } else {
            this.renderModel(transform, buffers, lightmapCoord, overlayLight, COLOUR_TURTLE_MODEL, new int[]{class_9848.method_61334((int)colour)});
        }
        if (overlay != null) {
            overlay.model().render(transform, buffers, lightmapCoord, overlayLight);
        }
        boolean bl = showChristmas = Holiday.getCurrent() == Holiday.CHRISTMAS && (overlay == null || overlay.showElfOverlay());
        if (showChristmas) {
            this.renderModel(transform, buffers, lightmapCoord, overlayLight, TurtleOverlay.ELF_MODEL, null);
        }
        this.renderUpgrade(transform, buffers, lightmapCoord, overlayLight, turtle, TurtleSide.LEFT, partialTicks);
        this.renderUpgrade(transform, buffers, lightmapCoord, overlayLight, turtle, TurtleSide.RIGHT, partialTicks);
        transform.method_22909();
    }

    private void renderUpgrade(class_4587 transform, class_4597 buffers, int lightmapCoord, int overlayLight, TurtleBlockEntity turtle, TurtleSide side, float f) {
        UpgradeData<ITurtleUpgrade> upgrade = turtle.getAccess().getUpgradeWithData(side);
        if (upgrade == null) {
            return;
        }
        transform.method_22903();
        float toolAngle = turtle.getToolRenderAngle(side, f);
        transform.method_46416(0.0f, 0.5f, 0.5f);
        transform.method_22907((Quaternionfc)class_7833.field_40713.rotationDegrees(toolAngle));
        transform.method_46416(0.0f, -0.5f, -0.5f);
        TurtleUpgradeModelManager.get(class_310.method_1551().method_1554(), upgrade.holder()).renderForLevel(upgrade, side, turtle.getAccess(), transform, buffers, lightmapCoord, overlayLight);
        transform.method_22909();
    }

    private void renderModel(class_4587 transform, class_4597 buffers, int lightmapCoord, int overlayLight, class_2960 modelLocation, int @Nullable [] tints) {
        class_1092 modelManager = class_310.method_1551().method_1554();
        ClientRegistry.getModel(modelManager, modelLocation).render(transform, buffers, lightmapCoord, overlayLight, tints);
    }
}

