/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class SpriteRenderer {
    public static final class_2960 TEXTURE = class_2960.method_60656((String)"textures/atlas/gui.png");
    private final Matrix4f transform;
    private final class_4597 buffers;
    private final int light;
    private final int z;
    private final int colour;

    public SpriteRenderer(Matrix4f transform, class_4597 buffers, int z, int light, int colour) {
        this.transform = transform;
        this.buffers = buffers;
        this.z = z;
        this.light = light;
        this.colour = colour;
    }

    public void blit(class_1058 sprite, int x0, int y0, int width, int height, int spriteX, int spriteY, int spriteWidth, int spriteHeight) {
        if (width == 0 || height == 0) {
            return;
        }
        int x1 = x0 + width;
        int y1 = y0 + height;
        float u0 = sprite.method_4580((float)spriteX / (float)spriteWidth);
        float u1 = sprite.method_4580((float)(spriteX + width) / (float)spriteWidth);
        float v0 = sprite.method_4570((float)spriteY / (float)spriteHeight);
        float v1 = sprite.method_4570((float)(spriteY + height) / (float)spriteHeight);
        class_4588 vertices = this.buffers.getBuffer(class_1921.method_23028((class_2960)sprite.method_45852()));
        vertices.method_22918(this.transform, (float)x0, (float)y1, (float)this.z).method_39415(this.colour).method_22913(u0, v1).method_60803(this.light);
        vertices.method_22918(this.transform, (float)x1, (float)y1, (float)this.z).method_39415(this.colour).method_22913(u1, v1).method_60803(this.light);
        vertices.method_22918(this.transform, (float)x1, (float)y0, (float)this.z).method_39415(this.colour).method_22913(u1, v0).method_60803(this.light);
        vertices.method_22918(this.transform, (float)x0, (float)y0, (float)this.z).method_39415(this.colour).method_22913(u0, v0).method_60803(this.light);
    }

    public void blitTiled(class_1058 sprite, int x, int y, int width, int height, int tileX, int tileY, int tileWidth, int tileHeight, int spriteWidth, int spriteHeight) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (tileWidth <= 0 || tileHeight <= 0) {
            throw new IllegalArgumentException("Tiled sprite texture size must be positive, got " + tileWidth + "x" + tileHeight);
        }
        for (int xOffset = 0; xOffset < width; xOffset += tileWidth) {
            int sliceWidth = Math.min(tileWidth, width - xOffset);
            for (int yOffset = 0; yOffset < height; yOffset += tileHeight) {
                int sliceHeight = Math.min(tileHeight, height - yOffset);
                this.blit(sprite, x + xOffset, y + yOffset, sliceWidth, sliceHeight, tileX, tileY, spriteWidth, spriteHeight);
            }
        }
    }
}

