/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import dan200.computercraft.client.gui.GuiSprites;
import dan200.computercraft.client.pocket.ClientPocketComputers;
import dan200.computercraft.client.pocket.PocketComputerData;
import dan200.computercraft.client.render.ItemMapLikeRenderer;
import dan200.computercraft.client.render.SpriteRenderer;
import dan200.computercraft.client.render.text.FixedWidthFontRenderer;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_8658;
import net.minecraft.class_8690;
import net.minecraft.class_9282;
import net.minecraft.class_9848;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public final class PocketItemRenderer
extends ItemMapLikeRenderer {
    public static final PocketItemRenderer INSTANCE = new PocketItemRenderer();
    private static final int LIGHT_HEIGHT = 8;
    private static final class_8690.class_8691 DEFAULT_BORDER = new class_8690.class_8691(36, 36, new class_8690.class_8691.class_8692(12, 12, 12, 12), false);
    private static final class_8690.class_8691 DEFAULT_BOTTOM = new class_8690.class_8691(36, 20, new class_8690.class_8691.class_8692(12, 0, 12, 0), false);

    private PocketItemRenderer() {
    }

    @Override
    protected void renderItem(class_4587 transform, class_4597 bufferSource, class_1799 stack, int light) {
        int termHeight;
        int termWidth;
        NetworkedTerminal terminal;
        PocketComputerData computer = ClientPocketComputers.get(stack);
        NetworkedTerminal networkedTerminal = terminal = computer == null ? null : computer.getTerminal();
        if (terminal == null) {
            termWidth = 26;
            termHeight = 20;
        } else {
            termWidth = terminal.getWidth();
            termHeight = terminal.getHeight();
        }
        int width = termWidth * 6 + 4;
        int height = termHeight * 9 + 4;
        transform.method_22903();
        transform.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
        transform.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(180.0f));
        transform.method_22905(0.5f, 0.5f, 0.5f);
        float scale = 0.75f / (float)Math.max(width + 24, height + 24 + 8);
        transform.method_22905(scale, scale, -1.0f);
        transform.method_22904(-0.5 * (double)width, -0.5 * (double)height, 0.0);
        PocketComputerItem item = (PocketComputerItem)stack.method_7909();
        ComputerFamily family = item.getFamily();
        int frameColour = class_9282.method_57470((class_1799)stack, (int)-1);
        Matrix4f matrix = transform.method_23760().method_23761();
        PocketItemRenderer.renderFrame(matrix, bufferSource, family, frameColour, light, width, height);
        int lightColour = computer == null || computer.getLightState() == -1 ? Colour.BLACK.getHex() : computer.getLightState();
        PocketItemRenderer.renderLight(transform, bufferSource, lightColour, width, height);
        FixedWidthFontRenderer.QuadEmitter quadEmitter = FixedWidthFontRenderer.toVertexConsumer(transform, bufferSource.getBuffer(FixedWidthFontRenderer.TERMINAL_TEXT));
        if (terminal == null) {
            FixedWidthFontRenderer.drawEmptyTerminal(quadEmitter, 0.0f, 0.0f, width, height);
        } else {
            FixedWidthFontRenderer.drawTerminal(quadEmitter, 2.0f, 2.0f, terminal, 2.0f, 2.0f, 2.0f, 2.0f);
        }
        transform.method_22909();
    }

    private static void renderFrame(Matrix4f transform, class_4597 render, ComputerFamily family, int colour, int light, int width, int height) {
        GuiSprites.ComputerTextures textures = colour != -1 ? GuiSprites.COMPUTER_COLOUR : GuiSprites.getComputerTextures(family);
        SpriteRenderer spriteRenderer = new SpriteRenderer(transform, render, 0, light, colour);
        PocketItemRenderer.renderBorder(spriteRenderer, textures, width, height);
    }

    private static void renderBorder(SpriteRenderer renderer, GuiSprites.ComputerTextures textures, int width, int height) {
        class_8658 sprites = class_310.method_1551().method_52699();
        class_1058 borderSprite = sprites.method_18667(textures.border());
        class_8690.class_8691 borderSlice = PocketItemRenderer.getSlice(sprites.method_52714(borderSprite), DEFAULT_BORDER);
        class_8690.class_8691.class_8692 borderBounds = borderSlice.comp_1639();
        class_2960 bottomTexture = textures.pocketBottom();
        if (bottomTexture == null) {
            throw new NullPointerException(String.valueOf(textures) + " has no pocket texture");
        }
        class_1058 bottomSprite = sprites.method_18667(bottomTexture);
        class_8690.class_8691 bottomSlice = PocketItemRenderer.getSlice(sprites.method_52714(bottomSprite), DEFAULT_BOTTOM);
        class_8690.class_8691.class_8692 bottomBounds = bottomSlice.comp_1639();
        renderer.blit(borderSprite, -borderBounds.comp_1640(), -borderBounds.comp_1641(), borderBounds.comp_1640(), borderBounds.comp_1641(), 0, 0, borderSlice.comp_1637(), borderSlice.comp_1638());
        renderer.blitTiled(borderSprite, 0, -borderBounds.comp_1641(), width, borderBounds.comp_1641(), borderBounds.comp_1640(), 0, borderSlice.comp_1637() - borderBounds.comp_1640() - borderBounds.comp_1642(), borderBounds.comp_1641(), borderSlice.comp_1637(), borderSlice.comp_1638());
        renderer.blit(borderSprite, width, -borderBounds.comp_1641(), borderBounds.comp_1642(), borderBounds.comp_1641(), borderSlice.comp_1637() - borderBounds.comp_1642(), 0, borderSlice.comp_1637(), borderSlice.comp_1638());
        renderer.blitTiled(borderSprite, -borderBounds.comp_1640(), 0, borderBounds.comp_1640(), height, 0, borderBounds.comp_1641(), borderBounds.comp_1640(), borderSlice.comp_1638() - borderBounds.comp_1641() - borderBounds.comp_1643(), borderSlice.comp_1637(), borderSlice.comp_1638());
        renderer.blitTiled(borderSprite, width, 0, borderBounds.comp_1642(), height, borderSlice.comp_1637() - borderBounds.comp_1642(), borderBounds.comp_1641(), borderBounds.comp_1642(), borderSlice.comp_1638() - borderBounds.comp_1641() - borderBounds.comp_1643(), borderSlice.comp_1637(), borderSlice.comp_1638());
        renderer.blit(bottomSprite, -bottomBounds.comp_1640(), height, bottomBounds.comp_1640(), bottomSlice.comp_1638(), 0, 0, bottomSlice.comp_1637(), bottomSlice.comp_1638());
        renderer.blitTiled(bottomSprite, 0, height, width, bottomSlice.comp_1638(), bottomBounds.comp_1640(), 0, bottomSlice.comp_1637() - bottomBounds.comp_1640() - bottomBounds.comp_1642(), bottomSlice.comp_1638(), bottomSlice.comp_1637(), bottomSlice.comp_1638());
        renderer.blit(bottomSprite, width, height, bottomBounds.comp_1642(), bottomSlice.comp_1638(), bottomSlice.comp_1637() - bottomBounds.comp_1642(), 0, bottomSlice.comp_1637(), bottomSlice.comp_1638());
    }

    private static void renderLight(class_4587 transform, class_4597 render, int colour, int width, int height) {
        class_4588 buffer = render.getBuffer(FixedWidthFontRenderer.TERMINAL_TEXT);
        FixedWidthFontRenderer.drawQuad(FixedWidthFontRenderer.toVertexConsumer(transform, buffer), (float)(width - 16), (float)height + 6.0f, 0.001f, 16.0f, 8.0f, class_9848.method_61334((int)colour), 0xF000F0);
    }

    private static class_8690.class_8691 getSlice(class_8690 scaling, class_8690.class_8691 fallback) {
        class_8690.class_8691 slice;
        return scaling instanceof class_8690.class_8691 ? (slice = (class_8690.class_8691)scaling) : fallback;
    }
}

