/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui.widgets;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.textures.GpuTextureView;
import dan200.computercraft.client.gui.KeyConverter;
import dan200.computercraft.client.render.text.FixedWidthFontRenderer;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.util.StringUtil;
import dan200.computercraft.shared.computer.core.InputHandler;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.ByteBuffer;
import java.util.BitSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_4588;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8030;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4f;
import org.jspecify.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class TerminalWidget
extends class_339 {
    private static final class_2561 DESCRIPTION = class_2561.method_43471((String)"gui.computercraft.terminal");
    private static final float TERMINATE_TIME = 0.5f;
    private static final float KEY_SUPPRESS_DELAY = 0.2f;
    private final Terminal terminal;
    private final InputHandler computer;
    private final int innerX;
    private final int innerY;
    private final int innerWidth;
    private final int innerHeight;
    private float terminateTimer = -1.0f;
    private float rebootTimer = -1.0f;
    private float shutdownTimer = -1.0f;
    private int lastMouseButton = -1;
    private int lastMouseX = -1;
    private int lastMouseY = -1;
    private final BitSet keysDown = new BitSet(256);

    public TerminalWidget(Terminal terminal, InputHandler computer, int x, int y) {
        super(x, y, terminal.getWidth() * 6 + 4, terminal.getHeight() * 9 + 4, DESCRIPTION);
        this.terminal = terminal;
        this.computer = computer;
        this.innerX = x + 2;
        this.innerY = y + 2;
        this.innerWidth = terminal.getWidth() * 6;
        this.innerHeight = terminal.getHeight() * 9;
    }

    public boolean method_25400(char ch, int modifiers) {
        int terminalChar = StringUtil.unicodeToTerminal(ch);
        if (StringUtil.isTypableChar(terminalChar)) {
            this.computer.charTyped((byte)terminalChar);
        }
        return true;
    }

    public boolean method_25404(int key, int scancode, int modifiers) {
        if (key == 256) {
            return false;
        }
        if (class_437.method_25437((int)key)) {
            this.paste();
            return true;
        }
        if ((modifiers & 2) != 0) {
            switch (KeyConverter.physicalToActual(key, scancode)) {
                case 84: {
                    if (!(this.terminateTimer < 0.0f)) break;
                    this.terminateTimer = 0.0f;
                    break;
                }
                case 83: {
                    if (!(this.shutdownTimer < 0.0f)) break;
                    this.shutdownTimer = 0.0f;
                    break;
                }
                case 82: {
                    if (!(this.rebootTimer < 0.0f)) break;
                    this.rebootTimer = 0.0f;
                }
            }
        }
        if (key >= 0 && this.terminateTimer < 0.2f && this.rebootTimer < 0.2f && this.shutdownTimer < 0.2f) {
            boolean repeat = this.keysDown.get(key);
            this.keysDown.set(key);
            this.computer.keyDown(key, repeat);
        }
        return true;
    }

    private void paste() {
        ByteBuffer clipboard = StringUtil.getClipboardString(class_310.method_1551().field_1774.method_1460());
        if (clipboard.remaining() > 0) {
            this.computer.paste(clipboard);
        }
    }

    public boolean method_16803(int key, int scancode, int modifiers) {
        if (key >= 0 && this.keysDown.get(key)) {
            this.keysDown.set(key, false);
            this.computer.keyUp(key);
        }
        switch (KeyConverter.physicalToActual(key, scancode)) {
            case 84: {
                this.terminateTimer = -1.0f;
                break;
            }
            case 82: {
                this.rebootTimer = -1.0f;
                break;
            }
            case 83: {
                this.shutdownTimer = -1.0f;
                break;
            }
            case 341: 
            case 345: {
                this.shutdownTimer = -1.0f;
                this.rebootTimer = -1.0f;
                this.terminateTimer = -1.0f;
            }
        }
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.inTermRegion(mouseX, mouseY)) {
            return false;
        }
        if (!this.hasMouseSupport() || button < 0 || button > 2) {
            return false;
        }
        int charX = (int)((mouseX - (double)this.innerX) / 6.0);
        int charY = (int)((mouseY - (double)this.innerY) / 9.0);
        charX = Math.min(Math.max(charX, 0), this.terminal.getWidth() - 1);
        charY = Math.min(Math.max(charY, 0), this.terminal.getHeight() - 1);
        this.computer.mouseClick(button + 1, charX + 1, charY + 1);
        this.lastMouseButton = button;
        this.lastMouseX = charX;
        this.lastMouseY = charY;
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (!this.inTermRegion(mouseX, mouseY)) {
            return false;
        }
        if (!this.hasMouseSupport() || button < 0 || button > 2) {
            return false;
        }
        int charX = (int)((mouseX - (double)this.innerX) / 6.0);
        int charY = (int)((mouseY - (double)this.innerY) / 9.0);
        charX = Math.min(Math.max(charX, 0), this.terminal.getWidth() - 1);
        charY = Math.min(Math.max(charY, 0), this.terminal.getHeight() - 1);
        if (this.lastMouseButton == button) {
            this.computer.mouseUp(this.lastMouseButton + 1, charX + 1, charY + 1);
            this.lastMouseButton = -1;
        }
        this.lastMouseX = charX;
        this.lastMouseY = charY;
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double v2, double v3) {
        if (!this.inTermRegion(mouseX, mouseY)) {
            return false;
        }
        if (!this.hasMouseSupport() || button < 0 || button > 2) {
            return false;
        }
        int charX = (int)((mouseX - (double)this.innerX) / 6.0);
        int charY = (int)((mouseY - (double)this.innerY) / 9.0);
        charX = Math.min(Math.max(charX, 0), this.terminal.getWidth() - 1);
        charY = Math.min(Math.max(charY, 0), this.terminal.getHeight() - 1);
        if (button == this.lastMouseButton && (charX != this.lastMouseX || charY != this.lastMouseY)) {
            this.computer.mouseDrag(button + 1, charX + 1, charY + 1);
            this.lastMouseX = charX;
            this.lastMouseY = charY;
        }
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (!this.inTermRegion(mouseX, mouseY)) {
            return false;
        }
        if (!this.hasMouseSupport() || deltaY == 0.0) {
            return false;
        }
        int charX = (int)((mouseX - (double)this.innerX) / 6.0);
        int charY = (int)((mouseY - (double)this.innerY) / 9.0);
        charX = Math.min(Math.max(charX, 0), this.terminal.getWidth() - 1);
        charY = Math.min(Math.max(charY, 0), this.terminal.getHeight() - 1);
        this.computer.mouseScroll(deltaY < 0.0 ? 1 : -1, charX + 1, charY + 1);
        this.lastMouseX = charX;
        this.lastMouseY = charY;
        return true;
    }

    private boolean inTermRegion(double mouseX, double mouseY) {
        return this.field_22763 && this.field_22764 && mouseX >= (double)this.innerX && mouseY >= (double)this.innerY && mouseX < (double)(this.innerX + this.innerWidth) && mouseY < (double)(this.innerY + this.innerHeight);
    }

    private boolean hasMouseSupport() {
        return this.terminal.isColour();
    }

    public void update() {
        if (this.terminateTimer >= 0.0f && this.terminateTimer < 0.5f) {
            float f;
            this.terminateTimer += 0.05f;
            if (f > 0.5f) {
                this.computer.terminate();
            }
        }
        if (this.shutdownTimer >= 0.0f && this.shutdownTimer < 0.5f) {
            float f;
            this.shutdownTimer += 0.05f;
            if (f > 0.5f) {
                this.computer.shutdown();
            }
        }
        if (this.rebootTimer >= 0.0f && this.rebootTimer < 0.5f) {
            float f;
            this.rebootTimer += 0.05f;
            if (f > 0.5f) {
                this.computer.reboot();
            }
        }
    }

    public void method_25365(boolean focused) {
        super.method_25365(focused);
        if (!focused) {
            for (int key = 0; key < this.keysDown.size(); ++key) {
                if (!this.keysDown.get(key)) continue;
                this.computer.keyUp(key);
            }
            this.keysDown.clear();
            if (this.lastMouseButton >= 0) {
                this.computer.mouseUp(this.lastMouseButton + 1, this.lastMouseX + 1, this.lastMouseY + 1);
                this.lastMouseButton = -1;
            }
            this.rebootTimer = -1.0f;
            this.terminateTimer = -1.0f;
            this.shutdownTimer = -1.0f;
        }
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.field_22764) {
            return;
        }
        class_8030 scissor = graphics.field_44659.method_70863();
        Matrix3x2f terminalPose = new Matrix3x2f((Matrix3x2fc)graphics.method_51448());
        class_11231 terminalTextures = class_11231.method_70902((GpuTextureView)graphics.field_44656.method_1531().method_4619(FixedWidthFontRenderer.FONT).method_71659());
        graphics.field_59826.method_70919((class_11244)new TerminalBackgroundRenderState(this.innerX, this.innerY, this.terminal, terminalPose, terminalTextures, TerminalWidget.maybeIntersect(scissor, new class_8030(this.innerX, this.innerY, this.terminal.getWidth() * 6, this.terminal.getHeight() * 9).method_71523((Matrix3x2f)graphics.method_51448())), scissor));
        graphics.field_59826.method_70919((class_11244)new TerminalTextRenderState(this.innerX, this.innerY, this.terminal, terminalPose, terminalTextures, TerminalWidget.maybeIntersect(scissor, new class_8030(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364()).method_71523((Matrix3x2f)graphics.method_51448())), scissor));
    }

    protected void method_47399(class_6382 output) {
        output.method_37034(class_6381.field_33788, this.method_25369());
    }

    public static int getWidth(int termWidth) {
        return termWidth * 6 + 4;
    }

    public static int getHeight(int termHeight) {
        return termHeight * 9 + 4;
    }

    private static @Nullable class_8030 maybeIntersect(@Nullable class_8030 scissor, class_8030 bounds) {
        return scissor == null ? bounds : bounds.method_49701(scissor);
    }

    @Environment(value=EnvType.CLIENT)
    private static final class TerminalBackgroundRenderState
    extends Record
    implements class_11244 {
        private final int x;
        private final int y;
        private final Terminal terminal;
        private final Matrix3x2f pose;
        private final class_11231 textureSetup;
        private final @Nullable class_8030 bounds;
        private final @Nullable class_8030 scissorArea;

        private TerminalBackgroundRenderState(int x, int y, Terminal terminal, Matrix3x2f pose, class_11231 textureSetup, @Nullable class_8030 bounds, @Nullable class_8030 scissorArea) {
            this.x = x;
            this.y = y;
            this.terminal = terminal;
            this.pose = pose;
            this.textureSetup = textureSetup;
            this.bounds = bounds;
            this.scissorArea = scissorArea;
        }

        public void method_70917(class_4588 vertexConsumer, float z) {
            FixedWidthFontRenderer.QuadEmitter quads = new FixedWidthFontRenderer.QuadEmitter(new Matrix4f().mul((Matrix3x2fc)this.pose).translate(0.0f, 0.0f, z), vertexConsumer);
            FixedWidthFontRenderer.drawTerminalBackground(quads, this.x, this.y, this.terminal, 2.0f, 2.0f, 2.0f, 2.0f);
        }

        public RenderPipeline comp_4055() {
            return class_10799.field_56818;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TerminalBackgroundRenderState.class, "x;y;terminal;pose;textureSetup;bounds;scissorArea", "x", "y", "terminal", "pose", "textureSetup", "bounds", "scissorArea"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TerminalBackgroundRenderState.class, "x;y;terminal;pose;textureSetup;bounds;scissorArea", "x", "y", "terminal", "pose", "textureSetup", "bounds", "scissorArea"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TerminalBackgroundRenderState.class, "x;y;terminal;pose;textureSetup;bounds;scissorArea", "x", "y", "terminal", "pose", "textureSetup", "bounds", "scissorArea"}, this, o);
        }

        public int x() {
            return this.x;
        }

        public int y() {
            return this.y;
        }

        public Terminal terminal() {
            return this.terminal;
        }

        public Matrix3x2f pose() {
            return this.pose;
        }

        public class_11231 comp_4056() {
            return this.textureSetup;
        }

        public @Nullable class_8030 comp_4274() {
            return this.bounds;
        }

        public @Nullable class_8030 comp_4069() {
            return this.scissorArea;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static final class TerminalTextRenderState
    extends Record
    implements class_11244 {
        private final int x;
        private final int y;
        private final Terminal terminal;
        private final Matrix3x2f pose;
        private final class_11231 textureSetup;
        private final @Nullable class_8030 bounds;
        private final @Nullable class_8030 scissorArea;

        private TerminalTextRenderState(int x, int y, Terminal terminal, Matrix3x2f pose, class_11231 textureSetup, @Nullable class_8030 bounds, @Nullable class_8030 scissorArea) {
            this.x = x;
            this.y = y;
            this.terminal = terminal;
            this.pose = pose;
            this.textureSetup = textureSetup;
            this.bounds = bounds;
            this.scissorArea = scissorArea;
        }

        public void method_70917(class_4588 vertexConsumer, float z) {
            FixedWidthFontRenderer.QuadEmitter quads = new FixedWidthFontRenderer.QuadEmitter(new Matrix4f().mul((Matrix3x2fc)this.pose).translate(0.0f, 0.0f, z), vertexConsumer);
            FixedWidthFontRenderer.drawTerminalForeground(quads, this.x, this.y, this.terminal);
            FixedWidthFontRenderer.drawCursor(quads, this.x, this.y, this.terminal);
            for (int i = 0; i < 4; ++i) {
                vertexConsumer.method_22912(0.0f, 0.0f, z).method_39415(0xFFFFFF).method_22913(0.0f, 0.0f).method_60803(0xF000F0);
            }
        }

        public RenderPipeline comp_4055() {
            return class_10799.field_56818;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TerminalTextRenderState.class, "x;y;terminal;pose;textureSetup;bounds;scissorArea", "x", "y", "terminal", "pose", "textureSetup", "bounds", "scissorArea"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TerminalTextRenderState.class, "x;y;terminal;pose;textureSetup;bounds;scissorArea", "x", "y", "terminal", "pose", "textureSetup", "bounds", "scissorArea"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TerminalTextRenderState.class, "x;y;terminal;pose;textureSetup;bounds;scissorArea", "x", "y", "terminal", "pose", "textureSetup", "bounds", "scissorArea"}, this, o);
        }

        public int x() {
            return this.x;
        }

        public int y() {
            return this.y;
        }

        public Terminal terminal() {
            return this.terminal;
        }

        public Matrix3x2f pose() {
            return this.pose;
        }

        public class_11231 comp_4056() {
            return this.textureSetup;
        }

        public @Nullable class_8030 comp_4274() {
            return this.bounds;
        }

        public @Nullable class_8030 comp_4069() {
            return this.scissorArea;
        }
    }
}

