/*
 * Decompiled with CFR 0.152.
 */
package com.dimitrodam.customlan.mixin;

import com.dimitrodam.customlan.CustomLan;
import com.dimitrodam.customlan.CustomLanConfig;
import com.dimitrodam.customlan.CustomLanServerValues;
import com.dimitrodam.customlan.CustomLanState;
import com.dimitrodam.customlan.LanSettings;
import com.dimitrodam.customlan.PublishCommandArgumentValues;
import com.dimitrodam.customlan.TunnelType;
import com.dimitrodam.customlan.command.argument.TunnelArgumentType;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1934;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3093;
import net.minecraft.class_3222;
import net.minecraft.class_3521;
import net.minecraft.class_7918;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3093.class})
public class PublishCommandMixin {
    @Shadow
    @Final
    private static SimpleCommandExceptionType field_13680;
    private static final SimpleCommandExceptionType NOT_STARTED_EXCEPTION;
    private static final SimpleCommandExceptionType STOP_FAILED_EXCEPTION;
    private static final class_2561 PUBLISH_STOPPED_TEXT;

    @Inject(method={"register"}, at={@At(value="HEAD")}, cancellable=true)
    private static void register(CommandDispatcher<class_2168> dispatcher, CallbackInfo ci) {
        List<Pair> arguments = Arrays.asList(Pair.of((Object)class_2170.method_9244((String)"port", (ArgumentType)IntegerArgumentType.integer((int)-1, (int)65535)), argumentValues -> {
            argumentValues.getPort = context -> IntegerArgumentType.getInteger((CommandContext)context, (String)"port");
        }), Pair.of((Object)class_2170.method_9244((String)"onlineMode", (ArgumentType)BoolArgumentType.bool()), argumentValues -> {
            argumentValues.getOnlineMode = context -> BoolArgumentType.getBool((CommandContext)context, (String)"onlineMode");
        }), Pair.of((Object)class_2170.method_9244((String)"pvpEnabled", (ArgumentType)BoolArgumentType.bool()), argumentValues -> {
            argumentValues.getPvpEnabled = context -> BoolArgumentType.getBool((CommandContext)context, (String)"pvpEnabled");
        }), Pair.of((Object)class_2170.method_9244((String)"maxPlayers", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)), argumentValues -> {
            argumentValues.getMaxPlayers = context -> IntegerArgumentType.getInteger((CommandContext)context, (String)"maxPlayers");
        }), Pair.of((Object)class_2170.method_9244((String)"defaultGameMode", (ArgumentType)class_7918.method_47383()), argumentValues -> {
            argumentValues.getGameMode = context -> class_7918.method_47385((CommandContext)context, (String)"defaultGameMode");
        }), Pair.of((Object)class_2170.method_9244((String)"tunnel", (ArgumentType)TunnelArgumentType.tunnel()), argumentValues -> {
            argumentValues.getTunnel = context -> TunnelArgumentType.getTunnel((CommandContext<class_2168>)context, "tunnel");
        }), Pair.of((Object)class_2170.method_9244((String)"motd", (ArgumentType)StringArgumentType.greedyString()), argumentValues -> {
            argumentValues.getMotd = context -> StringArgumentType.getString((CommandContext)context, (String)"motd");
        }));
        Function<PublishCommandArgumentValues, Command<class_2168>> executeCommand = argumentValues -> context -> PublishCommandMixin.execute((class_2168)context.getSource(), argumentValues.getOnlineMode.apply((CommandContext<class_2168>)context), argumentValues.getPvpEnabled.apply((CommandContext<class_2168>)context), argumentValues.getTunnel.apply((CommandContext<class_2168>)context), argumentValues.getPort.apply((CommandContext<class_2168>)context), argumentValues.getMaxPlayers.apply((CommandContext<class_2168>)context), argumentValues.getGameMode.apply((CommandContext<class_2168>)context), argumentValues.getMotd.apply((CommandContext<class_2168>)context));
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)PublishCommandMixin.processThisAndArguments((LiteralArgumentBuilder)class_2170.method_9247((String)"publish").requires(source -> {
            class_1297 entity = source.method_9228();
            if (entity instanceof class_3222 && source.method_9211().method_19466(((class_3222)entity).method_7334())) {
                return true;
            }
            return source.method_9259(4);
        }), new PublishCommandArgumentValues(context -> {
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            if (server.method_3860()) {
                CustomLanServerValues serverValues = (CustomLanServerValues)server;
                return new LanSettings(server.method_3790(), server.method_3828(), server.method_3852(), serverValues.getTunnelType(), server.method_3756(), server.method_3802(), serverValues.getRawMotd());
            }
            CustomLanState customLanState = (CustomLanState)server.method_30002().method_17983().method_17924(CustomLanState.STATE_TYPE);
            if (customLanState.getLanSettings() != null) {
                return customLanState.getLanSettings();
            }
            if (((CustomLanConfig)CustomLan.CONFIG.getConfig()).lanSettings != null) {
                return ((CustomLanConfig)CustomLan.CONFIG.getConfig()).lanSettings;
            }
            return null;
        }), executeCommand, arguments.iterator()).then((ArgumentBuilder)PublishCommandMixin.processThisAndArguments(class_2170.method_9247((String)"perworld"), new PublishCommandArgumentValues(context -> ((CustomLanState)((class_2168)context.getSource()).method_9211().method_30002().method_17983().method_17924(CustomLanState.STATE_TYPE)).getLanSettings()), executeCommand, arguments.iterator()))).then((ArgumentBuilder)PublishCommandMixin.processThisAndArguments(class_2170.method_9247((String)"global"), new PublishCommandArgumentValues(context -> ((CustomLanConfig)CustomLan.CONFIG.getConfig()).lanSettings), executeCommand, arguments.iterator()))).then((ArgumentBuilder)PublishCommandMixin.processThisAndArguments(class_2170.method_9247((String)"system"), new PublishCommandArgumentValues(context -> LanSettings.systemDefaults(((class_2168)context.getSource()).method_9211())), executeCommand, arguments.iterator()))).then(class_2170.method_9247((String)"stop").executes(context -> PublishCommandMixin.stop((class_2168)context.getSource())));
        dispatcher.register(command);
        ci.cancel();
    }

    private static ArgumentBuilder<class_2168, ?> processArguments(PublishCommandArgumentValues argumentValues, Function<PublishCommandArgumentValues, Command<class_2168>> executeCommand, Iterator<Pair<ArgumentBuilder<class_2168, ?>, Consumer<PublishCommandArgumentValues>>> arguments) {
        Pair<ArgumentBuilder<class_2168, ?>, Consumer<PublishCommandArgumentValues>> argument = arguments.next();
        ((Consumer)argument.getRight()).accept(argumentValues);
        ArgumentBuilder newArgument = ((ArgumentBuilder)argument.getLeft()).executes(executeCommand.apply(new PublishCommandArgumentValues(argumentValues)));
        if (arguments.hasNext()) {
            newArgument = newArgument.then(PublishCommandMixin.processArguments(argumentValues, executeCommand, arguments));
        }
        return newArgument;
    }

    private static <T extends ArgumentBuilder<class_2168, T>> T processThisAndArguments(T builder, PublishCommandArgumentValues argumentValues, Function<PublishCommandArgumentValues, Command<class_2168>> executeCommand, Iterator<Pair<ArgumentBuilder<class_2168, ?>, Consumer<PublishCommandArgumentValues>>> arguments) {
        return (T)builder.executes(executeCommand.apply(argumentValues)).then(PublishCommandMixin.processArguments(new PublishCommandArgumentValues(argumentValues), executeCommand, arguments));
    }

    private static int execute(class_2168 source, boolean onlineMode, boolean pvpEnabled, TunnelType tunnel, int rawPort, int maxPlayers, class_1934 gameMode, String rawMotd) throws CommandSyntaxException {
        int port = rawPort != -1 ? rawPort : class_3521.method_15302();
        try {
            CustomLan.startOrSaveLan(source.method_9211(), gameMode, onlineMode, pvpEnabled, tunnel, port, maxPlayers, rawMotd, text -> source.method_9226(() -> text, true), () -> {
                throw new RuntimeException((Throwable)field_13680.create());
            }, text -> source.method_9213(text));
        }
        catch (RuntimeException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof CommandSyntaxException) {
                CommandSyntaxException cause = (CommandSyntaxException)throwable;
                throw cause;
            }
            throw e;
        }
        return port;
    }

    private static int stop(class_2168 source) throws CommandSyntaxException {
        MinecraftServer server = source.method_9211();
        if (!server.method_3860()) {
            throw NOT_STARTED_EXCEPTION.create();
        }
        CustomLan.stopLan(server, () -> source.method_9226(() -> PUBLISH_STOPPED_TEXT, true), () -> {
            throw new RuntimeException((Throwable)STOP_FAILED_EXCEPTION.create());
        }, text -> source.method_9213(text));
        return 1;
    }

    static {
        NOT_STARTED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.publish.failed.not_started"));
        STOP_FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.publish.failed.stop"));
        PUBLISH_STOPPED_TEXT = class_2561.method_43471((String)"commands.publish.stopped");
    }
}

