/*
 * Decompiled with CFR 0.152.
 */
package com.dimitrodam.customlan.mixin;

import com.dimitrodam.customlan.CustomLan;
import com.dimitrodam.customlan.CustomLanConfig;
import com.dimitrodam.customlan.CustomLanServerValues;
import com.dimitrodam.customlan.CustomLanState;
import com.dimitrodam.customlan.LanSettings;
import com.dimitrodam.customlan.TunnelType;
import net.minecraft.class_1132;
import net.minecraft.class_124;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3521;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_436;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5489;
import net.minecraft.class_5676;
import net.minecraft.class_7919;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_436.class})
public abstract class OpenToLanScreenMixin
extends class_437 {
    private static final class_2561 PUBLISH_FAILED_TEXT = class_2561.method_43471((String)"commands.publish.failed");
    private static final class_2561 PUBLISH_STOP_FAILED_TEXT = class_2561.method_43471((String)"commands.publish.failed.stop");
    private static final class_2561 PUBLISH_STOPPED_TEXT = class_2561.method_43471((String)"commands.publish.stopped");
    private static final class_2561 EXPLANATION_TEXT = class_2561.method_43471((String)"lanServer.explanation");
    private static final class_2561 PER_WORLD_TEXT = class_2561.method_43471((String)"lanServer.perWorld");
    private static final class_2561 GLOBAL_TEXT = class_2561.method_43471((String)"lanServer.global");
    private static final class_2561 SYSTEM_TEXT = class_2561.method_43471((String)"lanServer.system");
    private static final class_2561 LOAD_TEXT = class_2561.method_43471((String)"lanServer.load");
    private static final class_2561 LOAD_SYSTEM_TEXT = class_2561.method_43471((String)"lanServer.load.system");
    private static final class_2561 CLEAR_TEXT = class_2561.method_43471((String)"lanServer.clear");
    private static final class_2561 CLEAR_PERWORLD_QUESTION_TEXT = class_2561.method_43471((String)"lanServer.clear.perWorld.question");
    private static final class_2561 CLEAR_GLOBAL_QUESTION_TEXT = class_2561.method_43471((String)"lanServer.clear.global.question");
    private static final class_2561 START_TEXT = class_2561.method_43471((String)"lanServer.start");
    private static final class_2561 SAVE_TEXT = class_2561.method_43471((String)"lanServer.save");
    private static final class_2561 STOP_TEXT = class_2561.method_43471((String)"lanServer.stop");
    private static final class_2561 ONLINE_MODE_TEXT = class_2561.method_43471((String)"lanServer.onlineMode");
    private static final class_2561 PVP_ENABLED_TEXT = class_2561.method_43471((String)"lanServer.pvpEnabled");
    private static final class_2561 TUNNEL_TEXT = class_2561.method_43471((String)"lanServer.tunnel");
    private static final class_2561 MAX_PLAYERS_TEXT = class_2561.method_43471((String)"lanServer.maxPlayers");
    private static final class_2561 INVALID_MAX_PLAYERS_TEXT = class_2561.method_43469((String)"lanServer.maxPlayers.invalid", (Object[])new Object[]{0});
    private static final class_2561 MOTD_TEXT = class_2561.method_43471((String)"lanServer.motd");
    private static final class_2561 MOTD_DESCRIPTION_TEXT = class_2561.method_43471((String)"lanServer.motd.description");
    @Shadow
    @Final
    private static class_2561 field_41108;
    @Shadow
    @Final
    private static int field_41107;
    private boolean initialized = false;
    private CustomLanState customLanState;
    private class_4185 perWorldLoadButton;
    private class_4185 perWorldClearButton;
    private class_4185 globalLoadButton;
    private class_4185 globalClearButton;
    private class_5676<class_1934> gameModeButton;
    private class_5489 explanationText = class_5489.field_26528;
    private class_5676<Boolean> onlineModeButton;
    private class_5676<Boolean> pvpEnabledButton;
    private class_5676<TunnelType> tunnelButton;
    private class_342 maxPlayersField;
    private class_342 motdField;
    private class_4185 startSaveButton;
    @Shadow
    @Nullable
    private class_342 field_41111;
    private boolean onlineMode;
    private boolean pvpEnabled;
    private TunnelType tunnel;
    private int rawPort;
    private boolean portValid = true;
    private int maxPlayers;
    private boolean maxPlayersValid = true;
    private String rawMotd;
    @Shadow
    private class_1934 field_2545;
    @Shadow
    private int field_41110;

    protected OpenToLanScreenMixin(class_2561 title) {
        super(title);
    }

    private boolean canStartOrSave() {
        return this.portValid && this.maxPlayersValid;
    }

    private void loadLanSettingsValues(@Nullable LanSettings lanSettings) {
        if (lanSettings == null) {
            return;
        }
        this.field_2545 = lanSettings.gameMode;
        this.onlineMode = lanSettings.onlineMode;
        this.pvpEnabled = lanSettings.pvpEnabled;
        this.tunnel = lanSettings.tunnel;
        this.rawPort = lanSettings.port;
        this.field_41110 = lanSettings.port != -1 ? lanSettings.port : class_3521.method_15302();
        this.maxPlayers = lanSettings.maxPlayers;
        this.rawMotd = lanSettings.motd;
    }

    private void loadLanSettings(@Nullable LanSettings lanSettings) {
        this.loadLanSettingsValues(lanSettings);
        this.gameModeButton.method_32605((Object)this.field_2545);
        this.onlineModeButton.method_32605((Object)this.onlineMode);
        this.pvpEnabledButton.method_32605((Object)this.pvpEnabled);
        this.tunnelButton.method_32605((Object)this.tunnel);
        this.field_41111.method_1852(this.rawPort != -1 ? Integer.toString(this.field_41110) : "");
        this.maxPlayersField.method_1852(Integer.toString(this.maxPlayers));
        this.motdField.method_1852(this.rawMotd);
    }

    private LanSettings saveLanSettings() {
        return new LanSettings(this.field_2545, this.onlineMode, this.pvpEnabled, this.tunnel, this.field_41111.method_1882().isBlank() ? -1 : this.field_41110, this.maxPlayers, this.rawMotd);
    }

    private void updateSettingsButtons() {
        boolean savedGlobal;
        boolean savedPerWorld;
        this.perWorldLoadButton.field_22763 = savedPerWorld = this.customLanState.getLanSettings() != null;
        this.perWorldClearButton.field_22763 = savedPerWorld;
        this.globalLoadButton.field_22763 = savedGlobal = ((CustomLanConfig)CustomLan.CONFIG.getConfig()).lanSettings != null;
        this.globalClearButton.field_22763 = savedGlobal;
    }

    @Inject(method={"init"}, at={@At(value="HEAD")})
    private void preInit(CallbackInfo ci) {
        class_1132 server = this.field_22787.method_1576();
        if (!this.initialized) {
            this.customLanState = (CustomLanState)server.method_30002().method_17983().method_17924(CustomLanState.STATE_TYPE);
            if (server.method_3860()) {
                CustomLanServerValues serverValues = (CustomLanServerValues)server;
                this.field_2545 = server.method_3790();
                this.onlineMode = server.method_3828();
                this.pvpEnabled = server.method_3852();
                this.tunnel = serverValues.getTunnelType();
                this.rawPort = this.field_41110 = server.method_3756();
                this.maxPlayers = server.method_3802();
                this.rawMotd = serverValues.getRawMotd();
            } else if (this.customLanState.getLanSettings() != null) {
                this.loadLanSettingsValues(this.customLanState.getLanSettings());
            } else if (((CustomLanConfig)CustomLan.CONFIG.getConfig()).lanSettings != null) {
                this.loadLanSettingsValues(((CustomLanConfig)CustomLan.CONFIG.getConfig()).lanSettings);
            } else {
                this.loadLanSettingsValues(LanSettings.systemDefaults((MinecraftServer)server));
            }
            this.initialized = true;
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)SAVE_TEXT, button -> {
            this.customLanState.setLanSettings(this.saveLanSettings());
            this.updateSettingsButtons();
        }).method_46434(this.field_22789 / 2 - 77, 8, 74, 20).method_46431());
        this.perWorldLoadButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)LOAD_TEXT, button -> this.loadLanSettings(this.customLanState.getLanSettings())).method_46434(this.field_22789 / 2 + 2, 8, 74, 20).method_46431());
        this.perWorldClearButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)CLEAR_TEXT, button -> this.field_22787.method_1507((class_437)new class_410(confirmed -> {
            if (confirmed) {
                this.customLanState.setLanSettings(null);
                this.updateSettingsButtons();
            }
            this.field_22787.method_1507((class_437)this);
        }, CLEAR_PERWORLD_QUESTION_TEXT, class_5244.field_39003, CLEAR_TEXT, class_5244.field_24335))).method_46434(this.field_22789 / 2 + 81, 8, 74, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)SAVE_TEXT, button -> {
            ((CustomLanConfig)CustomLan.CONFIG.getConfig()).setLanSettings(this.saveLanSettings());
            this.updateSettingsButtons();
        }).method_46434(this.field_22789 / 2 - 77, 32, 74, 20).method_46431());
        this.globalLoadButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)LOAD_TEXT, button -> this.loadLanSettings(((CustomLanConfig)CustomLan.CONFIG.getConfig()).lanSettings)).method_46434(this.field_22789 / 2 + 2, 32, 74, 20).method_46431());
        this.globalClearButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)CLEAR_TEXT, button -> this.field_22787.method_1507((class_437)new class_410(confirmed -> {
            if (confirmed) {
                ((CustomLanConfig)CustomLan.CONFIG.getConfig()).setLanSettings(null);
                this.updateSettingsButtons();
            }
            this.field_22787.method_1507((class_437)this);
        }, CLEAR_GLOBAL_QUESTION_TEXT, class_5244.field_39003, CLEAR_TEXT, class_5244.field_24335))).method_46434(this.field_22789 / 2 + 81, 32, 74, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)LOAD_SYSTEM_TEXT, button -> this.loadLanSettings(LanSettings.systemDefaults((MinecraftServer)server))).method_46434(this.field_22789 / 2 - 77, 56, 232, 20).method_46431());
        this.updateSettingsButtons();
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void postInit(CallbackInfo ci) {
        class_1132 server = this.field_22787.method_1576();
        boolean alreadyOpenedToLan = server.method_3860();
        this.method_37066((class_364)this.method_25396().get(8));
        this.gameModeButton = (class_5676)this.method_25396().get(7);
        this.gameModeButton.method_25358(310);
        this.explanationText = class_5489.method_30890((class_327)this.field_22793, (class_2561)EXPLANATION_TEXT, (int)308);
        this.onlineModeButton = (class_5676)this.method_37063((class_364)class_5676.method_32613((boolean)this.onlineMode).method_32617(this.field_22789 / 2 - 155, 124, 150, 20, ONLINE_MODE_TEXT, (button, onlineMode) -> {
            this.onlineMode = onlineMode;
        }));
        this.pvpEnabledButton = (class_5676)this.method_37063((class_364)class_5676.method_32613((boolean)this.pvpEnabled).method_32617(this.field_22789 / 2 + 5, 124, 150, 20, PVP_ENABLED_TEXT, (button, pvpEnabled) -> {
            this.pvpEnabled = pvpEnabled;
        }));
        this.tunnelButton = (class_5676)this.method_37063((class_364)class_5676.method_32606(TunnelType::getTranslatableName).method_32624((Object[])TunnelType.values()).method_32619((Object)this.tunnel).method_32617(this.field_22789 / 2 - 155, 148, 310, 20, TUNNEL_TEXT, (button, tunnel) -> {
            this.tunnel = tunnel;
        }));
        this.field_41111.method_48229(this.field_22789 / 2 - 154, this.field_22790 - 92);
        this.field_41111.method_25358(148);
        this.field_41111.method_1852(this.rawPort != -1 ? Integer.toString(this.field_41110) : "");
        this.method_37066((class_364)this.field_41111);
        this.method_37063((class_364)this.field_41111);
        this.maxPlayersField = new class_342(this.field_22793, this.field_22789 / 2 + 6, this.field_22790 - 92, 148, 20, MAX_PLAYERS_TEXT);
        this.maxPlayersField.method_1852(Integer.toString(this.maxPlayers));
        this.maxPlayersField.method_1863(maxPlayers -> {
            Integer newMaxPlayers = null;
            try {
                newMaxPlayers = Integer.parseInt(maxPlayers);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (newMaxPlayers != null && newMaxPlayers > 0) {
                this.maxPlayers = newMaxPlayers;
                this.maxPlayersValid = true;
                this.maxPlayersField.method_1868(-2039584);
                this.maxPlayersField.method_47400(null);
            } else {
                this.maxPlayersValid = false;
                this.maxPlayersField.method_1868(field_41107);
                this.maxPlayersField.method_47400(class_7919.method_47407((class_2561)INVALID_MAX_PLAYERS_TEXT));
            }
            this.startSaveButton.field_22763 = this.canStartOrSave();
        });
        this.method_37063((class_364)this.maxPlayersField);
        this.motdField = new class_342(this.field_22793, this.field_22789 / 2 - 154, this.field_22790 - 54, 308, 20, MOTD_TEXT);
        this.motdField.method_1880(59);
        this.motdField.method_1852(this.rawMotd);
        this.motdField.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)CustomLan.processMotd((MinecraftServer)server, MOTD_DESCRIPTION_TEXT.getString()))));
        this.motdField.method_1863(rawMotd -> {
            this.rawMotd = rawMotd;
        });
        this.method_37063((class_364)this.motdField);
        this.method_37066((class_364)this.method_25396().get(8));
        this.startSaveButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)(alreadyOpenedToLan ? SAVE_TEXT : START_TEXT), button -> this.startOrSave()).method_46434(this.field_22789 / 2 - 155, this.field_22790 - 28, alreadyOpenedToLan ? 73 : 150, 20).method_46431());
        this.startSaveButton.field_22763 = this.canStartOrSave();
        if (alreadyOpenedToLan) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)STOP_TEXT, button -> this.stop()).method_46434(this.field_22789 / 2 - 78, this.field_22790 - 28, 73, 20).method_46431());
        }
        class_4185 cancelButton = (class_4185)this.method_25396().get(8);
        this.method_37066((class_364)cancelButton);
        this.method_37063((class_364)cancelButton);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void render(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        context.method_27535(this.field_22793, PER_WORLD_TEXT, this.field_22789 / 2 - 155, 14, -1);
        context.method_27535(this.field_22793, GLOBAL_TEXT, this.field_22789 / 2 - 155, 38, -1);
        context.method_27535(this.field_22793, SYSTEM_TEXT, this.field_22789 / 2 - 155, 62, -1);
        this.explanationText.method_30893(context, this.field_22789 / 2 - 154, 172, 9, -6250336);
        context.method_27535(this.field_22793, field_41108, this.field_22789 / 2 - 154, this.field_22790 - 104, -6250336);
        context.method_27535(this.field_22793, MAX_PLAYERS_TEXT, this.field_22789 / 2 + 6, this.field_22790 - 104, -6250336);
        context.method_27535(this.field_22793, MOTD_TEXT, this.field_22789 / 2 - 154, this.field_22790 - 66, -6250336);
    }

    @Redirect(method={"updatePort"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/NetworkUtils;isPortAvailable(I)Z"))
    private boolean allowKeepingPort(int port) {
        return class_3521.method_46872((int)port) || port == this.field_22787.method_1576().method_3756();
    }

    @Inject(method={"method_47416"}, at={@At(value="TAIL")}, remap=false)
    private void updatePortValid(class_4185 button, String portText, CallbackInfo ci) {
        this.portValid = button.field_22763;
        if (this.startSaveButton != null) {
            this.startSaveButton.field_22763 = this.canStartOrSave();
        }
    }

    @ModifyConstant(method={"render"}, constant={@Constant(intValue=50)})
    private int changeTitleY(int y) {
        return 88;
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawCenteredTextWithShadow(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/Text;III)V"), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawCenteredTextWithShadow(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/Text;III)V", ordinal=1)))
    private void removeOtherPlayersAndPortText(class_332 context, class_327 textRenderer, class_2561 text, int centerX, int y, int color) {
    }

    private void startOrSave() {
        this.field_22787.method_1507(null);
        CustomLan.startOrSaveLan((MinecraftServer)this.field_22787.method_1576(), this.field_2545, this.onlineMode, this.pvpEnabled, this.tunnel, this.field_41110, this.maxPlayers, this.rawMotd, text -> this.field_22787.field_1705.method_1743().method_1812(text), () -> this.field_22787.field_1705.method_1743().method_1812((class_2561)PUBLISH_FAILED_TEXT.method_27661().method_27692(class_124.field_1061)), text -> this.field_22787.field_1705.method_1743().method_1812((class_2561)text.method_27661().method_27692(class_124.field_1061)));
    }

    private void stop() {
        this.field_22787.method_1507(null);
        CustomLan.stopLan((MinecraftServer)this.field_22787.method_1576(), () -> this.field_22787.field_1705.method_1743().method_1812(PUBLISH_STOPPED_TEXT), () -> this.field_22787.field_1705.method_1743().method_1812((class_2561)PUBLISH_STOP_FAILED_TEXT.method_27661().method_27692(class_124.field_1061)), text -> this.field_22787.field_1705.method_1743().method_1812((class_2561)text.method_27661().method_27692(class_124.field_1061)));
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            if (this.canStartOrSave()) {
                this.startOrSave();
            }
            return true;
        }
        return false;
    }
}

