/*
 * Decompiled with CFR 0.152.
 */
package com.dimitrodam.customlan;

import com.dimitrodam.customlan.CustomLan;
import com.dimitrodam.customlan.CustomLanConfig;
import com.dimitrodam.customlan.util.Utils;
import com.github.alexdlaird.ngrok.NgrokClient;
import com.github.alexdlaird.ngrok.conf.JavaNgrokConfig;
import com.github.alexdlaird.ngrok.protocol.CreateTunnel;
import com.github.alexdlaird.ngrok.protocol.Proto;
import com.github.alexdlaird.ngrok.protocol.Tunnel;
import java.net.URI;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_3542;
import net.minecraft.class_5244;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public enum TunnelType implements class_3542
{
    NONE("none"),
    NGROK("ngrok"){

        @Override
        @Nullable
        public class_2561 start(MinecraftServer server) throws TunnelException {
            String authtoken = ((CustomLanConfig)CustomLan.CONFIG.getConfig()).ngrokAuthtoken.strip();
            if (authtoken.isEmpty()) {
                throw new TunnelException((class_2561)class_5244.method_32700((class_2561)NGROK_FAILED, (class_2561)class_2561.method_43469((String)TunnelType.NGROK_FAILED_NO_AUTHTOKEN, (Object[])new Object[]{Utils.createLink(URI.create(TunnelType.NGROK_AUTHTOKEN_URL))})));
            }
            try {
                CustomLan.NGROK_CLIENT = new NgrokClient.Builder().withJavaNgrokConfig(new JavaNgrokConfig.Builder().withAuthToken(authtoken).build()).build();
                Tunnel tunnel = CustomLan.NGROK_CLIENT.connect(new CreateTunnel.Builder().withProto(Proto.TCP).withAddr(server.method_3756()).build());
                return class_2564.method_47523((String)tunnel.getPublicUrl().replaceFirst("^tcp:\\/\\/", ""));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TunnelException((class_2561)class_5244.method_32700((class_2561)NGROK_FAILED, (class_2561)class_2561.method_30163((String)e.getMessage())), (Throwable)e);
            }
        }

        @Override
        public void stop(MinecraftServer server) throws TunnelException {
            try {
                if (CustomLan.NGROK_CLIENT != null) {
                    CustomLan.NGROK_CLIENT.kill();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TunnelException((class_2561)class_5244.method_32700((class_2561)NGROK_STOP_FAILED, (class_2561)class_2561.method_30163((String)e.getMessage())), (Throwable)e);
            }
        }
    };

    public static final class_3542.class_7292<TunnelType> CODEC;
    private static final String NGROK_AUTHTOKEN_URL = "https://dashboard.ngrok.com/get-started/your-authtoken";
    private static final class_2561 NGROK_FAILED;
    private static final class_2561 NGROK_STOP_FAILED;
    private static final String NGROK_FAILED_NO_AUTHTOKEN = "commands.publish.failed.tunnel.ngrok.noAuthtoken";
    private final String name;

    public static TunnelType byName(String name) {
        return TunnelType.byName(name, NONE);
    }

    @Nullable
    public static TunnelType byName(String name, @Nullable TunnelType defaultTunnelType) {
        TunnelType tunnelType = (TunnelType)CODEC.method_42633(name);
        return tunnelType != null ? tunnelType : defaultTunnelType;
    }

    private TunnelType(String name) {
        this.name = name;
    }

    @Nullable
    public class_2561 start(MinecraftServer server) throws TunnelException {
        return null;
    }

    public void stop(MinecraftServer server) throws TunnelException {
    }

    public String getName() {
        return this.name;
    }

    public class_2561 getTranslatableName() {
        return class_2561.method_43471((String)("customlan.tunnel." + this.name));
    }

    public String method_15434() {
        return this.name;
    }

    static {
        CODEC = class_3542.method_28140(TunnelType::values);
        NGROK_FAILED = class_2561.method_43471((String)"commands.publish.failed.tunnel.ngrok");
        NGROK_STOP_FAILED = class_2561.method_43471((String)"commands.publish.failed.tunnel.ngrok.stop");
    }

    public static class TunnelException
    extends Exception {
        private final class_2561 messageText;

        public TunnelException(class_2561 messageText) {
            super(messageText.getString());
            this.messageText = messageText;
        }

        public TunnelException(class_2561 messageText, Throwable cause) {
            super(messageText.toString(), cause);
            this.messageText = messageText;
        }

        public class_2561 getMessageText() {
            return this.messageText;
        }
    }
}

