/*
 * Decompiled with CFR 0.152.
 */
package com.dimitrodam.customlan;

import com.dimitrodam.customlan.TunnelType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1934;
import net.minecraft.class_2487;
import net.minecraft.server.MinecraftServer;

public class LanSettings {
    public static final boolean DEFAULT_ONLINE_MODE = true;
    public static final boolean DEFAULT_PVP_ENABLED = true;
    public static final TunnelType DEFAULT_TUNNEL = TunnelType.NONE;
    public static final int DEFAULT_PORT = 25565;
    public static final int DEFAULT_MAX_PLAYERS = 8;
    public static final String DEFAULT_MOTD = "${username} - ${world}";
    public static final Codec<LanSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1934.field_41676.fieldOf("gameMode").forGetter(lanSettings -> lanSettings.gameMode), (App)Codec.BOOL.optionalFieldOf("onlineMode", (Object)true).forGetter(lanSettings -> lanSettings.onlineMode), (App)Codec.BOOL.optionalFieldOf("pvpEnabled", (Object)true).forGetter(lanSettings -> lanSettings.pvpEnabled), (App)TunnelType.CODEC.optionalFieldOf("tunnel", (Object)DEFAULT_TUNNEL).forGetter(lanSettings -> lanSettings.tunnel), (App)Codec.INT.optionalFieldOf("port", (Object)25565).forGetter(lanSettings -> lanSettings.port), (App)Codec.INT.optionalFieldOf("maxPlayers", (Object)8).forGetter(lanSettings -> lanSettings.maxPlayers), (App)Codec.STRING.optionalFieldOf("motd", (Object)DEFAULT_MOTD).forGetter(lanSettings -> lanSettings.motd)).apply((Applicative)instance, LanSettings::new));
    public class_1934 gameMode;
    public boolean onlineMode;
    public boolean pvpEnabled;
    public TunnelType tunnel;
    public int port;
    public int maxPlayers;
    public String motd;

    public LanSettings(class_1934 gameMode, boolean onlineMode, boolean pvpEnabled, TunnelType tunnel, int port, int maxPlayers, String motd) {
        this.gameMode = gameMode;
        this.onlineMode = onlineMode;
        this.pvpEnabled = pvpEnabled;
        this.tunnel = tunnel;
        this.port = port;
        this.maxPlayers = maxPlayers;
        this.motd = motd;
    }

    public static LanSettings systemDefaults(MinecraftServer server) {
        return LanSettings.systemDefaults(server.method_3790());
    }

    public static LanSettings systemDefaults(class_1934 gameMode) {
        return new LanSettings(gameMode, true, true, DEFAULT_TUNNEL, 25565, 8, DEFAULT_MOTD);
    }

    public static LanSettings fromNbt(class_2487 nbt) {
        LanSettings lanSettings = LanSettings.systemDefaults(class_1934.method_8384((int)((Integer)nbt.method_10550("gameMode").get())));
        nbt.method_10577("onlineMode").ifPresent(onlineMode -> {
            lanSettings.onlineMode = onlineMode;
        });
        nbt.method_10577("pvpEnabled").ifPresent(pvpEnabled -> {
            lanSettings.pvpEnabled = pvpEnabled;
        });
        nbt.method_10558("tunnel").ifPresent(tunnel -> {
            lanSettings.tunnel = TunnelType.valueOf(tunnel);
        });
        nbt.method_10550("port").ifPresent(port -> {
            lanSettings.port = port;
        });
        nbt.method_10550("maxPlayers").ifPresent(maxPlayers -> {
            lanSettings.maxPlayers = maxPlayers;
        });
        nbt.method_10558("motd").ifPresent(motd -> {
            lanSettings.motd = motd;
        });
        return lanSettings;
    }

    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10569("gameMode", this.gameMode.method_8379());
        nbt.method_10556("onlineMode", this.onlineMode);
        nbt.method_10556("pvpEnabled", this.pvpEnabled);
        nbt.method_10582("tunnel", this.tunnel.name());
        nbt.method_10569("port", this.port);
        nbt.method_10569("maxPlayers", this.maxPlayers);
        nbt.method_10582("motd", this.motd);
        return nbt;
    }
}

