/*
 * Decompiled with CFR 0.152.
 */
package com.dimitrodam.customlan;

import com.dimitrodam.customlan.CustomLanConfig;
import com.dimitrodam.customlan.CustomLanServerValues;
import com.dimitrodam.customlan.TunnelType;
import com.dimitrodam.customlan.command.argument.TunnelArgumentType;
import com.dimitrodam.customlan.mixin.IntegratedServerAccessor;
import com.dimitrodam.customlan.mixin.PlayerManagerAccessor;
import com.github.alexdlaird.ngrok.NgrokClient;
import com.mojang.brigadier.CommandDispatcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Consumer;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1133;
import net.minecraft.class_1934;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2960;
import net.minecraft.class_3012;
import net.minecraft.class_3014;
import net.minecraft.class_3016;
import net.minecraft.class_3030;
import net.minecraft.class_3083;
import net.minecraft.class_3086;
import net.minecraft.class_3088;
import net.minecraft.class_310;
import net.minecraft.class_3156;
import net.minecraft.class_3222;
import net.minecraft.class_3242;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.text.StringSubstitutor;
import org.jetbrains.annotations.Nullable;

public class CustomLan
implements ModInitializer {
    public static final String MODID = "customlan";
    public static ConfigHolder<CustomLanConfig> CONFIG;
    @Nullable
    public static NgrokClient NGROK_CLIENT;
    private static final String PUBLISH_STARTED_CUSTOMLAN_TEXT = "commands.publish.started.customlan";
    private static final String PUBLISH_STARTED_CUSTOMLAN_TUNNEL_TEXT = "commands.publish.started.customlan.tunnel";
    private static final String PUBLISH_PORT_CHANGE_FAILED_TEXT = "commands.publish.failed.port_change";
    private static final String PUBLISH_SAVED_TEXT = "commands.publish.saved";
    private static final String PUBLISH_SAVED_TUNNEL_TEXT = "commands.publish.saved.tunnel";
    private static final class_2561 SERVER_STOPPED_TEXT;

    public static String processMotd(MinecraftServer server, String rawMotd) {
        HashMap<String, String> motdMap = new HashMap<String, String>();
        motdMap.put("username", server.method_43824().getName());
        motdMap.put("world", server.method_27728().method_150());
        StringSubstitutor motdSubstitutor = new StringSubstitutor(motdMap);
        return motdSubstitutor.replace(rawMotd).replaceAll("((?:[^&]|^)(?:&&)*)&(?!&)", "$1\u00a7").replace("&&", "&");
    }

    public static void startOrSaveLan(MinecraftServer server, class_1934 gameMode, boolean onlineMode, boolean pvpEnabled, TunnelType tunnel, int port, int maxPlayers, String rawMotd, Consumer<class_2561> onSuccess, Runnable onFatalError, Consumer<class_2561> onNonFatalError) {
        block23: {
            CustomLanServerValues serverValues = (CustomLanServerValues)server;
            class_3324 playerManager = server.method_3760();
            server.method_3864(onlineMode);
            server.method_3815(pvpEnabled);
            ((PlayerManagerAccessor)playerManager).setMaxPlayers(maxPlayers);
            String oldMotd = server.method_3818();
            String motd = CustomLan.processMotd(server, rawMotd);
            serverValues.setRawMotd(rawMotd);
            server.method_3834(motd);
            server.method_3856();
            if (server.method_3860()) {
                int oldPort = server.method_3756();
                boolean portChanged = false;
                if (port != oldPort) {
                    class_3242 networkIo = server.method_3787();
                    try {
                        networkIo.method_14354(null, port);
                        networkIo.method_14356();
                        networkIo.method_14354(null, port);
                        ((IntegratedServerAccessor)server).setLanPort(port);
                        portChanged = true;
                    }
                    catch (IOException e) {
                        onNonFatalError.accept((class_2561)class_2561.method_43469((String)PUBLISH_PORT_CHANGE_FAILED_TEXT, (Object[])new Object[]{class_2564.method_47523((String)String.valueOf(oldPort))}));
                    }
                }
                if (portChanged || !motd.equals(oldMotd)) {
                    ((IntegratedServerAccessor)server).getLanPinger().interrupt();
                    try {
                        class_1133 lanPinger = new class_1133(motd, Integer.toString(server.method_3756()));
                        ((IntegratedServerAccessor)server).setLanPinger(lanPinger);
                        lanPinger.start();
                    }
                    catch (IOException lanPinger) {
                        // empty catch block
                    }
                }
                server.method_3838(gameMode);
                for (class_3222 player : playerManager.method_14571()) {
                    playerManager.method_14576(player);
                }
                TunnelType oldTunnel = serverValues.getTunnelType();
                if (tunnel != oldTunnel || portChanged) {
                    try {
                        oldTunnel.stop(server);
                    }
                    catch (TunnelType.TunnelException e) {
                        onNonFatalError.accept(e.getMessageText());
                    }
                    try {
                        class_2561 tunnelText = tunnel.start(server);
                        serverValues.setTunnelType(tunnel);
                        serverValues.setTunnelText(tunnelText);
                        if (tunnelText != null) {
                            onSuccess.accept((class_2561)class_2561.method_43469((String)PUBLISH_SAVED_TUNNEL_TEXT, (Object[])new Object[]{class_2564.method_47523((String)String.valueOf(server.method_3756())), tunnelText, motd}));
                            break block23;
                        }
                        onSuccess.accept((class_2561)class_2561.method_43469((String)PUBLISH_SAVED_TEXT, (Object[])new Object[]{class_2564.method_47523((String)String.valueOf(server.method_3756())), motd}));
                    }
                    catch (TunnelType.TunnelException e) {
                        onSuccess.accept((class_2561)class_2561.method_43469((String)PUBLISH_SAVED_TEXT, (Object[])new Object[]{class_2564.method_47523((String)String.valueOf(server.method_3756())), motd}));
                        onNonFatalError.accept(e.getMessageText());
                    }
                } else if (serverValues.getTunnelText() != null) {
                    onSuccess.accept((class_2561)class_2561.method_43469((String)PUBLISH_SAVED_TUNNEL_TEXT, (Object[])new Object[]{class_2564.method_47523((String)String.valueOf(server.method_3756())), serverValues.getTunnelText(), motd}));
                } else {
                    onSuccess.accept((class_2561)class_2561.method_43469((String)PUBLISH_SAVED_TEXT, (Object[])new Object[]{class_2564.method_47523((String)String.valueOf(server.method_3756())), motd}));
                }
            } else {
                block24: {
                    if (server.method_3763(gameMode, false, port)) {
                        server.method_3838(gameMode);
                        try {
                            class_2561 tunnelText = tunnel.start(server);
                            serverValues.setTunnelType(tunnel);
                            serverValues.setTunnelText(tunnelText);
                            if (tunnelText != null) {
                                onSuccess.accept((class_2561)class_2561.method_43469((String)PUBLISH_STARTED_CUSTOMLAN_TUNNEL_TEXT, (Object[])new Object[]{class_2564.method_47523((String)String.valueOf(server.method_3756())), tunnelText, motd}));
                                break block24;
                            }
                            onSuccess.accept((class_2561)class_2561.method_43469((String)PUBLISH_STARTED_CUSTOMLAN_TEXT, (Object[])new Object[]{class_2564.method_47523((String)String.valueOf(server.method_3756())), motd}));
                        }
                        catch (TunnelType.TunnelException e) {
                            onSuccess.accept((class_2561)class_2561.method_43469((String)PUBLISH_STARTED_CUSTOMLAN_TEXT, (Object[])new Object[]{class_2564.method_47523((String)String.valueOf(server.method_3756())), motd}));
                            onNonFatalError.accept(e.getMessageText());
                        }
                    } else {
                        onFatalError.run();
                    }
                }
                class_310.method_1551().method_24288();
            }
        }
    }

    public static void stopLan(MinecraftServer server, Runnable onSuccess, Runnable onFatalError, Consumer<class_2561> onNonFatalError) {
        CustomLanServerValues serverValues = (CustomLanServerValues)server;
        UUID localPlayerUuid = ((IntegratedServerAccessor)server).getLocalPlayerUuid();
        class_3324 playerManager = server.method_3760();
        ArrayList playerList = new ArrayList(playerManager.method_14571());
        for (class_3222 player : playerList) {
            if (player.method_5667().equals(localPlayerUuid)) continue;
            player.field_13987.method_52396(SERVER_STOPPED_TEXT);
        }
        server.method_3787().method_14356();
        ((IntegratedServerAccessor)server).setLanPort(-1);
        ((IntegratedServerAccessor)server).getLanPinger().interrupt();
        onSuccess.run();
        try {
            serverValues.getTunnelType().stop(server);
            serverValues.setTunnelType(TunnelType.NONE);
            serverValues.setTunnelText(null);
        }
        catch (TunnelType.TunnelException e) {
            onNonFatalError.accept(e.getMessageText());
        }
        class_310.method_1551().method_24288();
    }

    public void onInitialize() {
        Thread ngrokInstallThread = new Thread(() -> new NgrokClient.Builder().build());
        ngrokInstallThread.start();
        AutoConfig.register(CustomLanConfig.class, Toml4jConfigSerializer::new);
        CONFIG = AutoConfig.getConfigHolder(CustomLanConfig.class);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            if (environment.field_25422) {
                class_3083.method_13464((CommandDispatcher)dispatcher);
                class_3030.method_13143((CommandDispatcher)dispatcher);
                class_3016.method_13021((CommandDispatcher)dispatcher);
                class_3012.method_13008((CommandDispatcher)dispatcher);
                class_3014.method_13014((CommandDispatcher)dispatcher);
                class_3086.method_13472((CommandDispatcher)dispatcher);
                class_3088.method_13478((CommandDispatcher)dispatcher);
                class_3156.method_13836((CommandDispatcher)dispatcher);
            }
        });
        ArgumentTypeRegistry.registerArgumentType((class_2960)class_2960.method_60655((String)MODID, (String)"tunnel"), TunnelArgumentType.class, (class_2314)class_2319.method_41999(TunnelArgumentType::tunnel));
    }

    static {
        SERVER_STOPPED_TEXT = class_2561.method_43471((String)"multiplayer.disconnect.server_shutdown");
    }
}

