/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import de.maxhenkel.audioplayer.AudioManager;
import de.maxhenkel.audioplayer.AudioPlayer;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;

public class FileNameManager {
    private final File file;
    private final Gson gson;
    private Map<UUID, String> fileNames;
    @Nullable
    private static FileNameManager INSTANCE;

    public FileNameManager(File file) {
        this.file = file;
        this.gson = new GsonBuilder().create();
        this.fileNames = new HashMap<UUID, String>();
        this.load();
    }

    public void load() {
        if (!this.file.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(this.file);){
            Type fileNameMapType = new TypeToken<Map<UUID, String>>(this){}.getType();
            this.fileNames = (Map)this.gson.fromJson((Reader)reader, fileNameMapType);
        }
        catch (Exception e) {
            AudioPlayer.LOGGER.error("Failed to load file name mappings", (Throwable)e);
        }
        if (this.fileNames == null) {
            this.fileNames = new HashMap<UUID, String>();
        }
        this.save();
    }

    public void save() {
        this.file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(this.file);){
            this.gson.toJson(this.fileNames, (Appendable)writer);
        }
        catch (Exception e) {
            AudioPlayer.LOGGER.error("Failed to save file name mappings", (Throwable)e);
        }
    }

    @Nullable
    public String getFileName(UUID audioId) {
        return this.fileNames.get(audioId);
    }

    @Nullable
    public UUID getAudioId(String fileName) {
        UUID id = null;
        for (Map.Entry<UUID, String> entry : this.fileNames.entrySet()) {
            if (!FileNameManager.isNameEqualsWithoutExtension(entry.getValue(), fileName)) continue;
            if (id == null) {
                id = entry.getKey();
                continue;
            }
            return null;
        }
        return id;
    }

    private static boolean isNameEqualsWithoutExtension(String name1, String name2) {
        if (name1 == null || name2 == null) {
            return false;
        }
        return FileNameManager.fileNameWithoutExtension(name1).equals(FileNameManager.fileNameWithoutExtension(name2));
    }

    private static String fileNameWithoutExtension(String name) {
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex < 0) {
            return name;
        }
        return name.substring(0, dotIndex);
    }

    public void addFileName(UUID audioId, @Nullable String fileName) {
        if (fileName == null) {
            return;
        }
        this.fileNames.put(audioId, fileName);
        this.save();
    }

    public void remove(UUID audioId) {
        this.fileNames.remove(audioId);
        this.save();
    }

    @Nullable
    public static String getFileNameFromUrl(String url) {
        String name = url.substring(url.lastIndexOf(47) + 1).trim();
        if (name.isEmpty()) {
            return null;
        }
        return name;
    }

    @Nullable
    public static String getFileNameFromPath(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return null;
        }
        String name = path.getFileName().toString();
        if (name.isEmpty()) {
            return null;
        }
        return name;
    }

    public static void init() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            AudioPlayer.LOGGER.info("Loading audio file name mappings...");
            Path audioDataFolder = AudioManager.getAudioDataFolder(server);
            if (Files.exists(audioDataFolder, new LinkOption[0])) {
                try {
                    Files.createDirectories(audioDataFolder, new FileAttribute[0]);
                }
                catch (IOException e) {
                    AudioPlayer.LOGGER.error("Failed to create audio data folder", (Throwable)e);
                    return;
                }
            }
            INSTANCE = new FileNameManager(audioDataFolder.resolve("file-name-mappings.json").toFile());
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            INSTANCE = null;
        });
    }

    public static Optional<FileNameManager> instance() {
        return Optional.ofNullable(INSTANCE);
    }
}

