/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class AudioCache {
    private final int size;
    private final Map<UUID, short[]> audioCache;
    private final Deque<UUID> accessQueue;

    public AudioCache(int size) {
        this.size = size;
        this.audioCache = new HashMap<UUID, short[]>();
        this.accessQueue = new ArrayDeque<UUID>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short[] get(UUID id, AudioSupplier supplier) throws Exception {
        Map<UUID, short[]> map = this.audioCache;
        synchronized (map) {
            short[] data = this.audioCache.get(id);
            if (data == null) {
                short[] uncachedData = supplier.get();
                this.pushCache(id, uncachedData);
                return uncachedData;
            }
            this.accessQueue.remove(id);
            this.accessQueue.addFirst(id);
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(UUID id) {
        Map<UUID, short[]> map = this.audioCache;
        synchronized (map) {
            this.audioCache.remove(id);
            this.accessQueue.remove(id);
        }
    }

    private void pushCache(UUID id, short[] data) {
        if (this.size <= 0) {
            return;
        }
        if (this.audioCache.containsKey(id)) {
            return;
        }
        if (this.accessQueue.size() >= this.size) {
            UUID leastRecentlyUsed = this.accessQueue.removeLast();
            this.audioCache.remove(leastRecentlyUsed);
        }
        this.accessQueue.addFirst(id);
        this.audioCache.put(id, data);
    }

    public static interface AudioSupplier {
        public short[] get() throws Exception;
    }
}

