/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.entity;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3611;
import net.minecraft.class_3730;
import net.minecraft.class_4174;
import net.minecraft.class_4538;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_6862;
import net.minecraft.class_7;
import net.minecraft.class_8942;
import net.minecraft.class_9334;
import net.untitledduckmod.common.config.UntitledConfig;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.dataticket.DataTicket;
import software.bernie.geckolib.renderer.base.GeoRenderState;

public abstract class WaterfowlEntity
extends class_1321
implements GeoAnimatable {
    protected class_8942 errorReporter;
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final float BABY_MIN_SCALE = 0.25f;
    public static final float BABY_MAX_SCALE = 0.7f;
    public static final String EGG_LAY_TIME_TAG = "EggLayTime";
    public static final String VARIANT_TAG = "Variant";
    public static final String BABY_SCALE_TAG = "BabyScale";
    public static final float SWIM_SPEED_MULTIPLIER = 3.0f;
    public static final DataTicket<Boolean> LOOKING_AROUND_TICKET = DataTicket.create((String)"look_around", Boolean.class);
    public static final DataTicket<Byte> VARIANT_TICKET = DataTicket.create((String)"waterfowl_variant", Byte.class);
    public static final DataTicket<Float> BABY_SCALE_TICKET = DataTicket.create((String)"waterfowl_baby_scale", Float.class);
    protected static final class_2940<Byte> VARIANT = class_2945.method_12791(WaterfowlEntity.class, (class_2941)class_2943.field_13319);
    protected static final class_2940<Float> BABY_SCALE = class_2945.method_12791(WaterfowlEntity.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Byte> ANIMATION = class_2945.method_12791(WaterfowlEntity.class, (class_2941)class_2943.field_13319);
    public static final byte ANIMATION_IDLE = 0;
    public static final byte ANIMATION_CLEAN = 1;
    public static final byte ANIMATION_DANCE = 3;
    public static final byte ANIMATION_PANIC = 4;
    public static final byte ANIMATION_EAT = 5;
    protected static final RawAnimation WALK_ANIM = RawAnimation.begin().thenPlay("walk");
    protected static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenPlay("idle");
    protected static final RawAnimation SWIM_ANIM = RawAnimation.begin().thenPlay("swim");
    protected static final RawAnimation SWIM_IDLE_ANIM = RawAnimation.begin().thenPlay("idle_swim");
    protected static final RawAnimation PANIC_ANIM = RawAnimation.begin().thenPlay("panic");
    protected static final RawAnimation FLY_ANIM = RawAnimation.begin().thenPlay("fly");
    protected static final RawAnimation CLEAN_ANIM = RawAnimation.begin().thenPlay("clean");
    protected static final RawAnimation EAT_ANIM = RawAnimation.begin().thenPlay("eat");
    protected static final RawAnimation SIT_ANIM = RawAnimation.begin().thenPlay("sit");
    private static final int MIN_EGG_LAY_TIME = 6000;
    private static final int MAX_EGG_LAY_TIME = 12000;
    protected int maxVariant = 2;
    protected int eggLayTime = this.getRandomLayTime();
    protected boolean isFlapping;
    protected boolean panicked = false;

    protected WaterfowlEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_18, 0.0f);
        this.errorReporter = new class_8942.class_11340(() -> entityType.method_5897().toString(), LOGGER);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        float babyScale = this.getRandomBabyScale();
        byte variant = this.getRandomVariant();
        if (entityData instanceof GeoRenderState) {
            GeoRenderState geoRenderState = (GeoRenderState)entityData;
            geoRenderState.addGeckolibData(BABY_SCALE_TICKET, (Object)Float.valueOf(babyScale));
            geoRenderState.addGeckolibData(VARIANT_TICKET, (Object)variant);
            geoRenderState.addGeckolibData(LOOKING_AROUND_TICKET, (Object)this.lookingAround());
        }
        this.setVariant(variant);
        this.setBabyScale(babyScale);
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)0);
        builder.method_56912(ANIMATION, (Object)0);
        builder.method_56912(BABY_SCALE, (Object)Float.valueOf(this.getRandomBabyScale()));
    }

    public void method_5652(class_11372 view) {
        super.method_5652(view);
        view.method_71462(VARIANT_TAG, this.getVariant());
        view.method_71465(EGG_LAY_TIME_TAG, this.eggLayTime);
        view.method_71464(BABY_SCALE_TAG, this.getBabyScale());
    }

    public void method_5749(class_11368 view) {
        super.method_5749(view);
        this.setVariant(view.method_71421(VARIANT_TAG, this.getRandomVariant()));
        this.setBabyScale(view.method_71423(BABY_SCALE_TAG, this.getRandomBabyScale()));
        this.eggLayTime = view.method_71424(EGG_LAY_TIME_TAG, this.getRandomLayTime());
    }

    public void method_6173(boolean tamed, boolean updateAttributes) {
        super.method_6173(tamed, updateAttributes);
        if (tamed) {
            Objects.requireNonNull(this.method_5996(class_5134.field_23716)).method_6192(20.0);
            this.method_6033(20.0f);
        } else {
            Objects.requireNonNull(this.method_5996(class_5134.field_23716)).method_6192(7.0);
        }
    }

    public boolean method_5747(double fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    public byte getVariant() {
        return (Byte)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(byte variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    public float getRandomBabyScale() {
        return this.field_5974.method_43057() * 0.45f + 0.25f;
    }

    public float getBabyScale() {
        return ((Float)this.field_6011.method_12789(BABY_SCALE)).floatValue();
    }

    public void setBabyScale(float scale) {
        this.field_6011.method_12778(BABY_SCALE, (Object)Float.valueOf(scale));
    }

    public byte getRandomVariant() {
        return (byte)this.field_5974.method_43048(this.maxVariant);
    }

    public int getRandomLayTime() {
        return this.field_5974.method_43048(6000) + 6000;
    }

    public byte getAnimation() {
        return (Byte)this.field_6011.method_12789(ANIMATION);
    }

    public void setAnimation(byte animation) {
        this.field_6011.method_12778(ANIMATION, (Object)animation);
    }

    public boolean isHungry() {
        return this.method_6032() <= this.method_6063() - 0.5f;
    }

    public void tryEating() {
        assert (!this.method_37908().method_8608());
        class_1799 stack = this.method_6047();
        stack.method_7934(1);
        this.method_5783((class_3414)class_3417.field_20614.comp_349(), 0.5f + 0.5f * (float)this.field_5974.method_43048(2), (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
        if (stack.method_7960()) {
            this.method_6122(class_1268.field_5808, class_1799.field_8037);
        }
        if (this.isHungry()) {
            class_4174 food = (class_4174)stack.method_58694(class_9334.field_50075);
            this.method_6025(food != null ? (float)food.comp_2491() : UntitledConfig.foodHealingValue());
        }
    }

    public boolean lookingAround() {
        return this.getAnimation() != 1 || this.getAnimation() != 5;
    }

    protected abstract class_3414 getLayEggSound();

    public abstract class_1792 getEggItem();

    public void method_6007() {
        super.method_6007();
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            if (this.method_5805() && !this.method_6109() && --this.eggLayTime <= 0) {
                this.method_5783(this.getLayEggSound(), 1.0f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
                this.method_5706(world, (class_1935)this.getEggItem());
                this.eggLayTime = this.getRandomLayTime();
            }
            class_243 velocity = this.method_18798();
            if (!this.method_24828() && velocity.field_1351 < 0.0) {
                this.method_18799(velocity.method_18805(1.0, 0.6, 1.0));
            }
            this.handlePanicAnimation();
        }
        this.isFlapping = this.method_37908().field_9236 && !this.method_5799() && !this.method_24828();
    }

    protected abstract void handlePanicAnimation();

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!(!this.method_37908().field_9236 || this.method_6109() && this.method_6481(stack))) {
            if (this.method_6181() && this.method_6171((class_1309)player)) {
                return class_1269.field_5812;
            }
            return !this.isTamableItem(stack) || !(this.method_6032() < this.method_6063()) && this.method_6181() ? class_1269.field_5811 : class_1269.field_5812;
        }
        if (this.method_6181() && this.method_6171((class_1309)player)) {
            if (this.method_6481(stack) && this.method_6032() < this.method_6063()) {
                class_4174 food = (class_4174)stack.method_58694(class_9334.field_50075);
                this.method_6475(player, hand, stack);
                this.method_6025(food != null ? (float)food.comp_2491() : UntitledConfig.foodHealingValue());
                return class_1269.field_21466;
            }
            class_1269 actionResult = super.method_5992(player, hand);
            if (!actionResult.method_23665() || this.method_6109()) {
                this.method_24346(!this.method_24345());
                this.field_6282 = false;
                this.field_6189.method_6340();
                this.method_5980(null);
            }
            return actionResult;
        }
        if (this.tryTaming(player, stack)) {
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            if (this.field_5974.method_43048(3) == 0) {
                this.method_6170(player);
                this.field_6189.method_6340();
                this.method_5980(null);
                this.method_24346(true);
                this.method_37908().method_8421((class_1297)this, (byte)7);
            } else {
                this.method_37908().method_8421((class_1297)this, (byte)6);
            }
            return class_1269.field_21466;
        }
        return super.method_5992(player, hand);
    }

    protected boolean tryTaming(class_1657 player, class_1799 stack) {
        return this.isTamable(player, stack);
    }

    protected abstract boolean isTamableItem(class_1799 var1);

    protected boolean isTamable(class_1657 player, class_1799 stack) {
        return this.isTamableItem(stack) && !this.method_6181();
    }

    protected void method_6010(class_6862<class_3611> fluid) {
        if (this.method_5942().method_6350()) {
            this.method_18799(this.method_18798().method_1031(0.0, (double)0.04f, 0.0));
        } else {
            this.method_18799(this.method_18798().method_1031(0.0, 0.3, 0.0));
        }
    }

    public boolean method_5957(class_4538 world) {
        return world.method_8606((class_1297)this);
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        this.method_24346(false);
        return super.method_64397(world, source, amount);
    }

    public double getTick(Object o) {
        return this.field_6012;
    }

    public int getEggLayTime() {
        return this.eggLayTime;
    }

    public boolean tamedFollowOwner() {
        return true;
    }
}

