/*
 * Decompiled with CFR 0.152.
 */
package dev.norbiros.emojitype.mixin;

import com.google.common.base.Strings;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.norbiros.emojitype.EmojiType;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2172;
import net.minecraft.class_342;
import net.minecraft.class_4717;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_4717.class})
public abstract class ChatInputSuggestorMixin {
    private static final Pattern COLON_PATTERN = Pattern.compile("(:)");
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+)");
    @Shadow
    @Final
    class_342 field_21599;
    @Shadow
    @Nullable
    private CompletableFuture<Suggestions> field_21611;
    @Shadow
    @Final
    private boolean field_21601;

    @Shadow
    public abstract void method_23920(boolean var1);

    @Inject(method={"refresh"}, at={@At(value="TAIL")}, cancellable=true)
    private void inject(CallbackInfo ci) {
        boolean hasSlash;
        String text = this.field_21599.method_1882();
        StringReader stringReader = new StringReader(text);
        boolean bl = hasSlash = stringReader.canRead() && stringReader.peek() == '/';
        if (hasSlash) {
            stringReader.skip();
        }
        boolean isCommand = this.field_21601 || hasSlash;
        int cursor = this.field_21599.method_1881();
        if (!isCommand) {
            String textUptoCursor = text.substring(0, cursor);
            int start = Math.max(this.getLastPattern(textUptoCursor, COLON_PATTERN) - 1, 0);
            int whitespace = this.getLastPattern(textUptoCursor, WHITESPACE_PATTERN);
            if (start < textUptoCursor.length() && start >= whitespace && textUptoCursor.charAt(start) == ':') {
                this.field_21611 = class_2172.method_9265(EmojiType.emojiCodesCombined, (SuggestionsBuilder)new SuggestionsBuilder(textUptoCursor, start));
                this.field_21611.thenRun(() -> {
                    if (!this.field_21611.isDone()) {
                        return;
                    }
                    this.method_23920(false);
                });
                ci.cancel();
            }
        }
    }

    private int getLastPattern(String input, Pattern pattern) {
        if (Strings.isNullOrEmpty((String)input)) {
            return 0;
        }
        int i = 0;
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            i = matcher.end();
        }
        return i;
    }
}

