/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.worldgen.feature.configurations.TwigletTreeConfiguration;
import biomesoplenty.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.class_10735;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2282;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5281;
import net.minecraft.class_5819;

public class TwigletTreeFeature
extends BOPTreeFeature<TwigletTreeConfiguration> {
    public TwigletTreeFeature(Codec<TwigletTreeConfiguration> codec) {
        super(codec);
    }

    protected boolean method_12775(class_5281 world, class_5819 random, class_2338 startPos, BiConsumer<class_2338, class_2680> roots, BiConsumer<class_2338, class_2680> logs, class_4647.class_8179 leaves, class_4643 configBase) {
        TwigletTreeConfiguration config = (TwigletTreeConfiguration)configBase;
        while (startPos.method_10264() >= world.method_31607() + 1 && startPos.method_10264() <= world.method_31600() - 1 && (world.method_22347(startPos) || world.method_8320(startPos).method_26164(class_3481.field_15503))) {
            startPos = startPos.method_10074();
        }
        if (world.method_8320(startPos).method_26204() == class_2246.field_9987) {
            return false;
        }
        int height = config.minHeight + random.method_43048(1 + config.maxHeight - config.minHeight);
        int baseHeight = height / 3;
        class_2338 pos = startPos.method_10084();
        for (int y = 0; y < height; ++y) {
            float leafChance;
            if (!this.placeLog((class_1936)world, pos.method_10086(y), logs, config)) {
                return true;
            }
            float f = leafChance = (height - y) % 2 == 0 ? config.leafChanceEven : config.leafChanceOdd;
            if (y <= baseHeight) continue;
            if (random.method_43057() < leafChance) {
                this.placeLeaves((class_1936)world, pos.method_10069(1, y, 0), leaves, config);
            }
            if (random.method_43057() < leafChance) {
                this.placeLeaves((class_1936)world, pos.method_10069(-1, y, 0), leaves, config);
            }
            if (random.method_43057() < leafChance) {
                this.placeLeaves((class_1936)world, pos.method_10069(0, y, 1), leaves, config);
            }
            if (random.method_43057() < leafChance) {
                this.placeLeaves((class_1936)world, pos.method_10069(0, y, -1), leaves, config);
            }
            for (class_2350 dir : class_2350.class_2353.field_11062) {
                class_2338 fruitPos = pos.method_10069(dir.method_10148(), y, dir.method_10165());
                class_2680 trunkFruit = config.trunkFruitProvider.method_23455(random, fruitPos);
                if (trunkFruit.method_26204() == class_2246.field_10124 || random.method_43048(4) != 0) continue;
                if (trunkFruit.method_26204() == class_2246.field_10302) {
                    fruitPos = pos.method_10069(dir.method_10153().method_10148(), 0, dir.method_10153().method_10165());
                }
                this.generateTrunkFruit((class_1936)world, random.method_43048(3), fruitPos, dir, config);
            }
        }
        this.placeLeaves((class_1936)world, pos.method_10069(0, height, 0), leaves, config);
        return true;
    }

    private void generateTrunkFruit(class_1936 world, int age, class_2338 pos, class_2350 direction, TwigletTreeConfiguration config) {
        class_2680 trunkFruit = config.trunkFruitProvider.method_23455(world.method_8409(), pos);
        if (trunkFruit == class_2246.field_10302.method_9564()) {
            if (world.method_8320(pos).method_26204() == class_2246.field_10124 || world.method_8320(pos).method_26204() instanceof class_10735) {
                this.method_13153((class_1945)world, pos, (class_2680)((class_2680)trunkFruit.method_11657((class_2769)class_2282.field_10779, (Comparable)Integer.valueOf(age))).method_11657((class_2769)class_2282.field_11177, (Comparable)direction));
            }
        } else if (world.method_8320(pos).method_26204() == class_2246.field_10124 || world.method_8320(pos).method_26204() instanceof class_10735) {
            this.method_13153((class_1945)world, pos, (class_2680)trunkFruit.method_11657((class_2769)class_2282.field_11177, (Comparable)direction));
        }
    }
}

