/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.util.biome.GeneratorUtil;
import biomesoplenty.worldgen.feature.configurations.BayouTreeConfiguration;
import biomesoplenty.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4865;
import net.minecraft.class_5281;
import net.minecraft.class_5819;

public class BayouTreeFeature
extends BOPTreeFeature<BayouTreeConfiguration> {
    public BayouTreeFeature(Codec<BayouTreeConfiguration> codec) {
        super(codec);
    }

    public boolean checkSpace(class_1936 world, class_2338 pos, int baseHeight, int height, BayouTreeConfiguration config) {
        for (int y = 0; y <= height; ++y) {
            int radius = config.trunkWidth - 1;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    class_2338 pos1 = pos.method_10069(x, y, z);
                    if (pos1.method_10264() < 255 && this.canReplace(world, pos1)) continue;
                    return false;
                }
            }
        }
        class_2338 pos2 = pos.method_10069(0, height - 2, 0);
        return BayouTreeFeature.method_16420((class_3746)world, (class_2338)pos2);
    }

    public void generateLeafLayer(class_1936 world, class_5819 rand, class_2338 pos, int leavesRadius, class_4647.class_8179 leaves, BayouTreeConfiguration config) {
        int start = -leavesRadius;
        int end = leavesRadius;
        for (int x = start; x <= end; ++x) {
            for (int z = start; z <= end; ++z) {
                if (leavesRadius > 0 && (x == start || x == end) && (z == start || z == end) || leavesRadius > 0 && (x == start || x == end || z == start || z == end) && rand.method_43058() < 0.2) continue;
                this.placeLeaves(world, pos.method_10069(x, 0, z), leaves, config);
            }
        }
    }

    public void generateBranch(class_1936 world, class_5819 rand, class_2338 pos, class_2350 direction, int length, BiConsumer<class_2338, class_2680> logs, class_4647.class_8179 leaves, BayouTreeConfiguration config) {
        class_2350.class_2351 axis = direction.method_10166();
        class_2350 sideways = direction.method_10170();
        for (int i = 1; i <= length; ++i) {
            class_2338 pos1 = pos.method_10079(direction, i);
            int r = i == 1 || i == length ? 1 : 2;
            for (int j = -r; j <= r; ++j) {
                if (i >= length && rand.method_43048(2) != 0) continue;
                this.placeLeaves(world, pos1.method_10079(sideways, j), leaves, config);
            }
            if (length - i <= 2) continue;
            this.placeLeaves(world, pos1.method_10084(), leaves, config);
            this.placeLeaves(world, pos1.method_10084().method_10079(sideways, -1), leaves, config);
            this.placeLeaves(world, pos1.method_10084().method_10079(sideways, 1), leaves, config);
            this.placeLog(world, pos1, axis, logs, config);
        }
    }

    protected boolean method_12775(class_5281 world, class_5819 random, class_2338 startPos, BiConsumer<class_2338, class_2680> roots, BiConsumer<class_2338, class_2680> logs, class_4647.class_8179 leaves, class_4643 configBase) {
        int leavesHeight;
        BayouTreeConfiguration config = (BayouTreeConfiguration)configBase;
        while (startPos.method_10264() >= world.method_31607() + 1 && this.canReplace((class_1936)world, startPos) || world.method_8320(startPos).method_26164(class_3481.field_15503)) {
            startPos = startPos.method_10074();
        }
        int height = GeneratorUtil.nextIntBetween(random, config.minHeight, config.maxHeight);
        int baseHeight = GeneratorUtil.nextIntBetween(random, (int)((float)height * 0.6f), (int)((float)height * 0.4f));
        int baseLeavesHeight = leavesHeight = height - baseHeight;
        if (leavesHeight < 3) {
            return false;
        }
        leavesHeight = class_3532.method_15340((int)leavesHeight, (int)3, (int)5);
        leavesHeight = class_3532.method_15340((int)(leavesHeight + random.method_43048(3)), (int)0, (int)baseLeavesHeight);
        if (!this.checkSpace((class_1936)world, startPos.method_10084(), baseHeight, height, config)) {
            return false;
        }
        class_2338 pos = startPos.method_10086(height);
        this.placeLeaves((class_1936)world, pos, leaves, config);
        pos.method_10074();
        for (int i = 0; i < leavesHeight; ++i) {
            int radius = 3;
            if (i == 0) {
                radius = 1;
            } else if (i <= 2) {
                radius = 2;
            }
            this.generateLeafLayer((class_1936)world, random, pos, radius, leaves, config);
            pos = pos.method_10074();
        }
        this.placeSpanishMoss((class_1936)world, random, pos);
        int trunkRadius = config.trunkWidth - 1;
        for (int x = -trunkRadius; x <= trunkRadius; ++x) {
            for (int z = -trunkRadius; z <= trunkRadius; ++z) {
                int dist = Math.abs(x) + Math.abs(z);
                if (dist > trunkRadius) continue;
                int heightHere = height - 1;
                if (dist == 1) {
                    heightHere = (int)((double)height * (0.2 + random.method_43058() * 0.15));
                }
                heightHere += random.method_43048(2);
                for (int y = 0; y < heightHere; ++y) {
                    class_2338 local = startPos.method_10069(x, y, z);
                    boolean air = world.method_8320(local).method_26227().method_15769();
                    this.placeLog((class_1936)world, local, logs, config);
                    if (x != 0 || z != 0 || !air || y >= heightHere - leavesHeight + 1) continue;
                    if (y >= baseHeight && random.method_43048(3) == 0) {
                        double theta = Math.PI * random.method_43058() * 2.0;
                        int length = 2 + random.method_43048(3);
                        class_2338 branchPos = null;
                        for (int i = 0; i < length; ++i) {
                            branchPos = local.method_10069(class_3532.method_15357((double)(Math.cos(theta) * (double)i)), i / 2, class_3532.method_15357((double)(Math.sin(theta) * (double)i)));
                            this.placeLog((class_1936)world, branchPos, logs, config);
                        }
                        this.generateLeafLayer((class_1936)world, random, branchPos, 2, leaves, config);
                        this.generateLeafLayer((class_1936)world, random, branchPos.method_10084(), 1, leaves, config);
                        if (random.method_43056()) {
                            this.generateLeafLayer((class_1936)world, random, branchPos.method_10086(2), 0, leaves, config);
                        }
                        this.placeSpanishMoss((class_1936)world, random, branchPos);
                        continue;
                    }
                    if (y < baseHeight || random.method_43048(3) != 0) continue;
                    class_2350 direction = class_2350.class_2353.field_11062.method_10183(random);
                    class_2338 offset = local.method_10093(direction);
                    this.placeLog((class_1936)world, offset, logs, config);
                    for (class_2350 dir : class_2350.values()) {
                        if (!(random.method_43058() > 0.2)) continue;
                        this.placeLeaves((class_1936)world, offset.method_10093(dir), leaves, config);
                    }
                    this.placeSpanishMoss((class_1936)world, random, offset);
                }
            }
        }
        return true;
    }

    private void placeSpanishMoss(class_1936 p_236429_1_, class_5819 p_236429_2_, class_2338 p_236429_3_) {
        class_2338.class_2339 blockpos$mutable = new class_2338.class_2339();
        for (int i = 0; i < 75; ++i) {
            class_2680 blockstate;
            blockpos$mutable.method_25504((class_2382)p_236429_3_, p_236429_2_.method_43048(5) - p_236429_2_.method_43048(5), p_236429_2_.method_43048(3) - p_236429_2_.method_43048(3), p_236429_2_.method_43048(5) - p_236429_2_.method_43048(5));
            if (!p_236429_1_.method_22347((class_2338)blockpos$mutable) || (blockstate = p_236429_1_.method_8320(blockpos$mutable.method_10084())).method_26204() != BOPBlocks.WILLOW_LEAVES) continue;
            int j = class_3532.method_15395((class_5819)p_236429_2_, (int)1, (int)3);
            if (p_236429_2_.method_43048(5) == 0) {
                j = 1;
            }
            BayouTreeFeature.placeSpanishMossColumn(p_236429_1_, p_236429_2_, blockpos$mutable, j, 17, 25);
        }
    }

    public static void placeSpanishMossColumn(class_1936 p_236427_0_, class_5819 p_236427_1_, class_2338.class_2339 p_236427_2_, int p_236427_3_, int p_236427_4_, int p_236427_5_) {
        for (int i = 0; i <= p_236427_3_; ++i) {
            if (p_236427_0_.method_22347((class_2338)p_236427_2_)) {
                if (i == p_236427_3_ || !p_236427_0_.method_22347(p_236427_2_.method_10074())) {
                    p_236427_0_.method_8652((class_2338)p_236427_2_, (class_2680)BOPBlocks.SPANISH_MOSS.method_9564().method_11657((class_2769)class_4865.field_22509, (Comparable)Integer.valueOf(class_3532.method_15395((class_5819)p_236427_1_, (int)p_236427_4_, (int)p_236427_5_))), 2);
                    break;
                }
                p_236427_0_.method_8652((class_2338)p_236427_2_, BOPBlocks.SPANISH_MOSS_PLANT.method_9564(), 2);
            }
            p_236427_2_.method_10098(class_2350.field_11033);
        }
    }

    @Override
    public boolean placeLeaves(class_1936 level, class_2338 pos, class_4647.class_8179 leaves, BayouTreeConfiguration config) {
        if (BayouTreeFeature.method_16420((class_3746)level, (class_2338)pos)) {
            leaves.method_49240(pos, config.field_29280.method_23455(level.method_8409(), pos));
            return true;
        }
        if (level.method_8320(pos).method_26227().method_39360((class_3611)class_3612.field_15910)) {
            leaves.method_49240(pos, (class_2680)config.field_29280.method_23455(level.method_8409(), pos).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(level.method_22351(pos))));
            return true;
        }
        return false;
    }

    @Override
    protected boolean canReplace(class_1936 level, class_2338 pos) {
        return super.canReplace(level, pos) || level.method_16358(pos, state -> state.method_51176());
    }
}

