/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.registry;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.registry.RegistryUtil;
import com.supermartijn642.core.util.Either;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2405;
import org.jetbrains.annotations.ApiStatus;

public class GeneratorRegistrationHandler {
    private static final Map<String, GeneratorRegistrationHandler> REGISTRATION_HELPER_MAP = new HashMap<String, GeneratorRegistrationHandler>();
    private static boolean haveProvidersBeenRegistered = false;
    private final String modid;
    private final List<Either<Function<ResourceCache, ResourceGenerator>, Function<FabricDataOutput, class_2405>>> generatorsAndProviders = new ArrayList<Either<Function<ResourceCache, ResourceGenerator>, Function<FabricDataOutput, class_2405>>>();

    @Deprecated
    @ApiStatus.Internal
    public static Map<String, GeneratorRegistrationHandler> getAllHandlers() {
        haveProvidersBeenRegistered = true;
        return Collections.unmodifiableMap(REGISTRATION_HELPER_MAP);
    }

    public static synchronized GeneratorRegistrationHandler get(String modid) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        if (modid.equals("minecraft")) {
            CoreLib.LOGGER.warn("Mod is requesting registration helper for modid '" + modid + "'!");
        } else {
            ModContainer container = FabricLoader.getInstance().getModContainer(modid).orElse(null);
            if (container == null) {
                CoreLib.LOGGER.warn("Mod is requesting registration helper for unknown modid '" + modid + "'!");
            }
        }
        return REGISTRATION_HELPER_MAP.computeIfAbsent(modid, GeneratorRegistrationHandler::new);
    }

    private GeneratorRegistrationHandler(String modid) {
        this.modid = modid;
    }

    public void addGenerator(Function<ResourceCache, ResourceGenerator> generator) {
        if (generator == null) {
            throw new IllegalArgumentException("Generator must not be null!");
        }
        if (haveProvidersBeenRegistered) {
            throw new RuntimeException("Generators supplier must be added before the GatherDataEvent gets fired!");
        }
        this.generatorsAndProviders.add(Either.left(generator));
    }

    public void addGenerator(Supplier<ResourceGenerator> generator) {
        if (generator == null) {
            throw new IllegalArgumentException("Generator supplier must not be null!");
        }
        this.addGenerator((ResourceCache cache) -> (ResourceGenerator)generator.get());
    }

    public void addGenerator(ResourceGenerator generator) {
        if (generator == null) {
            throw new IllegalArgumentException("Generator must not be null!");
        }
        this.addGenerator((ResourceCache cache) -> generator);
    }

    public void addProvider(Function<FabricDataOutput, class_2405> provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Provider must not be null!");
        }
        if (haveProvidersBeenRegistered) {
            throw new RuntimeException("Providers supplier must be added before the GatherDataEvent gets fired!");
        }
        this.generatorsAndProviders.add(Either.right(provider));
    }

    public void addProvider(Supplier<class_2405> provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Provider must not be null!");
        }
        this.addProvider((FabricDataOutput dataGenerator) -> (class_2405)provider.get());
    }

    public void addProvider(class_2405 provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Provider must not be null!");
        }
        this.addProvider((FabricDataOutput dataGenerator) -> provider);
    }

    @Deprecated
    @ApiStatus.Internal
    public void registerProviders(FabricDataGenerator dataGenerator, ResourceCache cache) {
        FabricDataGenerator.Pack pack = dataGenerator.createPack();
        this.generatorsAndProviders.stream().map(either -> either.mapLeft(generator -> (ResourceGenerator)generator.apply(cache))).map(either -> either.mapLeft(ResourceGenerator::createDataProvider)).map(either -> either.mapLeft(provider -> output -> provider)).map(either -> either.mapRight(provider -> provider::apply)).map(either -> either.leftOrElseGet(either::right)).forEach(arg_0 -> ((FabricDataGenerator.Pack)pack).addProvider(arg_0));
    }
}

