/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.registry.Registries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_10396;
import net.minecraft.class_10398;
import net.minecraft.class_10400;
import net.minecraft.class_10401;
import net.minecraft.class_10430;
import net.minecraft.class_10434;
import net.minecraft.class_10435;
import net.minecraft.class_10439;
import net.minecraft.class_10455;
import net.minecraft.class_10515;
import net.minecraft.class_10544;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_6903;
import net.minecraft.class_9848;

public abstract class ItemInfoGenerator
extends ResourceGenerator {
    private final Map<class_2960, ItemInfoBuilder> infos = new HashMap<class_2960, ItemInfoBuilder>();

    public ItemInfoGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    @Override
    public void save() {
        class_6903 ops = ResourceGenerator.registryAccess.method_57093((DynamicOps)JsonOps.INSTANCE);
        for (ItemInfoBuilder builder : this.infos.values()) {
            JsonObject json = ((JsonElement)class_10434.field_55327.encodeStart((DynamicOps)ops, (Object)builder.toClientItem()).getOrThrow()).getAsJsonObject();
            class_2960 identifier = builder.location;
            this.cache.saveJsonResource(ResourceType.ASSET, json, identifier.method_12836(), "items", identifier.method_12832());
        }
    }

    protected ItemInfoBuilder info(class_2960 item) {
        return this.infos.computeIfAbsent(item, ItemInfoBuilder::new);
    }

    protected ItemInfoBuilder info(String namespace, String identifier) {
        return this.info(class_2960.method_60655((String)namespace, (String)identifier));
    }

    protected ItemInfoBuilder info(String identifier) {
        return this.info(this.modid, identifier);
    }

    protected ItemInfoBuilder info(class_1935 item) {
        return this.info(Registries.ITEMS.getIdentifier(item.method_8389()));
    }

    protected ItemInfoBuilder simpleInfo(class_1935 item, String model) {
        return this.info(item).model(this.model(model));
    }

    protected ModelModelBuilder model(class_2960 location) {
        return new ModelModelBuilder(location);
    }

    protected ModelModelBuilder model(String namespace, String path) {
        return this.model(class_2960.method_60655((String)namespace, (String)path));
    }

    protected ModelModelBuilder model(String location) {
        return this.model(this.modid, location);
    }

    protected CompositeModelBuilder compositeModel() {
        return new CompositeModelBuilder();
    }

    protected ModelBuilder emptyModel() {
        return ModelBuilder.of(new class_10544.class_10545());
    }

    protected ModelBuilder specialModel(class_10515.class_10516 specialModel, class_2960 baseModel) {
        return ModelBuilder.of(new class_10455.class_10456(baseModel, specialModel));
    }

    @Override
    public String getName() {
        return this.modName + " Item Info Generator";
    }

    protected static class ItemInfoBuilder {
        private final class_2960 location;
        private boolean handAnimationOnSwap = true;
        private boolean oversizedInGui = false;
        private ModelBuilder model;

        protected ItemInfoBuilder(class_2960 location) {
            this.location = location;
        }

        public ItemInfoBuilder noHandAnimationOnSwap() {
            this.handAnimationOnSwap = false;
            return this;
        }

        public ItemInfoBuilder oversizedInGui() {
            this.oversizedInGui = true;
            return this;
        }

        public ItemInfoBuilder model(ModelBuilder model) {
            this.model = model;
            return this;
        }

        public ItemInfoBuilder model(class_10439.class_10441 model) {
            return this.model(ModelBuilder.of(model));
        }

        private class_10434 toClientItem() {
            class_10544.class_10545 model = this.model == null ? new class_10544.class_10545() : this.model.toItemModel();
            return new class_10434((class_10439.class_10441)model, new class_10434.class_10543(this.handAnimationOnSwap, this.oversizedInGui));
        }
    }

    protected static class ModelModelBuilder
    extends ModelBuilder {
        private final class_2960 model;
        private final List<class_10401> tintSources = new ArrayList<class_10401>();

        protected ModelModelBuilder(class_2960 model) {
            this.model = model;
        }

        @Override
        protected class_10439.class_10441 toItemModel() {
            return new class_10430.class_10431(this.model, this.tintSources);
        }

        public ModelModelBuilder addTintSource(class_10401 tintSource) {
            this.tintSources.add(tintSource);
            return this;
        }

        public ModelModelBuilder addConstantTint(int rgb) {
            return this.addTintSource((class_10401)new class_10396(rgb));
        }

        public ModelModelBuilder addConstantTint(float red, float green, float blue) {
            if (red < 0.0f || red > 1.0f || green < 0.0f || green > 1.0f || blue < 0.0f || blue > 1.0f) {
                throw new IllegalArgumentException("Color component values must be between 0 and 1!");
            }
            return this.addTintSource((class_10401)new class_10396(class_9848.method_61318((float)1.0f, (float)red, (float)green, (float)blue)));
        }

        public ModelModelBuilder addDyeComponentTint(int defaultColor) {
            return this.addTintSource((class_10401)new class_10398(defaultColor));
        }

        public ModelModelBuilder addGrassTint(float temperature, float downfall) {
            if (temperature < 0.0f || temperature > 1.0f) {
                throw new IllegalArgumentException("Temperature must be between 0 and 1!");
            }
            if (downfall < 0.0f || downfall > 1.0f) {
                throw new IllegalArgumentException("Downfall must be between 0 and 1!");
            }
            return this.addTintSource((class_10401)new class_10400(temperature, downfall));
        }
    }

    protected static abstract class ModelBuilder {
        private ModelBuilder() {
        }

        abstract class_10439.class_10441 toItemModel();

        private static ModelBuilder of(final Object model) {
            if (!(model instanceof class_10439.class_10441)) {
                throw new IllegalArgumentException("Model must be an instance of " + class_10439.class_10441.class.getName());
            }
            return new ModelBuilder(){

                @Override
                class_10439.class_10441 toItemModel() {
                    return (class_10439.class_10441)model;
                }
            };
        }
    }

    protected static class CompositeModelBuilder
    extends ModelBuilder {
        private final List<ModelBuilder> models = new ArrayList<ModelBuilder>();

        protected CompositeModelBuilder() {
        }

        @Override
        protected class_10439.class_10441 toItemModel() {
            return new class_10435.class_10436(this.models.stream().map(ModelBuilder::toItemModel).toList());
        }

        public CompositeModelBuilder addModel(ModelBuilder model) {
            this.models.add(model);
            return this;
        }

        public CompositeModelBuilder addModel(class_10439.class_10441 model) {
            return this.addModel(ModelBuilder.of(model));
        }
    }
}

