/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.registry.Registries;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_10162;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.class_8942;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.ApiStatus;

public class BaseBlock
extends class_2248 {
    private static final ThreadLocal<class_10162<class_2248, Optional<class_5321<class_52>>>> LAST_REMOVED_DROPS = new ThreadLocal();
    public static final class_9331<class_2487> TILE_DATA = class_9331.method_57873().method_57881(class_2487.field_25128).method_57880();
    private final boolean saveTileData;
    private final BlockProperties properties;
    private final class_10162<class_2248, Optional<class_5321<class_52>>> vanillaDrops;
    private boolean resolvedDrops;
    private boolean resolvedRegistryDependencies;

    private BaseBlock(boolean saveTileData, class_4970.class_2251 properties, BlockProperties blockProperties) {
        super(BaseBlock.removeDescriptionAndDropsFromProperties(properties));
        this.saveTileData = saveTileData;
        this.properties = blockProperties;
        this.vanillaDrops = LAST_REMOVED_DROPS.get();
        LAST_REMOVED_DROPS.remove();
    }

    public BaseBlock(boolean saveTileData, class_4970.class_2251 properties) {
        this(saveTileData, properties, null);
    }

    public BaseBlock(boolean saveTileData, BlockProperties properties) {
        this(saveTileData, properties.toUnderlying(), properties);
    }

    private static class_4970.class_2251 removeDescriptionAndDropsFromProperties(class_4970.class_2251 properties) {
        LAST_REMOVED_DROPS.set((class_10162<class_2248, Optional<class_5321<class_52>>>)properties.field_54007);
        return properties.method_63501("").method_42327().method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"supermartijn642corelib", (String)"dummy")));
    }

    @ApiStatus.Internal
    public void resolveRegistryDependencies() {
        if (!this.resolvedDrops) {
            this.method_26162();
        }
        if (!this.resolvedRegistryDependencies) {
            class_2960 identifier = Registries.BLOCKS.getIdentifier(this);
            this.field_54005 = identifier.method_12836() + ".block." + identifier.method_12832();
            this.resolvedRegistryDependencies = true;
        }
    }

    public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        if (!this.saveTileData) {
            return;
        }
        if (!stack.method_57826(TILE_DATA)) {
            return;
        }
        class_2487 tag = (class_2487)stack.method_58694(TILE_DATA);
        if (tag == null || tag.method_33133()) {
            return;
        }
        class_2586 entity = worldIn.method_8321(pos);
        if (entity instanceof BaseBlockEntity) {
            ((BaseBlockEntity)entity).readData(class_11352.method_71417((class_8942)new class_8942.class_11340(entity.method_71402(), CoreLib.LOGGER), (class_7225.class_7874)worldIn.method_30349(), (class_2487)tag));
        }
    }

    public Optional<class_5321<class_52>> method_26162() {
        if (!this.resolvedDrops) {
            if (this.properties != null) {
                if (this.properties.noLootTable) {
                    this.field_23156 = Optional.empty();
                } else if (this.properties.lootTable != null) {
                    class_2960 identifier = Registries.BLOCKS.getIdentifier(this);
                    class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)identifier);
                    this.field_23156 = this.properties.lootTable.apply((class_5321<class_2248>)key);
                } else if (this.properties.lootTableBlock != null) {
                    class_2248 block = this.properties.lootTableBlock.get();
                    if (block == null) {
                        CoreLib.LOGGER.warn("Received null block from BlockProperties#lootTableFrom's supplier for block '{}'!", (Object)Registries.BLOCKS.getIdentifier(this));
                        this.field_23156 = Optional.empty();
                    } else {
                        this.field_23156 = block.method_26162();
                    }
                } else {
                    this.field_23156 = Optional.of(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)Registries.BLOCKS.getIdentifier(this).method_45138("blocks/")));
                }
            } else {
                class_2960 identifier = Registries.BLOCKS.getIdentifier(this);
                class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)identifier);
                this.field_23156 = (Optional)this.vanillaDrops.get(key);
            }
            this.resolvedDrops = true;
        }
        return this.field_23156;
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        List items = super.method_9560(state, builder);
        if (!this.saveTileData) {
            return items;
        }
        class_2586 entity = (class_2586)builder.method_51876(class_181.field_1228);
        if (!(entity instanceof BaseBlockEntity)) {
            return items;
        }
        class_11362 output = class_11362.method_71459((class_8942)new class_8942.class_11340(entity.method_71402(), CoreLib.LOGGER), (class_7225.class_7874)entity.method_10997().method_30349());
        ((BaseBlockEntity)entity).writeItemStackData((class_11372)output);
        if (output.method_71457()) {
            return items;
        }
        class_2487 entityTag = output.method_71475();
        for (class_1799 stack : items) {
            if (!(stack.method_7909() instanceof class_1747) || ((class_1747)stack.method_7909()).method_7711() != this) continue;
            stack.method_57379(TILE_DATA, (Object)entityTag);
        }
        return items;
    }

    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        class_1799 stack = super.method_9574(world, pos, state, includeData);
        if (!this.saveTileData) {
            return stack;
        }
        class_2586 entity = world.method_8321(pos);
        if (!(entity instanceof BaseBlockEntity)) {
            return stack;
        }
        class_11362 output = class_11362.method_71459((class_8942)new class_8942.class_11340(entity.method_71402(), CoreLib.LOGGER), (class_7225.class_7874)world.method_30349());
        ((BaseBlockEntity)entity).writeItemStackData((class_11372)output);
        if (output.method_71457()) {
            return stack;
        }
        class_2487 entityTag = output.method_71475();
        if (stack.method_7909() instanceof class_1747 && ((class_1747)stack.method_7909()).method_7711() == this) {
            stack.method_57381(class_9334.field_49611);
            stack.method_57379(TILE_DATA, (Object)entityTag);
        }
        return stack;
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        return this.interact((class_2680)state, (class_1937)level, (class_2338)pos, (class_1657)player, (class_1268)hand, (class_2350)hitResult.method_17780(), (class_243)hitResult.method_17784()).interactionResult;
    }

    protected InteractionFeedback interact(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_2350 hitSide, class_243 hitLocation) {
        return InteractionFeedback.PASS;
    }

    public void appendItemInformation(class_1799 stack, Consumer<class_2561> info, boolean advanced) {
    }

    public class_1792 method_8389() {
        return super.method_8389();
    }

    public String method_63499() {
        this.resolveRegistryDependencies();
        return super.method_63499();
    }

    protected static enum InteractionFeedback {
        PASS((class_1269)class_1269.field_5811),
        CONSUME((class_1269)class_1269.field_21466),
        SUCCESS((class_1269)class_1269.field_5812);

        private final class_1269 interactionResult;

        private InteractionFeedback(class_1269 interactionResult) {
            this.interactionResult = interactionResult;
        }
    }
}

