/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.symbolchat.resource;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_437;
import net.minecraft.class_7654;
import net.replaceitem.symbolchat.SymbolChat;
import net.replaceitem.symbolchat.extensions.ScreenAccess;
import net.replaceitem.symbolchat.resource.FontProcessor;
import net.replaceitem.symbolchat.resource.MappedFontProcessor;
import org.jetbrains.annotations.NotNull;

public class FontManager
implements SimpleSynchronousResourceReloadListener {
    public static final class_2960 IDENTIFIER = class_2960.method_60655((String)"symbol-chat", (String)"fonts");
    public static final class_7654 FONT_FINDER = new class_7654("symbol_fonts", ".json");
    private FontProcessor normal;
    private List<FontProcessor> fonts = List.of();

    public class_2960 getFabricId() {
        return IDENTIFIER;
    }

    public void method_14491(class_3300 manager) {
        this.normal = new FontProcessor(class_2960.method_60655((String)"symbol-chat", (String)"normal"), Function.identity(), Integer.MIN_VALUE, false);
        this.fonts = new ArrayList<FontProcessor>();
        this.fonts.add(this.normal);
        for (Map.Entry identifierResourceEntry : FONT_FINDER.method_45113(manager).entrySet()) {
            class_2960 identifier = FONT_FINDER.method_45115((class_2960)identifierResourceEntry.getKey());
            class_3298 resource = (class_3298)identifierResourceEntry.getValue();
            try {
                BufferedReader reader = resource.method_43039();
                try {
                    FontProcessor font = this.readFont(reader, identifier);
                    this.fonts.add(font);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (JsonParseException | IOException e) {
                SymbolChat.LOGGER.error("Could not load symbol tab {}", (Object)identifier, (Object)e);
            }
        }
        this.fonts.sort(Comparator.comparingInt(value -> value.order));
        this.fonts = Collections.unmodifiableList(this.fonts);
    }

    private FontProcessor readFont(BufferedReader reader, class_2960 identifier) throws JsonParseException {
        JsonObject object = class_3518.method_15255((Reader)reader);
        String type = class_3518.method_15253((JsonObject)object, (String)"type", (String)"mapped");
        int order = class_3518.method_15282((JsonObject)object, (String)"order", (int)Integer.MAX_VALUE);
        boolean reverseDirection = class_3518.method_15258((JsonObject)object, (String)"reverse_direction", (boolean)false);
        if (type.equals("mapped")) {
            return MappedFontProcessor.read(identifier, object, order, reverseDirection);
        }
        throw new JsonSyntaxException("Invalid font type: " + type);
    }

    public FontProcessor getNormal() {
        return this.normal;
    }

    public List<FontProcessor> getFontProcessors() {
        return this.fonts;
    }

    @NotNull
    public FontProcessor getCurrentScreenFontProcessor() {
        class_437 screen = class_310.method_1551().field_1755;
        if (!(screen instanceof ScreenAccess)) {
            return this.normal;
        }
        ScreenAccess screenAccess = (ScreenAccess)screen;
        return screenAccess.getFontProcessor();
    }
}

