/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.symbolchat.gui.widget;

import com.ibm.icu.lang.UCharacter;
import java.util.List;
import java.util.Set;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import net.minecraft.class_9848;
import net.replaceitem.symbolchat.SymbolChat;
import net.replaceitem.symbolchat.Util;
import net.replaceitem.symbolchat.extensions.TextRendererAccess;
import net.replaceitem.symbolchat.gui.container.NonScrollableContainerWidget;
import net.replaceitem.symbolchat.gui.widget.symbolButton.PasteSymbolButtonWidget;

public class UnicodeTable
extends NonScrollableContainerWidget
implements PasteSymbolButtonWidget.Context {
    private final class_327 textRenderer;
    private class_2583 style = class_2583.field_24360;
    private boolean renderTextShadow;
    private boolean showBlocks;
    private static final int SCROLLBAR_WIDTH = 6;
    private double scroll;
    private boolean scrolling;
    private int maxScroll;
    private final int scrollbarX;
    private int scrollbarY;
    private int scrollbarHeight;
    private final int columns;
    private final int visibleRows;
    private int totalRows;
    private int selectionStart = -1;
    private int selectionEnd = -1;
    private int[] codepoints;
    private static final class_2960 SCROLLER_TEXTURE = class_2960.method_60656((String)"widget/scroller");
    private static final class_2960 SCROLLER_BACKGROUND_TEXTURE = class_2960.method_60656((String)"widget/scroller_background");
    private static final int[] CYCLING_BLOCK_COLORS = new int[]{-8388608, -8355840, -16744448, -16744320, -16777088, -8388480};

    public UnicodeTable(class_327 textRenderer, int x, int y, int width, int height) {
        super(x, y, width, height);
        this.textRenderer = textRenderer;
        this.scrollbarX = this.method_46426() + width - 6;
        this.columns = Math.floorDiv(this.field_22758 - 1 - 6, 13);
        this.visibleRows = Math.floorDiv(this.field_22759 - 1, 13);
        this.setCodepoints(new int[0]);
        this.refresh();
    }

    private void calculateScrollbarPos() {
        this.maxScroll = Math.max(this.totalRows, this.visibleRows) - this.visibleRows;
        double visibleRatio = this.totalRows > 0 ? Math.min((double)this.visibleRows / (double)this.totalRows, 1.0) : 1.0;
        this.scrollbarHeight = Math.max((int)(visibleRatio * (double)this.field_22759), 16);
        this.scrollbarY = (int)class_3532.method_32854((double)this.scroll, (double)0.0, (double)this.maxScroll, (double)0.0, (double)(this.field_22759 - this.scrollbarHeight));
        this.setScroll(this.scroll);
    }

    @Override
    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        this.drawBackground(context);
        super.method_48579(context, mouseX, mouseY, delta);
        if (this.scrollbarHeight != this.method_25364()) {
            context.method_52706(class_10799.field_56883, SCROLLER_BACKGROUND_TEXTURE, this.scrollbarX, this.method_46427(), 6, this.method_25364());
            context.method_52706(class_10799.field_56883, SCROLLER_TEXTURE, this.scrollbarX, this.scrollbarY, 6, this.scrollbarHeight);
        }
    }

    private void drawBackground(class_332 context) {
        int lineWidth;
        int leftSymbols;
        int i;
        int partialRowSymbolCount;
        int color = (Integer)SymbolChat.config.buttonColor.get();
        int alpha = class_9848.method_61320((int)color);
        color = class_9848.method_61322((int)color, (int)class_9848.method_61324((int)255, (int)alpha, (int)alpha, (int)alpha));
        color = class_9848.method_61334((int)color);
        int visibleSymbols = this.codepoints.length - this.getScrolledRows() * this.columns;
        int fullRowsCount = Math.floorDiv(visibleSymbols, this.columns);
        int partialRowsCount = Math.ceilDiv(visibleSymbols, this.columns);
        int firstRowCount = Math.min(visibleSymbols, this.columns);
        if (fullRowsCount != 0 && firstRowCount != 0) {
            context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + firstRowCount * 13, this.method_46427() + fullRowsCount * 13, color);
        }
        if (partialRowsCount != fullRowsCount && (partialRowSymbolCount = visibleSymbols % this.columns) != 0 && partialRowsCount != 0) {
            context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + partialRowSymbolCount * 13, this.method_46427() + partialRowsCount * 13, color);
        }
        for (i = 0; i <= this.columns && (leftSymbols = visibleSymbols - i) >= 0; ++i) {
            int lineHeight = class_3532.method_15340((int)(class_3532.method_38788((int)(leftSymbols + 1), (int)this.columns) * 13 + 1), (int)0, (int)this.field_22759);
            context.method_51742(this.method_46426() + i * 13, this.method_46427() - 1, this.method_46427() + lineHeight, -13619152);
        }
        for (i = 0; i <= this.visibleRows && (lineWidth = Math.min(leftSymbols = visibleSymbols - Math.max(i - 1, 0) * this.columns, this.columns) * 13) > 0; ++i) {
            context.method_51738(this.method_46426(), this.method_46426() + lineWidth - 1, this.method_46427() + i * 13, -13619152);
        }
    }

    public void setRenderTextShadow(boolean renderTextShadow) {
        this.renderTextShadow = renderTextShadow;
    }

    public void setShowBlocks(boolean showBlocks) {
        this.showBlocks = showBlocks;
    }

    @Override
    public void onSymbolClicked(String symbol) {
        this.refresh();
    }

    @Override
    public void refresh() {
        this.calculateScrollbarPos();
        this.refreshButtons();
    }

    public void setFont(class_2960 value) {
        this.style = class_2583.field_24360.method_27704(value);
    }

    public class_2583 getStyle() {
        return this.style;
    }

    public void setCodepoints(int[] codepoints) {
        this.codepoints = codepoints;
        int blockCycleColorIndex = CYCLING_BLOCK_COLORS.length - 1;
        int currentBlockIndex = -1;
        int i = 0;
        while (i < codepoints.length) {
            int newBlockIndex = UCharacter.getIntPropertyValue((int)codepoints[i], (int)4097);
            if (newBlockIndex != currentBlockIndex) {
                blockCycleColorIndex = (blockCycleColorIndex + 1) % CYCLING_BLOCK_COLORS.length;
                currentBlockIndex = newBlockIndex;
            }
            int n = i++;
            codepoints[n] = codepoints[n] | blockCycleColorIndex << 24;
        }
        this.totalRows = class_3532.method_38788((int)codepoints.length, (int)this.columns);
        this.refresh();
    }

    private void refreshButtons() {
        this.clearElements();
        int codepointIndex = this.getScrolledRows() * this.columns;
        IntUnaryOperator widthGetter = ((TextRendererAccess)this.textRenderer).getCodepointWidthGetter(this.style);
        IntPredicate missingGlyphPredicate = ((TextRendererAccess)this.textRenderer).getMissingGlyphPredicate(this.style);
        for (int widgetIndex = 0; codepointIndex < this.codepoints.length && widgetIndex < this.columns * this.visibleRows; ++codepointIndex, ++widgetIndex) {
            int value = this.codepoints[codepointIndex];
            int codePoint = value & 0xFFFFFF;
            int blockColor = CYCLING_BLOCK_COLORS[(value & 0xFF000000) >> 24];
            String symbol = Util.stringFromCodePoint(codePoint);
            UCharacter.UnicodeBlock block = UCharacter.UnicodeBlock.of((int)codePoint);
            class_5250 tooltipText = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)Integer.toHexString(codePoint))).method_27693("\n\n" + Util.getPrettySymbolName(codePoint) + "\n").method_10852((class_2561)class_2561.method_43469((String)"symbolchat.unicode_table.symbol_tooltip.width", (Object[])new Object[]{widthGetter.applyAsInt(codePoint)})).method_27693("\n").method_10852((class_2561)(block == null ? class_2561.method_43471((String)"symbolchat.unicode_table.symbol_tooltip.unknown_block").method_27694(style -> style.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(true))) : class_2561.method_43470((String)block.toString()).method_27694(style -> style.method_36139(blockColor))));
            class_7919 tooltip = class_7919.method_47407((class_2561)tooltipText);
            int x = widgetIndex % this.columns * 13 + 1;
            int y = widgetIndex / this.columns * 13 + 1;
            TableButton button = new TableButton(this.method_46426() + x, this.method_46427() + y, this, symbol, tooltip, codepointIndex, blockColor, missingGlyphPredicate.test(codePoint));
            this.addChildren(button);
        }
        this.onRefreshed();
    }

    protected void onRefreshed() {
    }

    private void setScroll(double scroll) {
        this.scroll = class_3532.method_15350((double)scroll, (double)0.0, (double)this.maxScroll);
    }

    private int getScrolledRows() {
        return (int)this.scroll;
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        this.setScroll(this.scroll - verticalAmount * (double)(class_437.method_25441() ? this.visibleRows : 1));
        this.refresh();
        return true;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (mouseX >= (double)this.scrollbarX && mouseX < (double)(this.scrollbarX + 6) && mouseY >= (double)this.scrollbarY && mouseY < (double)(this.scrollbarY + this.scrollbarHeight)) {
            this.scrolling = button == 0;
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (super.method_25406(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0) {
            this.scrolling = false;
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.method_46427()) {
                this.scroll = 0.0;
            } else if (mouseY > (double)this.method_55443()) {
                this.scroll = this.maxScroll;
            } else {
                double scrolledRows = (int)class_3532.method_33722((double)deltaY, (double)0.0, (double)(this.field_22759 - this.scrollbarHeight), (double)0.0, (double)this.maxScroll);
                this.setScroll(this.scroll + scrolledRows);
            }
            this.refresh();
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (class_437.method_25438((int)keyCode) && this.selectionStart != -1) {
            this.copySelected();
            return true;
        }
        if (keyCode == 256 && this.selectionStart != -1) {
            this.selectionStart = -1;
            this.selectionEnd = -1;
            this.refresh();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void copySelected() {
        if (!this.hasSelection()) {
            return;
        }
        class_310.method_1551().field_1774.method_1455(Util.stringFromCodePoints(this.getSelectedSymbols()));
    }

    public void favoriteSymbols() {
        if (!this.hasSelection()) {
            return;
        }
        IntStream selectedSymbols = this.getSelectedSymbols();
        Stream<String> current = ((String)SymbolChat.config.favoriteSymbols.get()).codePoints().mapToObj(UCharacter::toString);
        List<String> toToggle = selectedSymbols.mapToObj(UCharacter::toString).toList();
        Set forRemoval = toToggle.stream().filter(value -> SymbolChat.symbolManager.isFavorite((String)value)).collect(Collectors.toUnmodifiableSet());
        current = Stream.concat(current.filter(k -> !forRemoval.contains(k)), toToggle.stream().filter(value -> !SymbolChat.symbolManager.isFavorite((String)value)));
        SymbolChat.config.favoriteSymbols.set((Object)current.collect(Collectors.joining()));
        this.refresh();
    }

    public IntStream getSelectedSymbols() {
        IntStream.Builder intStreamBuilder = IntStream.builder();
        for (int i = this.selectionStart; i <= this.selectionEnd; ++i) {
            int codepoint = this.codepoints[i];
            intStreamBuilder.add(codepoint & 0xFFFFFF);
        }
        return intStreamBuilder.build();
    }

    public boolean hasSelection() {
        return this.selectionStart != -1;
    }

    public void jumpTo(int codepoint) {
        int index = UnicodeTable.binarySearchCodepoints(this.codepoints, codepoint);
        if (index < 0) {
            return;
        }
        this.setScroll((double)Math.floorDiv(index, this.columns) - (double)this.visibleRows / 2.0);
        this.selectionEnd = index;
        this.selectionStart = index;
        this.refresh();
    }

    private static int binarySearchCodepoints(int[] arr, int key) {
        int low = 0;
        int high = arr.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = arr[mid] & 0xFFFFFF;
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    private class TableButton
    extends PasteSymbolButtonWidget {
        private final int index;
        private final boolean marked;
        private final int blockColor;
        private final boolean missing;

        public TableButton(int x, int y, PasteSymbolButtonWidget.Context context, String symbol, class_7919 tooltip, int index, int blockColor, boolean missing) {
            super(x, y, context, symbol, tooltip);
            this.index = index;
            this.marked = index >= UnicodeTable.this.selectionStart && index <= UnicodeTable.this.selectionEnd;
            this.blockColor = blockColor;
            this.missing = missing;
            this.method_25355((class_2561)(missing ? class_2561.method_43473() : class_2561.method_43470((String)symbol).method_10862(UnicodeTable.this.style)));
        }

        @Override
        protected int getBackgroundColor() {
            return this.method_49606() ? (UnicodeTable.this.showBlocks ? this.blockColor : (Integer)SymbolChat.config.buttonActiveColor.get()) : class_9848.method_61321((int)this.blockColor, (float)0.5f);
        }

        @Override
        protected void renderOverlay(class_332 drawContext) {
            if (this.missing) {
                drawContext.method_51738(this.method_46426() + 4, this.method_55442() - 5, this.method_46427() + this.method_25364() / 2, -65536);
            }
            super.renderOverlay(drawContext);
        }

        @Override
        protected boolean shouldDrawOutline() {
            return this.marked;
        }

        @Override
        protected boolean shouldRenderTextWithShadow() {
            return UnicodeTable.this.renderTextShadow;
        }

        @Override
        protected boolean shouldRenderBackground() {
            return UnicodeTable.this.showBlocks || this.method_49606();
        }

        @Override
        public boolean onClick(int button) {
            if (button == 0) {
                if (class_437.method_25442() && UnicodeTable.this.selectionStart != -1) {
                    if (UnicodeTable.this.selectionStart > this.index) {
                        UnicodeTable.this.selectionEnd = UnicodeTable.this.selectionStart;
                        UnicodeTable.this.selectionStart = this.index;
                    } else {
                        UnicodeTable.this.selectionEnd = this.index;
                    }
                } else {
                    UnicodeTable.this.selectionStart = this.index;
                    UnicodeTable.this.selectionEnd = this.index;
                }
            }
            super.onClick(button);
            return true;
        }
    }
}

